/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.lang.reflect.Array;
import org.apache.directory.mavibot.btree.AbstractPage;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BorrowedFromLeftResult;
import org.apache.directory.mavibot.btree.BorrowedFromRightResult;
import org.apache.directory.mavibot.btree.DeleteResult;
import org.apache.directory.mavibot.btree.InMemoryNode;
import org.apache.directory.mavibot.btree.InMemoryValueHolder;
import org.apache.directory.mavibot.btree.InsertResult;
import org.apache.directory.mavibot.btree.KeyCursor;
import org.apache.directory.mavibot.btree.KeyHolder;
import org.apache.directory.mavibot.btree.MergedWithSiblingResult;
import org.apache.directory.mavibot.btree.ModifyResult;
import org.apache.directory.mavibot.btree.NotPresentResult;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.ParentPos;
import org.apache.directory.mavibot.btree.ReadTransaction;
import org.apache.directory.mavibot.btree.RemoveResult;
import org.apache.directory.mavibot.btree.SplitResult;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.TupleCursor;
import org.apache.directory.mavibot.btree.ValueCursor;
import org.apache.directory.mavibot.btree.ValueHolder;
import org.apache.directory.mavibot.btree.exception.EndOfFileExceededException;
import org.apache.directory.mavibot.btree.exception.KeyNotFoundException;

class InMemoryLeaf<K, V>
extends AbstractPage<K, V> {
    protected ValueHolder<V>[] values;

    InMemoryLeaf(BTree<K, V> btree) {
        super(btree);
    }

    InMemoryLeaf(BTree<K, V> btree, long revision, int nbElems) {
        super(btree, revision, nbElems);
        this.values = (InMemoryValueHolder[])Array.newInstance(InMemoryValueHolder.class, nbElems);
    }

    @Override
    public InsertResult<K, V> insert(K key, V value, long revision) throws IOException {
        int pos = this.findPos(key);
        if (pos < 0) {
            int index = -(pos + 1);
            InsertResult<K, V> result = this.replaceElement(revision, key, value, index);
            return result;
        }
        if (this.nbElems < this.btree.getPageSize()) {
            Page<K, V> modifiedPage = this.addElement(revision, key, value, pos);
            ModifyResult<K, Object> result = new ModifyResult<K, Object>(modifiedPage, null);
            result.addCopiedPage(this);
            return result;
        }
        InsertResult<K, V> result = this.addAndSplit(revision, key, value, pos);
        result.addCopiedPage(this);
        return result;
    }

    @Override
    DeleteResult<K, V> delete(K key, V value, long revision, Page<K, V> parent, int parentPos) throws IOException {
        if (this.nbElems == 0) {
            return NotPresentResult.NOT_PRESENT;
        }
        int pos = this.findPos(key);
        if (pos >= 0) {
            return NotPresentResult.NOT_PRESENT;
        }
        Tuple removedElement = null;
        boolean keyRemoved = false;
        int index = -(pos + 1);
        ValueHolder<V> valueHolder = this.values[index];
        if (value == null) {
            removedElement = new Tuple(this.getKey(index), valueHolder.getCursor().next());
            keyRemoved = true;
        } else if (valueHolder.contains(value)) {
            if (valueHolder.size() == 1) {
                removedElement = new Tuple(this.getKey(index), null);
                keyRemoved = true;
            } else {
                valueHolder.remove(value);
                removedElement = new Tuple(this.getKey(index), value);
            }
        } else {
            return NotPresentResult.NOT_PRESENT;
        }
        InMemoryLeaf<K, V> newLeaf = null;
        newLeaf = keyRemoved ? new InMemoryLeaf<K, V>(this.btree, revision, this.nbElems - 1) : new InMemoryLeaf<K, V>(this.btree, revision, this.nbElems);
        RemoveResult<K, V> defaultResult = new RemoveResult<K, V>(newLeaf, removedElement);
        if (parent == null) {
            this.copyAfterRemovingElement(keyRemoved, newLeaf, index);
            defaultResult.addCopiedPage(this);
            return defaultResult;
        }
        if (keyRemoved) {
            int halfSize = this.btree.getPageSize() / 2;
            if (this.nbElems == halfSize) {
                int siblingPos = this.selectSibling(parent, parentPos);
                InMemoryLeaf sibling = (InMemoryLeaf)((InMemoryNode)parent).getPage(siblingPos);
                if (sibling.getNbElems() == halfSize) {
                    DeleteResult result = this.mergeWithSibling(removedElement, revision, sibling, siblingPos < parentPos, index);
                    return result;
                }
                if (siblingPos < parentPos) {
                    DeleteResult result = this.borrowFromLeft(removedElement, revision, sibling, index);
                    return result;
                }
                DeleteResult result = this.borrowFromRight(removedElement, revision, sibling, index);
                return result;
            }
            this.copyAfterRemovingElement(keyRemoved, newLeaf, index);
            defaultResult.addCopiedPage(this);
            return defaultResult;
        }
        System.arraycopy(this.getKeys(), 0, newLeaf.getKeys(), 0, this.nbElems);
        System.arraycopy(this.values, 0, newLeaf.values, 0, this.nbElems);
        defaultResult.addCopiedPage(this);
        return defaultResult;
    }

    private DeleteResult<K, V> mergeWithSibling(Tuple<K, V> removedElement, long revision, InMemoryLeaf<K, V> sibling, boolean isLeft, int pos) throws EndOfFileExceededException, IOException {
        InMemoryLeaf<K, V> newLeaf = new InMemoryLeaf<K, V>(this.btree, revision, this.btree.getPageSize() - 1);
        if (isLeft) {
            System.arraycopy(sibling.getKeys(), 0, newLeaf.getKeys(), 0, sibling.nbElems);
            System.arraycopy(sibling.values, 0, newLeaf.values, 0, sibling.nbElems);
            System.arraycopy(this.getKeys(), 0, newLeaf.getKeys(), sibling.nbElems, pos);
            System.arraycopy(this.values, 0, newLeaf.values, sibling.nbElems, pos);
            System.arraycopy(this.getKeys(), pos + 1, newLeaf.getKeys(), sibling.nbElems + pos, this.nbElems - pos - 1);
            System.arraycopy(this.values, pos + 1, newLeaf.values, sibling.nbElems + pos, this.nbElems - pos - 1);
        } else {
            System.arraycopy(this.getKeys(), 0, newLeaf.getKeys(), 0, pos);
            System.arraycopy(this.values, 0, newLeaf.values, 0, pos);
            System.arraycopy(this.getKeys(), pos + 1, newLeaf.getKeys(), pos, this.nbElems - pos - 1);
            System.arraycopy(this.values, pos + 1, newLeaf.values, pos, this.nbElems - pos - 1);
            System.arraycopy(sibling.getKeys(), 0, newLeaf.getKeys(), this.nbElems - 1, sibling.nbElems);
            System.arraycopy(sibling.values, 0, newLeaf.values, this.nbElems - 1, sibling.nbElems);
        }
        MergedWithSiblingResult<K, V> result = new MergedWithSiblingResult<K, V>(newLeaf, removedElement);
        result.addCopiedPage(this);
        result.addCopiedPage(sibling);
        return result;
    }

    private DeleteResult<K, V> borrowFromLeft(Tuple<K, V> removedElement, long revision, InMemoryLeaf<K, V> sibling, int pos) throws IOException {
        Object siblingKey = sibling.getKey(sibling.getNbElems() - 1);
        ValueHolder<V> siblingValue = sibling.values[sibling.getNbElems() - 1];
        InMemoryLeaf newSibling = (InMemoryLeaf)super.copy(revision, sibling.getNbElems() - 1);
        InMemoryLeaf newLeaf = new InMemoryLeaf(this.btree, revision, this.nbElems);
        newLeaf.setKey(0, new KeyHolder(siblingKey));
        newLeaf.values[0] = siblingValue;
        System.arraycopy(this.getKeys(), 0, newLeaf.getKeys(), 1, pos);
        System.arraycopy(this.values, 0, newLeaf.values, 1, pos);
        System.arraycopy(this.getKeys(), pos + 1, newLeaf.getKeys(), pos + 1, this.getKeys().length - pos - 1);
        System.arraycopy(this.values, pos + 1, newLeaf.values, pos + 1, this.values.length - pos - 1);
        BorrowedFromLeftResult<K, V> result = new BorrowedFromLeftResult<K, V>(newLeaf, newSibling, removedElement);
        result.addCopiedPage(this);
        result.addCopiedPage(sibling);
        return result;
    }

    private DeleteResult<K, V> borrowFromRight(Tuple<K, V> removedElement, long revision, InMemoryLeaf<K, V> sibling, int pos) throws IOException {
        Object siblingKey = sibling.getKey(0);
        ValueHolder<V> siblingHolder = sibling.values[0];
        InMemoryLeaf<K, V> newSibling = new InMemoryLeaf<K, V>(this.btree, revision, sibling.getNbElems() - 1);
        System.arraycopy(sibling.getKeys(), 1, newSibling.getKeys(), 0, sibling.nbElems - 1);
        System.arraycopy(sibling.values, 1, newSibling.values, 0, sibling.nbElems - 1);
        InMemoryLeaf newLeaf = new InMemoryLeaf(this.btree, revision, this.nbElems);
        newLeaf.setKey(this.nbElems - 1, new KeyHolder(siblingKey));
        newLeaf.values[this.nbElems - 1] = siblingHolder;
        System.arraycopy(this.getKeys(), 0, newLeaf.getKeys(), 0, pos);
        System.arraycopy(this.values, 0, newLeaf.values, 0, pos);
        System.arraycopy(this.getKeys(), pos + 1, newLeaf.getKeys(), pos, this.getKeys().length - pos - 1);
        System.arraycopy(this.values, pos + 1, newLeaf.values, pos, this.values.length - pos - 1);
        BorrowedFromRightResult<K, V> result = new BorrowedFromRightResult<K, V>(newLeaf, newSibling, removedElement);
        result.addCopiedPage(this);
        result.addCopiedPage(sibling);
        return result;
    }

    private void copyAfterRemovingElement(boolean keyRemoved, InMemoryLeaf<K, V> newLeaf, int pos) throws IOException {
        if (keyRemoved) {
            if (this.nbElems == 1) {
                return;
            }
            System.arraycopy(this.getKeys(), 0, newLeaf.getKeys(), 0, pos);
            System.arraycopy(this.values, 0, newLeaf.values, 0, pos);
            System.arraycopy(this.getKeys(), pos + 1, newLeaf.getKeys(), pos, this.getKeys().length - pos - 1);
            System.arraycopy(this.values, pos + 1, newLeaf.values, pos, this.values.length - pos - 1);
        } else {
            System.arraycopy(this.getKeys(), 0, newLeaf.getKeys(), 0, this.nbElems);
            System.arraycopy(this.values, 0, newLeaf.values, 0, this.nbElems);
        }
    }

    @Override
    public V get(K key) throws KeyNotFoundException, IOException {
        int pos = this.findPos(key);
        if (pos < 0) {
            InMemoryValueHolder valueHolder = (InMemoryValueHolder)this.values[-(pos + 1)];
            Object value = valueHolder.getCursor().next();
            return value;
        }
        throw KeyNotFoundException.INSTANCE;
    }

    @Override
    public ValueCursor<V> getValues(K key) throws KeyNotFoundException, IOException, IllegalArgumentException {
        if (!this.btree.isAllowDuplicates()) {
            throw new IllegalArgumentException("Duplicates are not allowed in this tree");
        }
        int pos = this.findPos(key);
        if (pos < 0) {
            InMemoryValueHolder valueHolder = (InMemoryValueHolder)this.values[-(pos + 1)];
            return valueHolder.getCursor();
        }
        throw KeyNotFoundException.INSTANCE;
    }

    @Override
    public boolean hasKey(K key) {
        int pos = this.findPos(key);
        return pos < 0;
    }

    @Override
    public boolean contains(K key, V value) throws IOException {
        int pos = this.findPos(key);
        if (pos < 0) {
            ValueHolder<V> valueHolder = this.values[-(pos + 1)];
            return valueHolder.contains(value);
        }
        return false;
    }

    @Override
    ValueHolder<V> getValue(int pos) {
        if (pos < this.nbElems) {
            return this.values[pos];
        }
        return null;
    }

    @Override
    void setValue(int pos, ValueHolder<V> value) {
        this.values[pos] = value;
    }

    @Override
    public TupleCursor<K, V> browse(K key, ReadTransaction<K, V> transaction, ParentPos<K, V>[] stack, int depth) {
        int pos = this.findPos(key);
        TupleCursor<K, V> cursor = null;
        if (pos < 0) {
            pos = -(pos + 1);
            ParentPos parentPos = new ParentPos(this, pos);
            parentPos.valueCursor = this.values[pos].getCursor();
            stack[depth] = parentPos;
            cursor = new TupleCursor<K, V>(transaction, stack, depth);
        } else if (pos < this.nbElems) {
            ParentPos parentPos = new ParentPos(this, pos);
            parentPos.valueCursor = this.values[pos].getCursor();
            stack[depth] = parentPos;
            cursor = new TupleCursor<K, V>(transaction, stack, depth);
        } else if (this.nbElems > 0) {
            ParentPos parentPos = new ParentPos(this, this.nbElems - 1);
            parentPos.valueCursor = this.values[this.nbElems - 1].getCursor();
            stack[depth] = parentPos;
            cursor = new TupleCursor<K, V>(transaction, stack, depth);
            try {
                cursor.afterLast();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            stack[depth] = null;
            cursor = new TupleCursor<K, V>(transaction, null, 0);
        }
        return cursor;
    }

    @Override
    public TupleCursor<K, V> browse(ReadTransaction<K, V> transaction, ParentPos<K, V>[] stack, int depth) {
        int pos = 0;
        TupleCursor<K, V> cursor = null;
        if (this.nbElems == 0) {
            stack[depth] = new ParentPos(null, -1);
            return new TupleCursor<K, V>(transaction, stack, depth);
        }
        ParentPos parentPos = new ParentPos(this, pos);
        parentPos.valueCursor = this.values[0].getCursor();
        stack[depth] = parentPos;
        cursor = new TupleCursor<K, V>(transaction, stack, depth);
        return cursor;
    }

    @Override
    public KeyCursor<K> browseKeys(ReadTransaction<K, K> transaction, ParentPos<K, K>[] stack, int depth) {
        int pos = 0;
        KeyCursor<K> cursor = null;
        if (this.nbElems == 0) {
            stack[depth] = new ParentPos(null, -1);
            return new KeyCursor<K>(transaction, stack, depth);
        }
        ParentPos parentPos = new ParentPos(this, pos);
        stack[depth] = parentPos;
        cursor = new KeyCursor<K>(transaction, stack, depth);
        return cursor;
    }

    private Page<K, V> copy(long revision, int nbElems) {
        InMemoryLeaf<K, V> newLeaf = new InMemoryLeaf<K, V>(this.btree, revision, nbElems);
        System.arraycopy(this.getKeys(), 0, newLeaf.getKeys(), 0, nbElems);
        System.arraycopy(this.values, 0, newLeaf.values, 0, nbElems);
        return newLeaf;
    }

    private InsertResult<K, V> replaceElement(long revision, K key, V value, int pos) throws IOException {
        InMemoryLeaf newLeaf = this;
        ValueHolder<V> valueHolder = this.values[pos];
        boolean valueExists = valueHolder.contains(value);
        if (this.revision != revision) {
            newLeaf = (InMemoryLeaf)this.copy(revision, this.nbElems);
        }
        valueHolder = newLeaf.values[pos];
        Object replacedValue = null;
        if (!valueExists && this.btree.isAllowDuplicates()) {
            valueHolder.add(value);
            newLeaf.values[pos] = valueHolder;
        } else if (valueExists && this.btree.isAllowDuplicates()) {
            replacedValue = valueHolder.remove(value);
            valueHolder.add(value);
        } else if (!this.btree.isAllowDuplicates()) {
            replacedValue = valueHolder.replaceValueArray(value);
        }
        ModifyResult result = new ModifyResult(newLeaf, replacedValue);
        result.addCopiedPage(this);
        return result;
    }

    private Page<K, V> addElement(long revision, K key, V value, int pos) {
        InMemoryLeaf<K, V> newLeaf = new InMemoryLeaf<K, V>(this.btree, revision, this.nbElems + 1);
        InMemoryValueHolder<Object> valueHolder = new InMemoryValueHolder<Object>(this.btree, value);
        if (this.nbElems == 0) {
            newLeaf.setKey(0, new KeyHolder<K>(key));
            newLeaf.values[0] = valueHolder;
        } else {
            System.arraycopy(this.getKeys(), 0, newLeaf.getKeys(), 0, pos);
            System.arraycopy(this.values, 0, newLeaf.values, 0, pos);
            newLeaf.setKey(pos, new KeyHolder<K>(key));
            newLeaf.values[pos] = valueHolder;
            System.arraycopy(this.getKeys(), pos, newLeaf.getKeys(), pos + 1, this.getKeys().length - pos);
            System.arraycopy(this.values, pos, newLeaf.values, pos + 1, this.values.length - pos);
        }
        return newLeaf;
    }

    private InsertResult<K, V> addAndSplit(long revision, K key, V value, int pos) {
        int middle = this.btree.getPageSize() >> 1;
        InMemoryLeaf<K, V> leftLeaf = null;
        InMemoryLeaf<K, V> rightLeaf = null;
        InMemoryValueHolder<Object> valueHolder = new InMemoryValueHolder<Object>(this.btree, value);
        if (pos <= middle) {
            leftLeaf = new InMemoryLeaf<K, V>(this.btree, revision, middle + 1);
            System.arraycopy(this.getKeys(), 0, leftLeaf.getKeys(), 0, pos);
            System.arraycopy(this.values, 0, leftLeaf.values, 0, pos);
            leftLeaf.setKey(pos, new KeyHolder<K>(key));
            leftLeaf.values[pos] = valueHolder;
            System.arraycopy(this.getKeys(), pos, leftLeaf.getKeys(), pos + 1, middle - pos);
            System.arraycopy(this.values, pos, leftLeaf.values, pos + 1, middle - pos);
            rightLeaf = new InMemoryLeaf<K, V>(this.btree, revision, middle);
            System.arraycopy(this.getKeys(), middle, rightLeaf.getKeys(), 0, middle);
            System.arraycopy(this.values, middle, rightLeaf.values, 0, middle);
        } else {
            leftLeaf = new InMemoryLeaf<K, V>(this.btree, revision, middle);
            System.arraycopy(this.getKeys(), 0, leftLeaf.getKeys(), 0, middle);
            System.arraycopy(this.values, 0, leftLeaf.values, 0, middle);
            rightLeaf = new InMemoryLeaf<K, V>(this.btree, revision, middle + 1);
            int rightPos = pos - middle;
            System.arraycopy(this.getKeys(), middle, rightLeaf.getKeys(), 0, rightPos);
            System.arraycopy(this.values, middle, rightLeaf.values, 0, rightPos);
            rightLeaf.setKey(rightPos, new KeyHolder<K>(key));
            rightLeaf.values[rightPos] = valueHolder;
            System.arraycopy(this.getKeys(), pos, rightLeaf.getKeys(), rightPos + 1, this.nbElems - pos);
            System.arraycopy(this.values, pos, rightLeaf.values, rightPos + 1, this.nbElems - pos);
        }
        Object pivot = rightLeaf.getKey(0);
        SplitResult result = new SplitResult(pivot, leftLeaf, rightLeaf);
        return result;
    }

    @Override
    public Tuple<K, V> findLeftMost() throws IOException {
        Object val = null;
        val = this.values[0].getCursor().next();
        return new Tuple(this.getKey(0), val);
    }

    @Override
    public Tuple<K, V> findRightMost() throws EndOfFileExceededException, IOException {
        Object val = null;
        ValueCursor<V> valueCursor = this.values[this.nbElems - 1].getCursor();
        valueCursor.afterLast();
        val = valueCursor.prev();
        return new Tuple(this.getKey(this.nbElems - 1), val);
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean isNode() {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Leaf[");
        sb.append(super.toString());
        sb.append("] -> {");
        if (this.nbElems > 0) {
            boolean isFirst = true;
            for (int i = 0; i < this.nbElems; ++i) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append("<").append(this.getKey(i)).append(",").append(this.values[i]).append(">");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String dumpPage(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs);
        if (this.nbElems > 0) {
            boolean isFirst = true;
            for (int i = 0; i < this.nbElems; ++i) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append("<").append(this.getKey(i)).append(",").append(this.values[i]).append(">");
            }
        }
        sb.append("\n");
        return sb.toString();
    }
}

