/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.opensaml.MalformedException;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SAMLException
extends Exception
implements Cloneable {
    public static final QName SUCCESS = new QName("urn:oasis:names:tc:SAML:1.0:protocol", "Success");
    public static final QName REQUESTER = new QName("urn:oasis:names:tc:SAML:1.0:protocol", "Requester");
    public static final QName RESPONDER = new QName("urn:oasis:names:tc:SAML:1.0:protocol", "Responder");
    public static final QName VERSION = new QName("urn:oasis:names:tc:SAML:1.0:protocol", "VersionMismatch");
    protected String msg = null;
    protected Exception e = null;
    protected ArrayList codes = new ArrayList();
    protected Node root = null;
    protected SAMLObject parentObject = null;
    protected Logger log = Logger.getLogger(this.getClass());
    protected SAMLConfig config = SAMLConfig.instance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SAMLException getInstance(Element element) throws SAMLException {
        if (element == null) {
            throw new MalformedException(RESPONDER, "SAMLException.getInstance() given an empty DOM");
        }
        try {
            String string;
            Element element2;
            Element element3 = XML.getLastChildElement(element, "urn:oasis:names:tc:SAML:1.0:protocol", "StatusDetail");
            if (element3 != null && (element2 = XML.getFirstChildElement(element3, "http://www.opensaml.org", "ExceptionClass")) != null && element2.getFirstChild() != null && element2.getFirstChild().getNodeType() == 3 && (string = element2.getFirstChild().getNodeValue()) != null && string.length() > 0) {
                Class<?> clazz = Class.forName(string);
                Class[] classArray = new Class[]{Class.forName("org.w3c.dom.Element")};
                Object[] objectArray = new Object[]{element};
                Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
                SAMLException sAMLException = (SAMLException)constructor.newInstance(objectArray);
                return sAMLException;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Category.getInstance((String)"SAMLException").error((Object)("unable to locate implementation class for exception: " + classNotFoundException.getMessage()));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Category.getInstance((String)"SAMLException").error((Object)("unable to bind to constructor for exception: " + noSuchMethodException.getMessage()));
        }
        catch (InstantiationException instantiationException) {
            Category.getInstance((String)"SAMLException").error((Object)("unable to build implementation object for exception: " + instantiationException.getMessage()));
        }
        catch (IllegalAccessException illegalAccessException) {
            Category.getInstance((String)"SAMLException").error((Object)("unable to access implementation of exception: " + illegalAccessException.getMessage()));
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            Category.getInstance((String)"SAMLException").error((Object)("caught unknown exception while building exception object: " + invocationTargetException.getTargetException().getMessage()));
        }
        finally {
            NDC.pop();
        }
        return new SAMLException(element);
    }

    public static SAMLException getInstance(InputStream inputStream) throws SAMLException {
        try {
            Document document = XML.parserPool.parse(inputStream);
            return SAMLException.getInstance(document.getDocumentElement());
        }
        catch (SAXException sAXException) {
            NDC.push((String)"getInstance");
            Category.getInstance((String)"SAMLException").error((Object)("caught an exception while parsing a stream:\n" + sAXException.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLException.getInstance() caught exception while parsing a stream", (Exception)sAXException);
        }
        catch (IOException iOException) {
            NDC.push((String)"getInstance");
            Category.getInstance((String)"SAMLException").error((Object)("caught an exception while parsing a stream:\n" + iOException.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLException.getInstance() caught exception while parsing a stream", (Exception)iOException);
        }
    }

    protected SAMLException(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public SAMLException(String string) {
        super(string);
        this.msg = string;
    }

    public SAMLException(String string, Exception exception) {
        super(string, exception);
        this.msg = string;
        this.e = exception;
    }

    public SAMLException(Collection collection) {
        if (collection != null) {
            this.codes.addAll(collection);
        }
    }

    public SAMLException(Collection collection, String string) {
        super(string);
        this.msg = string;
        if (collection != null) {
            this.codes.addAll(collection);
        }
    }

    public SAMLException(Collection collection, Exception exception) {
        super(exception);
        this.e = exception;
        if (collection != null) {
            this.codes.addAll(collection);
        }
    }

    public SAMLException(Collection collection, String string, Exception exception) {
        super(string, exception);
        this.msg = string;
        this.e = exception;
        if (collection != null) {
            this.codes.addAll(collection);
        }
    }

    public SAMLException(QName qName) {
        if (qName != null) {
            this.codes.add(qName);
        }
    }

    public SAMLException(QName qName, String string) {
        super(string);
        this.msg = string;
        if (qName != null) {
            this.codes.add(qName);
        }
    }

    public SAMLException(QName qName, Exception exception) {
        super(exception);
        this.e = exception;
        if (qName != null) {
            this.codes.add(qName);
        }
    }

    public SAMLException(QName qName, String string, Exception exception) {
        super(string, exception);
        this.msg = string;
        this.e = exception;
        if (qName != null) {
            this.codes.add(qName);
        }
    }

    public SAMLException setParent(SAMLObject sAMLObject) throws SAMLException {
        if (this.parentObject != null) {
            throw new SAMLException("SAMLObject.setParent() called on an already-contained object");
        }
        if (sAMLObject == null) {
            throw new IllegalArgumentException("SAMLObject.setParent() called with null parameter");
        }
        this.parentObject = sAMLObject;
        return this;
    }

    public SAMLObject getParent() {
        return this.parentObject;
    }

    public void fromDOM(Element element) throws SAMLException {
        if (element == null) {
            throw new MalformedException("SAMLException.fromDOM() given an empty DOM");
        }
        this.root = element;
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:protocol", "Status")) {
            throw new MalformedException(RESPONDER, "SAMLException.fromDOM() requires samlp:Status at root");
        }
        Element element2 = XML.getFirstChildElement(element, "urn:oasis:names:tc:SAML:1.0:protocol", "StatusMessage");
        if (element2 != null && element2.getFirstChild() != null) {
            this.msg = element2.getFirstChild().getNodeValue();
        }
        NodeList nodeList = element.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:protocol", "StatusCode");
        for (int i = 0; nodeList != null && i < nodeList.getLength(); ++i) {
            QName qName = XML.getQNameAttribute((Element)nodeList.item(i), null, "Value");
            if (qName == null) {
                throw new MalformedException(RESPONDER, "SAMLException.fromDOM() unable to evaluate QName Value");
            }
            this.codes.add(qName);
        }
    }

    public void toStream(OutputStream outputStream) throws IOException, SAMLException {
        try {
            Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/2001/10/xml-exc-c14n#");
            outputStream.write(canonicalizer.canonicalizeSubtree(this.toDOM()));
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new IOException(invalidCanonicalizerException.getMessage());
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new IOException(canonicalizationException.getMessage());
        }
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        if (this.root != null) {
            if (this.root.getOwnerDocument() != document) {
                this.root = document.adoptNode(this.root);
            }
        } else {
            Node node;
            Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "Status");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:samlp", "urn:oasis:names:tc:SAML:1.0:protocol");
            if (this.codes == null || this.codes.isEmpty()) {
                node = document.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "StatusCode");
                node.setAttributeNS(null, "Value", "samlp:" + RESPONDER.getLocalPart());
                element.appendChild(node);
            } else {
                node = element;
                Iterator iterator = this.codes.iterator();
                while (iterator.hasNext()) {
                    QName qName = (QName)iterator.next();
                    Element element2 = document.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "StatusCode");
                    String string = qName.getNamespaceURI();
                    if (!string.equals("urn:oasis:names:tc:SAML:1.0:protocol")) {
                        element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:code", string);
                        string = "code:";
                    } else {
                        string = "samlp:";
                    }
                    element2.setAttributeNS(null, "Value", string + qName.getLocalPart());
                    node = node.appendChild(element2);
                }
            }
            if (!XML.isEmpty(this.getMessage())) {
                node = document.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "StatusMessage");
                node.appendChild(document.createTextNode(this.getMessage()));
                element.appendChild(node);
            }
            if (!(this instanceof SAMLException)) {
                node = document.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "StatusDetail");
                node.appendChild(document.createElementNS("http://www.opensaml.org", "ExceptionClass")).appendChild(document.createTextNode(this.getClass().getName()));
            }
            this.root = element;
        }
        if (bl) {
            ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
        }
        return this.root;
    }

    public Node toDOM(boolean bl) throws SAMLException {
        if (this.root != null) {
            return this.root;
        }
        return this.toDOM(XML.parserPool.newDocument(), bl);
    }

    public Node toDOM(Document document) throws SAMLException {
        return this.toDOM(document, true);
    }

    public Node toDOM() throws SAMLException {
        return this.toDOM(true);
    }

    public Iterator getCodes() {
        return this.codes.iterator();
    }

    public String getMessage() {
        if (this.msg != null && this.e != null) {
            return this.msg + " (wrapped: " + this.e.getMessage() + ')';
        }
        if (this.e != null) {
            return "(wrapped: " + this.e.getMessage() + ")";
        }
        return this.msg;
    }

    public Exception getException() {
        return this.e;
    }

    public String toString() {
        return this.e != null ? this.e.toString() : super.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLException sAMLException = (SAMLException)super.clone();
        sAMLException.codes = (ArrayList)this.codes.clone();
        sAMLException.root = null;
        sAMLException.parentObject = null;
        return sAMLException;
    }
}

