/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.csws;

import com.opentext.livelink.service.core.DataValue;
import com.opentext.livelink.service.core.DateValue;
import com.opentext.livelink.service.core.PageHandle;
import com.opentext.livelink.service.core.PrimitiveValue;
import com.opentext.livelink.service.core.StringValue;
import com.opentext.livelink.service.docman.Attribute;
import com.opentext.livelink.service.docman.AttributeGroup;
import com.opentext.livelink.service.docman.AttributeGroupDefinition;
import com.opentext.livelink.service.docman.Metadata;
import com.opentext.livelink.service.docman.Node;
import com.opentext.livelink.service.docman.NodePermissions;
import com.opentext.livelink.service.docman.NodeRight;
import com.opentext.livelink.service.docman.NodeRights;
import com.opentext.livelink.service.docman.Version;
import com.opentext.livelink.service.memberservice.Member;
import com.opentext.livelink.service.searchservices.SGraph;
import com.opentext.livelink.service.searchservices.SNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.connectorcommon.common.InterruptibleSocketFactory;
import org.apache.manifoldcf.connectorcommon.common.XThreadInputStream;
import org.apache.manifoldcf.connectorcommon.common.XThreadOutputStream;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.common.DateParser;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.Configuration;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.csws.MatchMap;
import org.apache.manifoldcf.crawler.connectors.csws.Messages;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;
import org.apache.manifoldcf.csws.CswsSession;
import org.apache.manifoldcf.ui.util.Encoder;

public class CswsConnector
extends BaseRepositoryConnector {
    public static final String _rcsid = "@(#)$Id: CswsConnector.java 996524 2010-09-13 13:38:01Z kwright $";
    private static final String EDIT_SPECIFICATION_JS = "editSpecification.js";
    private static final String EDIT_CONFIGURATION_JS = "editConfiguration.js";
    private static final String EDIT_SPECIFICATION_PATHS_HTML = "editSpecification_Paths.html";
    private static final String EDIT_SPECIFICATION_FILTERS_HTML = "editSpecification_Filters.html";
    private static final String EDIT_SPECIFICATION_SECURITY_HTML = "editSpecification_Security.html";
    private static final String EDIT_SPECIFICATION_METADATA_HTML = "editSpecification_Metadata.html";
    private static final String EDIT_CONFIGURATION_SERVER_HTML = "editConfiguration_Server.html";
    private static final String EDIT_CONFIGURATION_ACCESS_HTML = "editConfiguration_Access.html";
    private static final String EDIT_CONFIGURATION_VIEW_HTML = "editConfiguration_View.html";
    private static final String VIEW_SPECIFICATION_HTML = "viewSpecification.html";
    private static final String VIEW_CONFIGURATION_HTML = "viewConfiguration.html";
    private static final String TAB_NAME_PARAM = "TabName";
    private static final String ACTIVITY_SEED = "find documents";
    private static final String ACTIVITY_FETCH = "fetch document";
    private static final String defaultAuthorityDenyToken = "DEAD_AUTHORITY";
    protected static final String GENERAL_NAME_FIELD = "general_name";
    protected static final String GENERAL_DESCRIPTION_FIELD = "general_description";
    protected static final String GENERAL_CREATIONDATE_FIELD = "general_creationdate";
    protected static final String GENERAL_MODIFYDATE_FIELD = "general_modifydate";
    protected static final String GENERAL_OWNER = "general_owner";
    protected static final String GENERAL_CREATOR = "general_creator";
    protected static final String GENERAL_MODIFIER = "general_modifier";
    protected static final String GENERAL_PARENTID = "general_parentid";
    private static final String enterpriseWSName = "EnterpriseWS";
    private static final String categoryWSName = "CategoriesWS";
    private boolean hasSessionParameters = false;
    private boolean hasConnected = false;
    private long expirationTime = -1L;
    private static final long expirationInterval = 300000L;
    private CswsSession cswsSession = null;
    private Map<String, Node> workspaceNodes = new HashMap<String, Node>();
    private Long enterpriseWSID = null;
    private Long categoryWSID = null;
    private String serverProtocol = null;
    private String serverName = null;
    private int serverPort = -1;
    private String serverUsername = null;
    private String serverPassword = null;
    private String authenticationServicePath = null;
    private String documentManagementServicePath = null;
    private String contentServiceServicePath = null;
    private String memberServiceServicePath = null;
    private String searchServiceServicePath = null;
    private String dataCollection = null;
    private String serverHTTPNTLMDomain = null;
    private String serverHTTPNTLMUsername = null;
    private String serverHTTPNTLMPassword = null;
    private IKeystoreManager serverHTTPSKeystore = null;
    private String viewProtocol = null;
    private String viewServerName = null;
    private String viewPort = null;
    private String viewCgiPath = null;
    private String viewAction = null;
    private HttpClientConnectionManager connectionManager = null;
    private HttpClient httpClient = null;
    private String viewBasePath = null;
    private static final String[] activitiesList = new String[]{"find documents", "fetch document"};
    private static String currentHost = null;
    private static InetAddress currentAddr = null;

    public int getConnectorModel() {
        return 10;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.serverName = this.params.getParameter("Server name");
    }

    public String[] getBinNames(String documentIdentifier) {
        return new String[]{this.serverName};
    }

    protected void getSessionParameters() throws ManifoldCFException {
        if (!this.hasSessionParameters) {
            Object viewPortString;
            String serverHTTPSKeystoreData;
            this.viewProtocol = this.params.getParameter("View protocol");
            this.viewServerName = this.params.getParameter("View server name");
            this.viewPort = this.params.getParameter("View port");
            this.viewCgiPath = this.params.getParameter("View CGI path");
            this.viewAction = this.params.getParameter("View Action");
            this.serverProtocol = this.params.getParameter("Server protocol");
            String serverPortString = this.params.getParameter("Server port");
            this.serverUsername = this.params.getParameter("Server user name");
            this.serverPassword = this.params.getObfuscatedParameter("Server password");
            this.authenticationServicePath = this.params.getParameter("Server Authentication Service path");
            this.documentManagementServicePath = this.params.getParameter("Server DocumentManagement Service path");
            this.contentServiceServicePath = this.params.getParameter("Server ContentService Service path");
            this.memberServiceServicePath = this.params.getParameter("Server MemberService Service path");
            this.searchServiceServicePath = this.params.getParameter("Server SearchService Service path");
            this.dataCollection = this.params.getParameter("Data Collection");
            this.serverHTTPNTLMDomain = this.params.getParameter("Server HTTP NTLM domain");
            this.serverHTTPNTLMUsername = this.params.getParameter("Server HTTP NTLM user name");
            this.serverHTTPNTLMPassword = this.params.getObfuscatedParameter("Server HTTP NTLM password");
            if (this.serverProtocol == null || this.serverProtocol.length() == 0) {
                this.serverProtocol = "http";
            }
            this.serverPort = serverPortString == null ? 2099 : new Integer(serverPortString);
            if (this.serverHTTPNTLMDomain != null && this.serverHTTPNTLMDomain.length() == 0) {
                this.serverHTTPNTLMDomain = null;
            }
            if (this.serverHTTPNTLMUsername == null || this.serverHTTPNTLMUsername.length() == 0) {
                this.serverHTTPNTLMUsername = null;
                this.serverHTTPNTLMPassword = null;
            }
            if ((serverHTTPSKeystoreData = this.params.getParameter("Server HTTPS truststore")) != null) {
                this.serverHTTPSKeystore = KeystoreManagerFactory.make((String)"", (String)serverHTTPSKeystoreData);
            }
            if (this.viewProtocol == null || this.viewProtocol.length() == 0) {
                this.viewProtocol = this.serverProtocol == null ? "http" : this.serverProtocol;
            }
            if (this.viewPort == null || this.viewPort.length() == 0) {
                this.viewPort = this.serverProtocol == null || !this.viewProtocol.equals(this.serverProtocol) ? (!this.viewProtocol.equals("https") ? "80" : "443") : new Integer(this.serverPort).toString();
            }
            try {
                int portNumber = Integer.parseInt(this.viewPort);
                viewPortString = ":" + Integer.toString(portNumber);
                if (!this.viewProtocol.equals("https")) {
                    if (portNumber == 80) {
                        viewPortString = "";
                    }
                } else if (portNumber == 443) {
                    viewPortString = "";
                }
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Bad view port: " + e.getMessage(), (Throwable)e);
            }
            if (this.viewCgiPath == null || this.viewCgiPath.length() == 0) {
                this.viewCgiPath = "";
            }
            if (this.viewServerName == null || this.viewServerName.length() == 0) {
                this.viewServerName = this.serverName;
            }
            this.viewBasePath = this.viewProtocol + "://" + this.viewServerName + (String)viewPortString + this.viewCgiPath;
            this.hasSessionParameters = true;
        }
    }

    protected void getSession() throws ManifoldCFException, ServiceInterruption {
        this.getSessionParameters();
        if (!this.hasConnected) {
            SSLConnectionSocketFactory myFactory;
            int socketTimeout = 900000;
            int connectionTimeout = 300000;
            if (this.serverHTTPSKeystore != null) {
                InterruptibleSocketFactory mySslFactory = new InterruptibleSocketFactory(this.serverHTTPSKeystore.getSecureSocketFactory(), (long)connectionTimeout);
                myFactory = new SSLConnectionSocketFactory((SSLSocketFactory)mySslFactory, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            } else {
                Object mySslFactory = null;
                myFactory = SSLConnectionSocketFactory.getSocketFactory();
            }
            PoolingHttpClientConnectionManager poolingConnectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)myFactory).build());
            poolingConnectionManager.setDefaultMaxPerRoute(1);
            poolingConnectionManager.setValidateAfterInactivity(2000);
            poolingConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(socketTimeout).build());
            this.connectionManager = poolingConnectionManager;
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            if (this.serverHTTPNTLMDomain != null) {
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new NTCredentials(this.serverHTTPNTLMUsername, this.serverHTTPNTLMPassword, currentHost, this.serverHTTPNTLMDomain));
            }
            HttpClientBuilder builder = HttpClients.custom().setConnectionManager(this.connectionManager).disableAutomaticRetries().setDefaultRequestConfig(RequestConfig.custom().setCircularRedirectsAllowed(true).setSocketTimeout(socketTimeout).setExpectContinueEnabled(true).setConnectTimeout(connectionTimeout).setConnectionRequestTimeout(socketTimeout).build()).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setRequestExecutor(new HttpRequestExecutor(socketTimeout)).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
            this.httpClient = builder.build();
            String baseURL = this.serverProtocol + "://" + this.serverName + ":" + this.serverPort;
            String authenticationServiceURL = baseURL + this.authenticationServicePath;
            String documentManagementServiceURL = baseURL + this.documentManagementServicePath;
            String contentServiceServiceURL = baseURL + this.contentServiceServicePath;
            String memberServiceServiceURL = baseURL + this.memberServiceServicePath;
            String searchServiceServiceURL = baseURL + this.searchServiceServicePath;
            if (Logging.connectors.isDebugEnabled()) {
                String passwordExists = this.serverPassword != null && this.serverPassword.length() > 0 ? "password exists" : "";
                Logging.connectors.debug((Object)("Csws: Csws Session: Server='" + this.serverName + "'; port='" + this.serverPort + "'; user name='" + this.serverUsername + "'; " + passwordExists));
            }
            this.cswsSession = new CswsSession(this.serverUsername, this.serverPassword, this.serverHTTPSKeystore, 900000L, authenticationServiceURL, documentManagementServiceURL, contentServiceServiceURL, memberServiceServiceURL, searchServiceServiceURL);
            GetSessionThread t = new GetSessionThread();
            try {
                t.start();
                t.finishUp();
                this.hasConnected = true;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
        }
        this.expirationTime = System.currentTimeMillis() + 300000L;
    }

    protected static int executeMethodViaThread(HttpClient client, HttpRequestBase executeMethod) throws InterruptedException, HttpException, IOException {
        ExecuteMethodThread t = new ExecuteMethodThread(client, executeMethod);
        t.start();
        try {
            int n = t.getResponseCode();
            return n;
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw e;
        }
        finally {
            t.abort();
            t.finishUp();
        }
    }

    public String check() throws ManifoldCFException {
        try {
            this.hasConnected = false;
            this.getSession();
            return super.check();
        }
        catch (ServiceInterruption e) {
            return "Transient error: " + e.getMessage();
        }
        catch (ManifoldCFException e) {
            if (e.getErrorCode() == 2) {
                throw e;
            }
            return "Error: " + e.getMessage();
        }
    }

    public void poll() throws ManifoldCFException {
        if (!this.hasConnected) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.expirationTime) {
            this.hasConnected = false;
            this.expirationTime = -1L;
            if (this.connectionManager != null) {
                this.connectionManager.shutdown();
                this.connectionManager = null;
            }
        }
    }

    public boolean isConnected() {
        return this.hasConnected;
    }

    public void disconnect() throws ManifoldCFException {
        this.hasSessionParameters = false;
        this.hasConnected = false;
        this.expirationTime = -1L;
        this.serverProtocol = null;
        this.serverName = null;
        this.serverPort = -1;
        this.serverUsername = null;
        this.serverPassword = null;
        this.authenticationServicePath = null;
        this.documentManagementServicePath = null;
        this.contentServiceServicePath = null;
        this.memberServiceServicePath = null;
        this.searchServiceServicePath = null;
        this.serverHTTPNTLMDomain = null;
        this.serverHTTPNTLMUsername = null;
        this.serverHTTPNTLMPassword = null;
        this.serverHTTPSKeystore = null;
        this.viewPort = null;
        this.viewServerName = null;
        this.viewProtocol = null;
        this.viewCgiPath = null;
        this.viewBasePath = null;
        this.workspaceNodes.clear();
        this.enterpriseWSID = null;
        this.categoryWSID = null;
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
            this.connectionManager = null;
        }
        super.disconnect();
    }

    public String[] getActivitiesList() {
        return activitiesList;
    }

    protected String convertToViewURI(String documentIdentifier) throws ManifoldCFException {
        if (!documentIdentifier.startsWith("D")) {
            return null;
        }
        String objectID = documentIdentifier.substring(1);
        String viewURL = null;
        switch (this.viewAction) {
            case "download": {
                viewURL = this.viewBasePath + "?func=ll&objAction=download&objID=" + objectID;
                break;
            }
            case "open": {
                viewURL = this.viewBasePath + "/open/" + objectID;
                break;
            }
            case "overview": {
                viewURL = this.viewBasePath + "?func=ll&objAction=overview&objID=" + objectID;
                break;
            }
            default: {
                viewURL = this.viewBasePath + "?func=ll&objAction=download&objID=" + objectID;
            }
        }
        return viewURL;
    }

    public boolean requestInfo(Configuration output, String command) throws ManifoldCFException {
        if (command.equals("workspaces")) {
            try {
                String[] workspaces = this.getWorkspaceNames();
                int i = 0;
                while (i < workspaces.length) {
                    String workspace = workspaces[i++];
                    ConfigurationNode node = new ConfigurationNode("workspace");
                    node.setValue(workspace);
                    output.addChild(output.getChildCount(), node);
                }
            }
            catch (ServiceInterruption e) {
                ManifoldCF.createServiceInterruptionNode((Configuration)output, (ServiceInterruption)e);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else if (command.startsWith("folders/")) {
            String path = command.substring("folders/".length());
            try {
                String[] folders = this.getChildFolderNames(path);
                int i = 0;
                while (i < folders.length) {
                    String folder = folders[i++];
                    ConfigurationNode node = new ConfigurationNode("folder");
                    node.setValue(folder);
                    output.addChild(output.getChildCount(), node);
                }
            }
            catch (ServiceInterruption e) {
                ManifoldCF.createServiceInterruptionNode((Configuration)output, (ServiceInterruption)e);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else if (command.startsWith("categories/")) {
            String path = command.substring("categories/".length());
            try {
                String[] categories = this.getChildCategoryNames(path);
                int i = 0;
                while (i < categories.length) {
                    String category = categories[i++];
                    ConfigurationNode node = new ConfigurationNode("category");
                    node.setValue(category);
                    output.addChild(output.getChildCount(), node);
                }
            }
            catch (ServiceInterruption e) {
                ManifoldCF.createServiceInterruptionNode((Configuration)output, (ServiceInterruption)e);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else if (command.startsWith("categoryattributes/")) {
            String path = command.substring("categoryattributes/".length());
            try {
                String[] attributes = this.getCategoryAttributes(path);
                int i = 0;
                while (i < attributes.length) {
                    String attribute = attributes[i++];
                    ConfigurationNode node = new ConfigurationNode("attribute");
                    node.setValue(attribute);
                    output.addChild(output.getChildCount(), node);
                }
            }
            catch (ServiceInterruption e) {
                ManifoldCF.createServiceInterruptionNode((Configuration)output, (ServiceInterruption)e);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else {
            return super.requestInfo(output, command);
        }
        return true;
    }

    /*
     * Loose catch block
     */
    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        Logging.connectors.debug((Object)"Csws: addSeedDocuments");
        this.getSession();
        CswsContext llc = new CswsContext();
        ObjectInformation rootValue = llc.getObjectInformation(this.enterpriseWSID);
        if (!rootValue.exists()) {
            Logging.connectors.warn((Object)"Csws: Could not look up root workspace object during seeding!  Retrying -");
            throw new ServiceInterruption("Service interruption during seeding", (Throwable)new ManifoldCFException("Could not looking root workspace object during seeding"), System.currentTimeMillis() + 60000L, System.currentTimeMillis() + 600000L, -1, true);
        }
        Logging.connectors.debug((Object)"Csws: Picking up starting paths");
        boolean doUserWorkspaces = false;
        for (int i = 0; i < spec.getChildCount(); ++i) {
            block20: {
                SpecificationNode n = spec.getChild(i);
                if (n.getType().equals("startpoint")) {
                    long beginTime = System.currentTimeMillis();
                    String path = n.getAttributeValue("path");
                    Long vaf = rootValue.getPathId(path);
                    if (vaf != null) {
                        activities.recordActivity(new Long(beginTime), ACTIVITY_SEED, null, path, "OK", null, null);
                        String newID = "F" + vaf;
                        activities.addSeedDocument(newID);
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("Csws: Seed = '" + newID + "'"));
                        }
                    } else {
                        Logging.connectors.debug((Object)("Csws: Path '" + path + "' no longer present."));
                        activities.recordActivity(new Long(beginTime), ACTIVITY_SEED, null, path, "NOT FOUND", null, null);
                    }
                } else if (n.getType().equals("userworkspace")) {
                    String value = n.getAttributeValue("value");
                    if (value != null && value.equals("true")) {
                        doUserWorkspaces = true;
                    } else if (value != null && value.equals("false")) {
                        doUserWorkspaces = false;
                    }
                }
                if (doUserWorkspaces) {
                    ListUsersThread t = new ListUsersThread();
                    try {
                        GetUserResultsThread t2;
                        Logging.connectors.debug((Object)"Csws: Going through user workspaces");
                        t.start();
                        PageHandle resultPageHandle = t.finishUp();
                        block5: while (true) {
                            t2 = new GetUserResultsThread(resultPageHandle);
                            t2.start();
                            List<? extends Member> childrenDocs = t2.finishUp();
                            if (childrenDocs != null) {
                                Iterator<? extends Member> iterator = childrenDocs.iterator();
                                while (true) {
                                    if (!iterator.hasNext()) continue block5;
                                    Member m = iterator.next();
                                    long childID = m.getID();
                                    if (childID == 1000L || childID == 1001L) continue;
                                    if (Logging.connectors.isDebugEnabled()) {
                                        Logging.connectors.debug((Object)("Csws: Found a user: ID=" + childID));
                                    }
                                    activities.addSeedDocument("F" + childID);
                                }
                            }
                            break block20;
                            break;
                        }
                        catch (InterruptedException e) {
                            t2.interrupt();
                            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                        }
                    }
                    catch (InterruptedException e) {
                        t.interrupt();
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                    }
                }
            }
            Logging.connectors.debug((Object)"Csws: Done user workspaces");
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        CswsContext llc = new CswsContext();
        MetadataDescription desc = new MetadataDescription(llc);
        SystemMetadataDescription sDesc = new SystemMetadataDescription(llc, spec);
        Object[] acls = sDesc.getAcls();
        if (acls != null) {
            Arrays.sort(acls);
        }
        String metadataString = null;
        Object[] specifiedMetadataAttributes = null;
        CategoryPathAccumulator catAccum = null;
        if (!sDesc.includeAllMetadata()) {
            StringBuilder sb = new StringBuilder();
            specifiedMetadataAttributes = sDesc.getMetadataAttributes();
            Arrays.sort(specifiedMetadataAttributes);
            CswsConnector.packList((StringBuilder)sb, (String[])specifiedMetadataAttributes, (char)'+');
            metadataString = sb.toString();
        } else {
            catAccum = new CategoryPathAccumulator(llc);
        }
        StringBuilder sb2 = new StringBuilder();
        if (sDesc.getPathAttributeName() != null) {
            sb2.append("=").append(sDesc.getPathAttributeName()).append(":").append(sDesc.getPathSeparator()).append(":").append(sDesc.getMatchMapString());
        }
        String pathNameAttributeVersion = sb2.toString();
        String filterString = sDesc.getFilterString();
        for (String documentIdentifier : documentIdentifiers) {
            void var32_38;
            String denyAcl;
            Object[] actualAcls;
            Object[] categoryPaths;
            activities.checkJobStillActive();
            String docID = documentIdentifier;
            boolean isFolder = docID.startsWith("F");
            long objID = new Long(docID.substring(1));
            this.getSession();
            ObjectInformation value = llc.getObjectInformation(objID);
            if (!value.exists()) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Csws: Object " + objID + " has no information - deleting"));
                }
                activities.deleteDocument(documentIdentifier);
                continue;
            }
            NodePermissions permissions = value.getPermissions();
            if (!permissions.isSeeContentsPermission()) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Csws: Crawl user cannot see contents of object " + objID + " - deleting"));
                }
                activities.deleteDocument(documentIdentifier);
                continue;
            }
            Date dt = value.getModifyDate();
            NodeRights rights = this.getObjectRights(objID);
            if (rights == null) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Csws: Could not get rights for object " + objID + " - deleting"));
                }
                activities.deleteDocument(documentIdentifier);
                continue;
            }
            if (isFolder) {
                List<? extends SGraph> childrenDocs;
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Csws: Processing folder " + objID));
                }
                ListObjectsThread t = new ListObjectsThread(objID, new String[]{"OTDataID", "OTSubTypeName", "OTName"}, this.dataCollection, filterString, "OTDataID");
                t.start();
                try {
                    childrenDocs = t.finishUp();
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                }
                for (SGraph sGraph : childrenDocs) {
                    boolean childIsFolder;
                    long childID = CswsConnector.getID(sGraph, 0);
                    String subType = CswsConnector.getString(sGraph, 2);
                    String name = CswsConnector.getString(sGraph, 1);
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("Csws: Found a child of folder " + objID + " : ID=" + childID));
                    }
                    boolean bl = childIsFolder = subType.equals("Folder") || subType.equals("Project") || subType.equals("CompoundDocument");
                    if (!childIsFolder && !CswsConnector.checkInclude(name, spec)) {
                        if (!Logging.connectors.isDebugEnabled()) continue;
                        Logging.connectors.debug((Object)("Csws: Child identifier " + childID + " was excluded by inclusion criteria"));
                        continue;
                    }
                    if (childIsFolder) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("Csws: Child identifier " + childID + " is a folder, project, or compound document; adding a reference"));
                        }
                        if (subType.equals("Project")) {
                            activities.addDocumentReference("F" + -childID);
                            continue;
                        }
                        activities.addDocumentReference("F" + childID);
                        continue;
                    }
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("Csws: Child identifier " + childID + " is a simple document; adding a reference"));
                    }
                    activities.addDocumentReference("D" + childID);
                }
                if (!Logging.connectors.isDebugEnabled()) continue;
                Logging.connectors.debug((Object)("Csws: Done processing folder " + objID));
                continue;
            }
            StringBuilder sb = new StringBuilder();
            if (sDesc.includeAllMetadata()) {
                ObjectInformation objectInfo = llc.getObjectInformation(objID);
                long[] lArray = objectInfo.getObjectCategoryIDs();
                categoryPaths = catAccum.getCategoryPathsAttributeNames(lArray);
                Arrays.sort(categoryPaths);
                CswsConnector.packList((StringBuilder)sb, (String[])categoryPaths, (char)'+');
            } else {
                categoryPaths = specifiedMetadataAttributes;
                sb.append(metadataString);
            }
            if (acls != null && acls.length == 0) {
                actualAcls = CswsConnector.lookupTokens(rights, value);
                Arrays.sort(actualAcls);
                denyAcl = defaultAuthorityDenyToken;
            } else if (acls != null && acls.length > 0) {
                actualAcls = acls;
                denyAcl = defaultAuthorityDenyToken;
            } else {
                actualAcls = acls;
                denyAcl = null;
            }
            if (actualAcls == null) {
                sb.append('-');
                Object var32_36 = null;
            } else {
                sb.append('+');
                CswsConnector.packList((StringBuilder)sb, (String[])actualAcls, (char)'+');
                CswsConnector.pack((StringBuilder)sb, (String)denyAcl, (char)'+');
                String[] stringArray = new String[]{denyAcl};
            }
            sb.append(new Long(dt.getTime()).toString());
            sb.append("=").append(pathNameAttributeVersion);
            sb.append("_").append(this.viewBasePath);
            String versionString = sb.toString();
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Csws: Successfully calculated version string for document " + objID + " : '" + versionString + "'"));
            }
            if (!activities.checkDocumentNeedsReindexing(documentIdentifier, versionString)) continue;
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Csws: Processing document " + objID));
            }
            if (!this.checkIngest(llc, objID, spec)) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Csws: Decided not to ingest document " + objID + " - Did not match ingestion criteria"));
                }
                activities.noDocument(documentIdentifier, versionString);
                continue;
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Csws: Decided to ingest document " + objID));
            }
            this.ingestFromCsws(llc, documentIdentifier, versionString, (String[])actualAcls, (String[])var32_38, rights == null ? null : (rights.getOwnerRight() == null ? null : Long.valueOf(rights.getOwnerRight().getRightID())), (String[])categoryPaths, activities, desc, sDesc);
            if (!Logging.connectors.isDebugEnabled()) continue;
            Logging.connectors.debug((Object)("Csws: Done processing document " + objID));
        }
    }

    private static long getID(SGraph sg, int nodeIndex) {
        String value = CswsConnector.getString(sg, nodeIndex);
        return new Long(value);
    }

    private static String getString(SGraph sg, int nodeIndex) {
        List<SNode> nodes = sg.getN();
        if (nodes == null || nodes.size() < 1) {
            throw new IllegalArgumentException("Expecting exactly one SNode");
        }
        SNode node = nodes.get(0);
        List<String> stringValues = node.getS();
        if (stringValues == null || stringValues.size() <= nodeIndex) {
            return null;
        }
        return stringValues.get(nodeIndex);
    }

    public int getMaxDocumentRequest() {
        return 6;
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "CswsConnector.Server"));
        tabsArray.add(Messages.getString(locale, "CswsConnector.DocumentView"));
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIGURATION_JS, null, true);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put(TAB_NAME_PARAM, tabName);
        CswsConnector.fillInServerTab(velocityContext, out, parameters);
        CswsConnector.fillInDocumentViewTab(velocityContext, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIGURATION_SERVER_HTML, velocityContext);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIGURATION_VIEW_HTML, velocityContext);
    }

    protected static void fillInServerTab(Map<String, Object> velocityContext, IHTTPOutput out, ConfigParams parameters) {
        String serverHTTPNTLMPassword;
        String serverHTTPNTLMUserName;
        String serverHTTPNTLMDomain;
        String dataCollection;
        String searchServiceServicePath;
        String memberServiceServicePath;
        String documentManagementServicePath;
        String contentServiceServicePath;
        String serverPassword;
        String serverUserName;
        String serverPort;
        String serverName;
        String serverProtocol = parameters.getParameter("Server protocol");
        if (serverProtocol == null) {
            serverProtocol = "http";
        }
        if ((serverName = parameters.getParameter("Server name")) == null) {
            serverName = "localhost";
        }
        if ((serverPort = parameters.getParameter("Server port")) == null) {
            serverPort = "2099";
        }
        if ((serverUserName = parameters.getParameter("Server user name")) == null) {
            serverUserName = "";
        }
        serverPassword = (serverPassword = parameters.getObfuscatedParameter("Server password")) == null ? "" : out.mapPasswordToKey(serverPassword);
        String authenticationServicePath = parameters.getParameter("Server Authentication Service path");
        if (authenticationServicePath == null) {
            authenticationServicePath = "/cws/Authentication.svc";
        }
        if ((contentServiceServicePath = parameters.getParameter("Server ContentService Service path")) == null) {
            contentServiceServicePath = "/cws/ContentService.svc";
        }
        if ((documentManagementServicePath = parameters.getParameter("Server DocumentManagement Service path")) == null) {
            documentManagementServicePath = "/cws/DocumentManagement.svc";
        }
        if ((memberServiceServicePath = parameters.getParameter("Server MemberService Service path")) == null) {
            memberServiceServicePath = "/cws/MemberService.svc";
        }
        if ((searchServiceServicePath = parameters.getParameter("Server SearchService Service path")) == null) {
            searchServiceServicePath = "/cws/SearchService.svc";
        }
        if ((dataCollection = parameters.getParameter("Data Collection")) == null) {
            dataCollection = "'LES Enterprise'";
        }
        if ((serverHTTPNTLMDomain = parameters.getParameter("Server HTTP NTLM domain")) == null) {
            serverHTTPNTLMDomain = "";
        }
        if ((serverHTTPNTLMUserName = parameters.getParameter("Server HTTP NTLM user name")) == null) {
            serverHTTPNTLMUserName = "";
        }
        serverHTTPNTLMPassword = (serverHTTPNTLMPassword = parameters.getObfuscatedParameter("Server HTTP NTLM password")) == null ? "" : out.mapPasswordToKey(serverHTTPNTLMPassword);
        String serverHTTPSKeystore = parameters.getParameter("Server HTTPS truststore");
        HashMap<String, String> serverCertificatesMap = null;
        String message = null;
        try {
            IKeystoreManager localServerHTTPSKeystore = serverHTTPSKeystore == null ? KeystoreManagerFactory.make((String)"") : KeystoreManagerFactory.make((String)"", (String)serverHTTPSKeystore);
            String[] contents = localServerHTTPSKeystore.getContents();
            if (contents.length > 0) {
                serverCertificatesMap = new HashMap<String, String>();
                for (int i = 0; i < contents.length; ++i) {
                    String alias = contents[i];
                    Object description = localServerHTTPSKeystore.getDescription(alias);
                    if (((String)description).length() > 128) {
                        description = ((String)description).substring(0, 125) + "...";
                    }
                    serverCertificatesMap.put(alias, (String)description);
                }
            }
        }
        catch (ManifoldCFException e) {
            message = e.getMessage();
            Logging.connectors.warn((Object)e);
        }
        velocityContext.put("SERVERPROTOCOL", serverProtocol);
        velocityContext.put("SERVERNAME", serverName);
        velocityContext.put("SERVERPORT", serverPort);
        velocityContext.put("SERVERUSERNAME", serverUserName);
        velocityContext.put("SERVERPASSWORD", serverPassword);
        velocityContext.put("AUTHENTICATIONSERVICEPATH", authenticationServicePath);
        velocityContext.put("CONTENTSERVICESERVICEPATH", contentServiceServicePath);
        velocityContext.put("DOCUMENTMANAGEMENTSERVICEPATH", documentManagementServicePath);
        velocityContext.put("MEMBERSERVICESERVICEPATH", memberServiceServicePath);
        velocityContext.put("SEARCHSERVICESERVICEPATH", searchServiceServicePath);
        velocityContext.put("DATACOLLECTION", dataCollection);
        velocityContext.put("SERVERHTTPNTLMDOMAIN", serverHTTPNTLMDomain);
        velocityContext.put("SERVERHTTPNTLMUSERNAME", serverHTTPNTLMUserName);
        velocityContext.put("SERVERHTTPNTLMPASSWORD", serverHTTPNTLMPassword);
        if (serverHTTPSKeystore != null) {
            velocityContext.put("SERVERHTTPSKEYSTORE", serverHTTPSKeystore);
        }
        if (serverCertificatesMap != null) {
            velocityContext.put("SERVERCERTIFICATESMAP", serverCertificatesMap);
        }
        if (message != null) {
            velocityContext.put("MESSAGE", message);
        }
    }

    protected static void fillInDocumentViewTab(Map<String, Object> velocityContext, IHTTPOutput out, ConfigParams parameters) {
        String viewAction;
        String viewCgiPath;
        String viewPort;
        String viewServerName;
        String viewProtocol = parameters.getParameter("View protocol");
        if (viewProtocol == null) {
            viewProtocol = "http";
        }
        if ((viewServerName = parameters.getParameter("View server name")) == null) {
            viewServerName = "";
        }
        if ((viewPort = parameters.getParameter("View port")) == null) {
            viewPort = "";
        }
        if ((viewCgiPath = parameters.getParameter("View CGI path")) == null) {
            viewCgiPath = "/livelink/livelink.exe";
        }
        if ((viewAction = parameters.getParameter("View Action")) == null) {
            viewAction = "download";
        }
        velocityContext.put("VIEWPROTOCOL", viewProtocol);
        velocityContext.put("VIEWSERVERNAME", viewServerName);
        velocityContext.put("VIEWPORT", viewPort);
        velocityContext.put("VIEWCGIPATH", viewCgiPath);
        velocityContext.put("VIEWACTION", viewAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String serverHTTPNTLMPassword;
        String serverHTTPNTLMUserName;
        String serverHTTPNTLMDomain;
        String dataCollection;
        String searchServiceServicePath;
        String memberServiceServicePath;
        String documentManagementServicePath;
        String contentServiceServicePath;
        String authenticationServicePath;
        String serverPassword;
        String serverUserName;
        String serverPort;
        String serverName;
        String serverProtocol;
        String viewAction;
        String viewCgiPath;
        String viewPort;
        String viewServerName;
        String viewProtocol = variableContext.getParameter("viewprotocol");
        if (viewProtocol != null) {
            parameters.setParameter("View protocol", viewProtocol);
        }
        if ((viewServerName = variableContext.getParameter("viewservername")) != null) {
            parameters.setParameter("View server name", viewServerName);
        }
        if ((viewPort = variableContext.getParameter("viewport")) != null) {
            parameters.setParameter("View port", viewPort);
        }
        if ((viewCgiPath = variableContext.getParameter("viewcgipath")) != null) {
            parameters.setParameter("View CGI path", viewCgiPath);
        }
        if ((viewAction = variableContext.getParameter("viewaction")) != null) {
            parameters.setParameter("View Action", viewAction);
        }
        if ((serverProtocol = variableContext.getParameter("serverprotocol")) != null) {
            parameters.setParameter("Server protocol", serverProtocol);
        }
        if ((serverName = variableContext.getParameter("servername")) != null) {
            parameters.setParameter("Server name", serverName);
        }
        if ((serverPort = variableContext.getParameter("serverport")) != null) {
            parameters.setParameter("Server port", serverPort);
        }
        if ((serverUserName = variableContext.getParameter("serverusername")) != null) {
            parameters.setParameter("Server user name", serverUserName);
        }
        if ((serverPassword = variableContext.getParameter("serverpassword")) != null) {
            parameters.setObfuscatedParameter("Server password", variableContext.mapKeyToPassword(serverPassword));
        }
        if ((authenticationServicePath = variableContext.getParameter("authenticationservicepath")) != null) {
            parameters.setParameter("Server Authentication Service path", authenticationServicePath);
        }
        if ((contentServiceServicePath = variableContext.getParameter("contentserviceservicepath")) != null) {
            parameters.setParameter("Server ContentService Service path", contentServiceServicePath);
        }
        if ((documentManagementServicePath = variableContext.getParameter("documentmanagementservicepath")) != null) {
            parameters.setParameter("Server DocumentManagement Service path", documentManagementServicePath);
        }
        if ((memberServiceServicePath = variableContext.getParameter("memberserviceservicepath")) != null) {
            parameters.setParameter("Server MemberService Service path", memberServiceServicePath);
        }
        if ((searchServiceServicePath = variableContext.getParameter("searchserviceservicepath")) != null) {
            parameters.setParameter("Server SearchService Service path", searchServiceServicePath);
        }
        if ((dataCollection = variableContext.getParameter("datacollection")) != null) {
            parameters.setParameter("Data Collection", dataCollection);
        }
        if ((serverHTTPNTLMDomain = variableContext.getParameter("serverhttpntlmdomain")) != null) {
            parameters.setParameter("Server HTTP NTLM domain", serverHTTPNTLMDomain);
        }
        if ((serverHTTPNTLMUserName = variableContext.getParameter("serverhttpntlmusername")) != null) {
            parameters.setParameter("Server HTTP NTLM user name", serverHTTPNTLMUserName);
        }
        if ((serverHTTPNTLMPassword = variableContext.getParameter("serverhttpntlmpassword")) != null) {
            parameters.setObfuscatedParameter("Server HTTP NTLM password", variableContext.mapKeyToPassword(serverHTTPNTLMPassword));
        }
        String serverHTTPSKeystoreValue = variableContext.getParameter("serverhttpskeystoredata");
        String serverConfigOp = variableContext.getParameter("serverconfigop");
        if (serverConfigOp != null) {
            if (serverConfigOp.equals("Delete")) {
                String alias = variableContext.getParameter("serverkeystorealias");
                IKeystoreManager mgr = serverHTTPSKeystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)serverHTTPSKeystoreValue) : KeystoreManagerFactory.make((String)"");
                mgr.remove(alias);
                serverHTTPSKeystoreValue = mgr.getString();
            } else if (serverConfigOp.equals("Add")) {
                String alias = IDFactory.make((IThreadContext)threadContext);
                byte[] certificateValue = variableContext.getBinaryBytes("servercertificate");
                IKeystoreManager mgr = serverHTTPSKeystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)serverHTTPSKeystoreValue) : KeystoreManagerFactory.make((String)"");
                ByteArrayInputStream is = new ByteArrayInputStream(certificateValue);
                String certError = null;
                try {
                    mgr.importCertificate(alias, (InputStream)is);
                }
                catch (Throwable e) {
                    certError = e.getMessage();
                }
                finally {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {}
                }
                if (certError != null) {
                    return "Illegal certificate: " + certError;
                }
                serverHTTPSKeystoreValue = mgr.getString();
            }
        }
        parameters.setParameter("Server HTTPS truststore", serverHTTPSKeystoreValue);
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        Iterator iter = parameters.listParameters();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            String value = parameters.getParameter(param);
            if (param.length() >= "password".length() && param.substring(param.length() - "password".length()).equalsIgnoreCase("password")) {
                configMap.put(Encoder.bodyEscape((String)param), "********");
                continue;
            }
            if (param.length() >= "keystore".length() && param.substring(param.length() - "keystore".length()).equalsIgnoreCase("keystore") || param.length() > "truststore".length() && param.substring(param.length() - "truststore".length()).equalsIgnoreCase("truststore")) {
                IKeystoreManager kmanager = KeystoreManagerFactory.make((String)"", (String)value);
                configMap.put(Encoder.bodyEscape((String)param), "=&lt;" + Integer.toString(kmanager.getContents().length) + Messages.getBodyString(locale, "CswsConnector.certificates") + "&gt;");
                continue;
            }
            configMap.put(Encoder.bodyEscape((String)param), Encoder.bodyEscape((String)value));
        }
        paramMap.put("CONFIGMAP", configMap);
        Messages.outputResourceWithVelocity(out, locale, VIEW_CONFIGURATION_HTML, paramMap);
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "CswsConnector.Paths"));
        tabsArray.add(Messages.getString(locale, "CswsConnector.Filters"));
        tabsArray.add(Messages.getString(locale, "CswsConnector.Security"));
        tabsArray.add(Messages.getString(locale, "CswsConnector.Metadata"));
        String seqPrefixParam = "s" + connectionSequenceNumber + "_";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("seqPrefix", seqPrefixParam);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_JS, paramMap, true);
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put(TAB_NAME_PARAM, tabName);
        velocityContext.put("SeqNum", Integer.toString(connectionSequenceNumber));
        velocityContext.put("SelectedNum", Integer.toString(actualSequenceNumber));
        CswsConnector.fillInPathsTab(velocityContext, out, ds);
        CswsConnector.fillInFiltersTab(velocityContext, out, ds);
        CswsConnector.fillInSecurityTab(velocityContext, out, ds);
        CswsConnector.fillInMetadataTab(velocityContext, out, ds);
        if (tabName.equals(Messages.getString(locale, "CswsConnector.Paths"))) {
            this.fillInTransientPathsInfo(velocityContext, connectionSequenceNumber);
        } else if (tabName.equals(Messages.getString(locale, "CswsConnector.Metadata"))) {
            this.fillInTransientMetadataInfo(velocityContext, connectionSequenceNumber);
        }
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_PATHS_HTML, velocityContext);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_FILTERS_HTML, velocityContext);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_SECURITY_HTML, velocityContext);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_METADATA_HTML, velocityContext);
    }

    protected static void fillInPathsTab(Map<String, Object> velocityContext, IHTTPOutput out, Specification ds) {
        boolean userWorkspaces = false;
        ArrayList<String> paths = new ArrayList<String>();
        int i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn;
            if ((sn = ds.getChild(i++)).getType().equals("userworkspace")) {
                String value = sn.getAttributeValue("value");
                if (value == null || !value.equals("true")) continue;
                userWorkspaces = true;
                continue;
            }
            if (!sn.getType().equals("startpoint")) continue;
            paths.add(sn.getAttributeValue("path"));
        }
        velocityContext.put("USERWORKSPACES", userWorkspaces);
        velocityContext.put("PATHS", paths);
    }

    protected void fillInTransientPathsInfo(Map<String, Object> velocityContext, int connectionSequenceNumber) {
        String message = null;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String pathSoFar = (String)this.currentContext.get((Object)(seqPrefix + "specpath"));
        if (pathSoFar == null) {
            pathSoFar = "";
        }
        String[] childList = null;
        try {
            childList = this.getChildFolderNames(pathSoFar);
            if (childList == null) {
                pathSoFar = "";
                childList = this.getChildFolderNames("");
                if (childList == null) {
                    throw new ManifoldCFException("Can't find any children for root folder");
                }
            }
        }
        catch (ServiceInterruption e) {
            message = e.getMessage();
        }
        catch (ManifoldCFException e) {
            message = e.getMessage();
        }
        velocityContext.put("PATHSOFAR", pathSoFar);
        if (message != null) {
            velocityContext.put("MESSAGE", message);
        }
        if (childList != null) {
            velocityContext.put("CHILDLIST", childList);
        }
    }

    protected static void fillInFiltersTab(Map<String, Object> velocityContext, IHTTPOutput out, Specification ds) {
        ArrayList<Pair<String, String>> fileSpecs = new ArrayList<Pair<String, String>>();
        int i = 0;
        i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = ds.getChild(i++)).getType().equals("include") && !sn.getType().equals("exclude")) continue;
            fileSpecs.add(new Pair<String, String>(sn.getType(), sn.getAttributeValue("filespec")));
        }
        velocityContext.put("FILESPECS", fileSpecs);
    }

    protected static void fillInSecurityTab(Map<String, Object> velocityContext, IHTTPOutput out, Specification ds) {
        String security = "on";
        ArrayList<String> accessTokens = new ArrayList<String>();
        for (int i = 0; i < ds.getChildCount(); ++i) {
            SpecificationNode sn = ds.getChild(i);
            if (sn.getType().equals("security")) {
                security = sn.getAttributeValue("value");
                continue;
            }
            if (!sn.getType().equals("access")) continue;
            String token = sn.getAttributeValue("token");
            accessTokens.add(token);
        }
        velocityContext.put("SECURITY", security);
        velocityContext.put("ACCESSTOKENS", accessTokens);
    }

    protected static void fillInMetadataTab(Map<String, Object> velocityContext, IHTTPOutput out, Specification ds) {
        boolean ingestAllMetadata = false;
        String pathNameAttribute = "";
        String pathNameSeparator = "/";
        HashMap<String, String> matchMap = new HashMap<String, String>();
        ArrayList<Pair<String, Pair<String, String>>> metadataList = new ArrayList<Pair<String, Pair<String, String>>>();
        int i = 0;
        while (i < ds.getChildCount()) {
            String attributeName;
            SpecificationNode sn;
            if ((sn = ds.getChild(i++)).getType().equals("allmetadata")) {
                String value = sn.getAttributeValue("all");
                if (value == null || !value.equals("true")) continue;
                ingestAllMetadata = true;
                continue;
            }
            if (sn.getType().equals("pathnameattribute")) {
                pathNameAttribute = sn.getAttributeValue("value");
                if (sn.getAttributeValue("separator") == null) continue;
                pathNameSeparator = sn.getAttributeValue("separator");
                continue;
            }
            if (sn.getType().equals("pathmap")) {
                String pathMatch = sn.getAttributeValue("match");
                String pathReplace = sn.getAttributeValue("replace");
                matchMap.put(pathMatch, pathReplace);
                continue;
            }
            if (!sn.getType().equals("metadata")) continue;
            String categoryPath = sn.getAttributeValue("category");
            String isAll = sn.getAttributeValue("all");
            if (isAll == null) {
                isAll = "false";
            }
            if ((attributeName = sn.getAttributeValue("attribute")) == null) {
                attributeName = "";
            }
            metadataList.add(new Pair<String, Pair<String, String>>(categoryPath, new Pair<String, String>(isAll, attributeName)));
        }
        velocityContext.put("INGESTALLMETADATA", ingestAllMetadata);
        velocityContext.put("PATHNAMEATTRIBUTE", pathNameAttribute);
        velocityContext.put("PATHNAMESEPARATOR", pathNameSeparator);
        velocityContext.put("MATCHMAP", matchMap);
        velocityContext.put("METADATA", metadataList);
    }

    protected void fillInTransientMetadataInfo(Map<String, Object> velocityContext, int connectionSequenceNumber) {
        String message = null;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String categorySoFar = (String)this.currentContext.get((Object)(seqPrefix + "speccategory"));
        if (categorySoFar == null) {
            categorySoFar = "";
        }
        String[] childList = null;
        String[] workspaceList = null;
        String[] categoryList = null;
        String[] attributeList = null;
        try {
            if (categorySoFar.length() == 0) {
                workspaceList = this.getWorkspaceNames();
            } else {
                attributeList = this.getCategoryAttributes(categorySoFar);
                if (attributeList == null) {
                    childList = this.getChildFolderNames(categorySoFar);
                    if (childList == null) {
                        categorySoFar = "";
                        childList = this.getChildFolderNames("");
                        if (childList == null) {
                            throw new ManifoldCFException("Can't find any children for root folder");
                        }
                    }
                    if ((categoryList = this.getChildCategoryNames(categorySoFar)) == null) {
                        throw new ManifoldCFException("Can't find any categories for root folder folder");
                    }
                }
            }
        }
        catch (ServiceInterruption e) {
            message = e.getMessage();
        }
        catch (ManifoldCFException e) {
            message = e.getMessage();
        }
        velocityContext.put("CATEGORYSOFAR", categorySoFar);
        if (message != null) {
            velocityContext.put("MESSAGE", message);
        }
        if (childList != null) {
            velocityContext.put("CHILDLIST", childList);
        }
        if (workspaceList != null) {
            velocityContext.put("WORKSPACELIST", workspaceList);
        }
        if (categoryList != null) {
            velocityContext.put("CATEGORYLIST", categoryList);
        }
        if (attributeList != null) {
            velocityContext.put("ATTRIBUTELIST", attributeList);
        }
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        String op;
        String pathOpName;
        String pathDescription;
        String xc;
        SpecificationNode sn;
        int i;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String userWorkspacesPresent = variableContext.getParameter(seqPrefix + "userworkspace_present");
        if (userWorkspacesPresent != null) {
            String value = variableContext.getParameter(seqPrefix + "userworkspace");
            i = 0;
            while (i < ds.getChildCount()) {
                sn = ds.getChild(i);
                if (sn.getType().equals("userworkspace")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            sn = new SpecificationNode("userworkspace");
            sn.setAttribute("value", value);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)sn);
        }
        if ((xc = variableContext.getParameter(seqPrefix + "pathcount")) != null) {
            Object path;
            i = 0;
            while (i < ds.getChildCount()) {
                sn = ds.getChild(i);
                if (sn.getType().equals("startpoint")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int pathCount = Integer.parseInt(xc);
            i = 0;
            while (i < pathCount) {
                pathDescription = "_" + Integer.toString(i);
                pathOpName = seqPrefix + "pathop" + pathDescription;
                xc = variableContext.getParameter(pathOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String path2 = variableContext.getParameter(seqPrefix + "specpath" + pathDescription);
                SpecificationNode node = new SpecificationNode("startpoint");
                node.setAttribute("path", path2);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            op = variableContext.getParameter(seqPrefix + "pathop");
            if (op != null && op.equals("Add")) {
                path = variableContext.getParameter(seqPrefix + "specpath");
                SpecificationNode node = new SpecificationNode("startpoint");
                node.setAttribute("path", (String)path);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            } else if (op != null && op.equals("Up")) {
                path = variableContext.getParameter(seqPrefix + "specpath");
                int lastSlash = -1;
                int k = 0;
                while (k < ((String)path).length()) {
                    char x;
                    if ((x = ((String)path).charAt(k++)) == '/') {
                        lastSlash = k - 1;
                        continue;
                    }
                    if (x != '\\') continue;
                    ++k;
                }
                path = lastSlash == -1 ? "" : ((String)path).substring(0, lastSlash);
                this.currentContext.save((Object)(seqPrefix + "specpath"), path);
            } else if (op != null && op.equals("AddToPath")) {
                path = variableContext.getParameter(seqPrefix + "specpath");
                String addon = variableContext.getParameter(seqPrefix + "pathaddon");
                if (addon != null && addon.length() > 0) {
                    StringBuilder sb = new StringBuilder();
                    int k = 0;
                    while (k < addon.length()) {
                        char x;
                        if ((x = addon.charAt(k++)) == '/' || x == '\\' || x == ':') {
                            sb.append('\\');
                        }
                        sb.append(x);
                    }
                    path = ((String)path).length() == 0 ? sb.toString() : (String)path + "/" + sb.toString();
                }
                this.currentContext.save((Object)(seqPrefix + "specpath"), path);
            }
        }
        if ((xc = variableContext.getParameter(seqPrefix + "filecount")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn2 = ds.getChild(i);
                if (sn2.getType().equals("include") || sn2.getType().equals("exclude")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int fileCount = Integer.parseInt(xc);
            i = 0;
            while (i < fileCount) {
                String fileSpecDescription = "_" + Integer.toString(i);
                String fileOpName = seqPrefix + "fileop" + fileSpecDescription;
                xc = variableContext.getParameter(fileOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String filespecType = variableContext.getParameter(seqPrefix + "specfiletype" + fileSpecDescription);
                String filespec = variableContext.getParameter(seqPrefix + "specfile" + fileSpecDescription);
                SpecificationNode node = new SpecificationNode(filespecType);
                node.setAttribute("filespec", filespec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            op = variableContext.getParameter(seqPrefix + "fileop");
            if (op != null && op.equals("Add")) {
                String filespec = variableContext.getParameter(seqPrefix + "specfile");
                String filespectype = variableContext.getParameter(seqPrefix + "specfiletype");
                SpecificationNode node = new SpecificationNode(filespectype);
                node.setAttribute("filespec", filespec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        if ((xc = variableContext.getParameter(seqPrefix + "specsecurity")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn3 = ds.getChild(i);
                if (sn3.getType().equals("security")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode node = new SpecificationNode("security");
            node.setAttribute("value", xc);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
        }
        if ((xc = variableContext.getParameter(seqPrefix + "tokencount")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn4 = ds.getChild(i);
                if (sn4.getType().equals("access")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int accessCount = Integer.parseInt(xc);
            i = 0;
            while (i < accessCount) {
                String accessDescription = "_" + Integer.toString(i);
                String accessOpName = seqPrefix + "accessop" + accessDescription;
                xc = variableContext.getParameter(accessOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String accessSpec = variableContext.getParameter(seqPrefix + "spectoken" + accessDescription);
                SpecificationNode node = new SpecificationNode("access");
                node.setAttribute("token", accessSpec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            op = variableContext.getParameter(seqPrefix + "accessop");
            if (op != null && op.equals("Add")) {
                String accessspec = variableContext.getParameter(seqPrefix + "spectoken");
                SpecificationNode node = new SpecificationNode("access");
                node.setAttribute("token", accessspec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        if ((xc = variableContext.getParameter(seqPrefix + "specallmetadata")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn5 = ds.getChild(i);
                if (sn5.getType().equals("allmetadata")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            if (xc.equals("true")) {
                SpecificationNode newNode = new SpecificationNode("allmetadata");
                newNode.setAttribute("all", xc);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)newNode);
            }
        }
        if ((xc = variableContext.getParameter(seqPrefix + "metadatacount")) != null) {
            Object category;
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn6 = ds.getChild(i);
                if (sn6.getType().equals("metadata")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int metadataCount = Integer.parseInt(xc);
            i = 0;
            while (i < metadataCount) {
                pathDescription = "_" + Integer.toString(i);
                pathOpName = seqPrefix + "metadataop" + pathDescription;
                xc = variableContext.getParameter(pathOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String category2 = variableContext.getParameter(seqPrefix + "speccategory" + pathDescription);
                String attributeName = variableContext.getParameter(seqPrefix + "specattribute" + pathDescription);
                String isAll = variableContext.getParameter(seqPrefix + "specattributeall" + pathDescription);
                SpecificationNode node = new SpecificationNode("metadata");
                node.setAttribute("category", category2);
                if (isAll != null && isAll.equals("true")) {
                    node.setAttribute("all", "true");
                } else {
                    node.setAttribute("attribute", attributeName);
                }
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            op = variableContext.getParameter(seqPrefix + "metadataop");
            if (op != null && op.equals("Add")) {
                category = variableContext.getParameter(seqPrefix + "speccategory");
                String isAll = variableContext.getParameter(seqPrefix + "attributeall");
                if (isAll != null && isAll.equals("true")) {
                    SpecificationNode node = new SpecificationNode("metadata");
                    node.setAttribute("category", (String)category);
                    node.setAttribute("all", "true");
                    ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                } else {
                    String[] attributes = variableContext.getParameterValues(seqPrefix + "attributeselect");
                    if (attributes != null && attributes.length > 0) {
                        int k = 0;
                        while (k < attributes.length) {
                            String attribute = attributes[k++];
                            SpecificationNode node = new SpecificationNode("metadata");
                            node.setAttribute("category", (String)category);
                            node.setAttribute("attribute", attribute);
                            ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                        }
                    }
                }
            } else if (op != null && op.equals("Up")) {
                category = variableContext.getParameter(seqPrefix + "speccategory");
                int lastSlash = -1;
                int firstColon = -1;
                int k = 0;
                while (k < ((String)category).length()) {
                    char x;
                    if ((x = ((String)category).charAt(k++)) == '/') {
                        lastSlash = k - 1;
                        continue;
                    }
                    if (x == ':') {
                        firstColon = k;
                        continue;
                    }
                    if (x != '\\') continue;
                    ++k;
                }
                category = lastSlash == -1 ? (firstColon == -1 || firstColon == ((String)category).length() ? "" : ((String)category).substring(0, firstColon)) : ((String)category).substring(0, lastSlash);
                this.currentContext.save((Object)(seqPrefix + "speccategory"), category);
            } else if (op != null && op.equals("AddToPath")) {
                category = variableContext.getParameter(seqPrefix + "speccategory");
                String addon = variableContext.getParameter(seqPrefix + "metadataaddon");
                if (addon != null && addon.length() > 0) {
                    StringBuilder sb = new StringBuilder();
                    int k = 0;
                    while (k < addon.length()) {
                        char x;
                        if ((x = addon.charAt(k++)) == '/' || x == '\\' || x == ':') {
                            sb.append('\\');
                        }
                        sb.append(x);
                    }
                    category = ((String)category).length() == 0 || ((String)category).endsWith(":") ? (String)category + sb.toString() : (String)category + "/" + sb.toString();
                }
                this.currentContext.save((Object)(seqPrefix + "speccategory"), category);
            } else if (op != null && op.equals("SetWorkspace")) {
                String addon = variableContext.getParameter(seqPrefix + "metadataaddon");
                if (addon != null && addon.length() > 0) {
                    StringBuilder sb = new StringBuilder();
                    int k = 0;
                    while (k < addon.length()) {
                        char x;
                        if ((x = addon.charAt(k++)) == '/' || x == '\\' || x == ':') {
                            sb.append('\\');
                        }
                        sb.append(x);
                    }
                    String category3 = sb.toString() + ":";
                    this.currentContext.save((Object)(seqPrefix + "speccategory"), (Object)category3);
                }
            } else if (op != null && op.equals("AddCategory")) {
                category = variableContext.getParameter(seqPrefix + "speccategory");
                String addon = variableContext.getParameter(seqPrefix + "categoryaddon");
                if (addon != null && addon.length() > 0) {
                    StringBuilder sb = new StringBuilder();
                    int k = 0;
                    while (k < addon.length()) {
                        char x;
                        if ((x = addon.charAt(k++)) == '/' || x == '\\' || x == ':') {
                            sb.append('\\');
                        }
                        sb.append(x);
                    }
                    category = ((String)category).length() == 0 || ((String)category).endsWith(":") ? (String)category + sb.toString() : (String)category + "/" + sb.toString();
                }
                this.currentContext.save((Object)(seqPrefix + "speccategory"), category);
            }
        }
        if ((xc = variableContext.getParameter(seqPrefix + "specpathnameattribute")) != null) {
            String separator = variableContext.getParameter(seqPrefix + "specpathnameseparator");
            if (separator == null) {
                separator = "/";
            }
            int i2 = 0;
            while (i2 < ds.getChildCount()) {
                SpecificationNode sn7 = ds.getChild(i2);
                if (sn7.getType().equals("pathnameattribute")) {
                    ds.removeChild(i2);
                    continue;
                }
                ++i2;
            }
            if (xc.length() > 0) {
                SpecificationNode node = new SpecificationNode("pathnameattribute");
                node.setAttribute("value", xc);
                node.setAttribute("separator", separator);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        if ((xc = variableContext.getParameter(seqPrefix + "specmappingcount")) != null) {
            int i3 = 0;
            while (i3 < ds.getChildCount()) {
                SpecificationNode sn8 = ds.getChild(i3);
                if (sn8.getType().equals("pathmap")) {
                    ds.removeChild(i3);
                    continue;
                }
                ++i3;
            }
            int mappingCount = Integer.parseInt(xc);
            i3 = 0;
            while (i3 < mappingCount) {
                pathDescription = "_" + Integer.toString(i3);
                pathOpName = seqPrefix + "specmappingop" + pathDescription;
                xc = variableContext.getParameter(pathOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i3;
                    continue;
                }
                String match = variableContext.getParameter(seqPrefix + "specmatch" + pathDescription);
                String replace = variableContext.getParameter(seqPrefix + "specreplace" + pathDescription);
                SpecificationNode node = new SpecificationNode("pathmap");
                node.setAttribute("match", match);
                node.setAttribute("replace", replace);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i3;
            }
            xc = variableContext.getParameter(seqPrefix + "specmappingop");
            if (xc != null && xc.equals("Add")) {
                String match = variableContext.getParameter(seqPrefix + "specmatch");
                String replace = variableContext.getParameter(seqPrefix + "specreplace");
                SpecificationNode node = new SpecificationNode("pathmap");
                node.setAttribute("match", match);
                node.setAttribute("replace", replace);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        CswsConnector.fillInPathsTab(velocityContext, out, ds);
        CswsConnector.fillInFiltersTab(velocityContext, out, ds);
        CswsConnector.fillInSecurityTab(velocityContext, out, ds);
        CswsConnector.fillInMetadataTab(velocityContext, out, ds);
        Messages.outputResourceWithVelocity(out, locale, VIEW_SPECIFICATION_HTML, velocityContext);
    }

    public String[] getWorkspaceNames() throws ManifoldCFException, ServiceInterruption {
        return new String[]{categoryWSName, enterpriseWSName};
    }

    public String[] getChildFolderNames(String pathString) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        return this.getChildFolders(new CswsContext(), pathString);
    }

    public String[] getChildCategoryNames(String pathString) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        return this.getChildCategories(new CswsContext(), pathString);
    }

    public String[] getCategoryAttributes(String pathString) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        return this.getCategoryAttributes(new CswsContext(), pathString);
    }

    protected String[] getCategoryAttributes(CswsContext llc, String pathString) throws ManifoldCFException, ServiceInterruption {
        RootValue rv = new RootValue(llc, pathString);
        long catObjectID = this.getCategoryId(rv);
        if (catObjectID == -1L) {
            return null;
        }
        String[] rval = this.getCategoryAttributes(catObjectID);
        if (rval == null) {
            return new String[0];
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void ingestFromCsws(CswsContext llc, String documentIdentifier, String version, String[] actualAcls, String[] denyAcls, Long ownerID, String[] categoryPaths, IProcessActivity activities, MetadataDescription desc, SystemMetadataDescription sDesc) throws ManifoldCFException, ServiceInterruption {
        String contextMsg = "for '" + documentIdentifier + "'";
        long startTime = System.currentTimeMillis();
        String resultCode = null;
        Object resultDescription = null;
        Long readSize = null;
        long objID = new Integer(documentIdentifier.substring(1)).intValue();
        try {
            String pathString;
            String pathAttributeName;
            String viewHttpAddress = this.convertToViewURI(documentIdentifier);
            if (viewHttpAddress == null) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Csws: No view URI " + contextMsg + " - not ingesting"));
                }
                resultCode = "NOVIEWURI";
                resultDescription = "Document had no view URI";
                activities.noDocument(documentIdentifier, version);
                return;
            }
            if (!activities.checkURLIndexable(viewHttpAddress)) {
                resultCode = "EXCLUDEDURL";
                resultDescription = "URL (" + viewHttpAddress + ") was rejected by output connector";
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Csws: Excluding document " + documentIdentifier + " because its URL (" + viewHttpAddress + ") was rejected by output connector"));
                }
                activities.noDocument(documentIdentifier, version);
                return;
            }
            ObjectInformation objInfo = llc.getObjectInformation(objID);
            VersionInformation versInfo = llc.getVersionInformation(objID, 0);
            if (!objInfo.exists()) {
                resultCode = "OBJECTNOTFOUND";
                resultDescription = "Object was not found in Csws";
                Logging.connectors.debug((Object)("Csws: No object " + contextMsg + ": not ingesting"));
                activities.noDocument(documentIdentifier, version);
                return;
            }
            if (!versInfo.exists()) {
                resultCode = "VERSIONNOTFOUND";
                resultDescription = "Version was not found in Csws";
                Logging.connectors.debug((Object)("Csws: No version data " + contextMsg + ": not ingesting"));
                activities.noDocument(documentIdentifier, version);
                return;
            }
            String mimeType = versInfo.getMimeType();
            if (!activities.checkMimeTypeIndexable(mimeType)) {
                resultCode = "EXCLUDEDMIMETYPE";
                resultDescription = "Mime type (" + mimeType + ") was rejected by output connector";
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Csws: Excluding document " + documentIdentifier + " because its mime type (" + mimeType + ") was rejected by output connector"));
                }
                activities.noDocument(documentIdentifier, version);
                return;
            }
            Long dataSize = versInfo.getDataSize();
            if (dataSize == null) {
                resultCode = "DOCUMENTNOLENGTH";
                resultDescription = "Document had no length in Csws";
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Csws: Excluding document " + documentIdentifier + " because it had no length"));
                }
                activities.noDocument(documentIdentifier, version);
                return;
            }
            if (!activities.checkLengthIndexable(dataSize.longValue())) {
                resultCode = "EXCLUDEDLENGTH";
                resultDescription = "Document length (" + dataSize + ") was rejected by output connector";
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Csws: Excluding document " + documentIdentifier + " because its length (" + dataSize + ") was rejected by output connector"));
                }
                activities.noDocument(documentIdentifier, version);
                return;
            }
            Date modifyDate = versInfo.getModifyDate();
            if (!activities.checkDateIndexable(modifyDate)) {
                resultCode = "EXCLUDEDDATE";
                resultDescription = "Document date (" + String.valueOf(modifyDate) + ") was rejected by output connector";
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Csws: Excluding document " + documentIdentifier + " because its date (" + String.valueOf(modifyDate) + ") was rejected by output connector"));
                }
                activities.noDocument(documentIdentifier, version);
                return;
            }
            String fileName = versInfo.getFileName();
            Date creationDate = objInfo.getCreationDate();
            Long parentID = objInfo.getParentId();
            RepositoryDocument rd = new RepositoryDocument();
            if (mimeType != null) {
                rd.setMimeType(mimeType);
            }
            if (fileName != null) {
                rd.setFileName(fileName);
            }
            if (creationDate != null) {
                rd.setCreatedDate(creationDate);
            }
            if (modifyDate != null) {
                rd.setModifiedDate(modifyDate);
            }
            rd.addField(GENERAL_NAME_FIELD, objInfo.getName());
            rd.addField(GENERAL_DESCRIPTION_FIELD, objInfo.getComments());
            if (creationDate != null) {
                rd.addField(GENERAL_CREATIONDATE_FIELD, DateParser.formatISO8601Date((Date)creationDate));
            }
            if (modifyDate != null) {
                rd.addField(GENERAL_MODIFYDATE_FIELD, DateParser.formatISO8601Date((Date)modifyDate));
            }
            if (parentID != null) {
                rd.addField(GENERAL_PARENTID, parentID.toString());
            }
            UserInformation owner = ownerID == null ? null : llc.getUserInformation(ownerID);
            UserInformation creator = llc.getUserInformation(objInfo.getCreatorId());
            UserInformation modifier = llc.getUserInformation(versInfo.getOwnerId());
            if (owner != null) {
                rd.addField(GENERAL_OWNER, owner.getName());
            }
            if (creator != null) {
                rd.addField(GENERAL_CREATOR, creator.getName());
            }
            if (modifier != null) {
                rd.addField(GENERAL_MODIFIER, modifier.getName());
            }
            Iterator<MetadataItem> catIter = desc.getItems(categoryPaths);
            while (catIter.hasNext()) {
                MetadataItem item = catIter.next();
                MetadataPathItem pathItem = item.getPathItem();
                if (pathItem == null) continue;
                long catID = pathItem.getCatID();
                objInfo.getSpecifiedCategoryAttribute(rd, catID, pathItem.getCatName());
            }
            if (actualAcls != null && denyAcls != null) {
                rd.setSecurity("document", actualAcls, denyAcls);
            }
            if ((pathAttributeName = sDesc.getPathAttributeName()) != null && pathAttributeName.length() > 0 && (pathString = sDesc.getPathAttributeValue(documentIdentifier)) != null) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Csws: Path attribute name is '" + pathAttributeName + "'" + contextMsg + ", value is '" + pathString + "'"));
                }
                rd.addField(pathAttributeName, pathString);
            }
            DocumentReadingThread t = new DocumentReadingThread(objID, 0L);
            boolean wasInterrupted = false;
            t.start();
            try {
                try (InputStream is = t.getSafeInputStream();){
                    rd.setBinary(is, dataSize.longValue());
                    activities.ingestDocumentWithException(documentIdentifier, version, viewHttpAddress, rd);
                    resultCode = "OK";
                    readSize = dataSize;
                }
                catch (SocketTimeoutException e) {
                    throw e;
                }
                catch (InterruptedIOException e) {
                    wasInterrupted = true;
                    throw e;
                }
                finally {
                    if (!wasInterrupted) {
                        t.finishUp();
                    }
                }
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (IOException e) {
                resultCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                resultDescription = e.getMessage();
                CswsConnector.handleIOException(contextMsg, e);
            }
            if (resultCode == null) return;
        }
        catch (ManifoldCFException e) {
            if (e.getErrorCode() != 2) throw e;
            resultCode = null;
            throw e;
        }
        finally {
            if (resultCode != null) {
                activities.recordActivity(new Long(startTime), ACTIVITY_FETCH, readSize, new Long(objID).toString(), resultCode, (String)resultDescription, null);
            }
        }
        activities.recordActivity(new Long(startTime), ACTIVITY_FETCH, readSize, new Long(objID).toString(), resultCode, (String)resultDescription, null);
        return;
    }

    protected static void handleIOException(String contextMsg, IOException e) throws ManifoldCFException, ServiceInterruption {
        long currentTime = System.currentTimeMillis();
        if (e instanceof SocketTimeoutException) {
            Logging.connectors.warn((Object)("Csws: Csws socket timed out ingesting from the Csws HTTP Server " + contextMsg + ": " + e.getMessage()), (Throwable)e);
            throw new ServiceInterruption("Socket timed out: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 21600000L, -1, false);
        }
        if (e instanceof SocketException) {
            Logging.connectors.warn((Object)("Csws: Csws socket error ingesting from the Csws HTTP Server " + contextMsg + ": " + e.getMessage()), (Throwable)e);
            throw new ServiceInterruption("Socket error: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 21600000L, -1, false);
        }
        if (e instanceof SSLHandshakeException) {
            Logging.connectors.warn((Object)("Csws: SSL handshake failed authenticating " + contextMsg + ": " + e.getMessage()), (Throwable)e);
            throw new ServiceInterruption("SSL handshake error: " + e.getMessage(), (Throwable)e, currentTime + 60000L, currentTime + 300000L, -1, true);
        }
        if (e instanceof ConnectTimeoutException) {
            Logging.connectors.warn((Object)("Csws: Csws socket timed out connecting to the Csws HTTP Server " + contextMsg + ": " + e.getMessage()), (Throwable)e);
            throw new ServiceInterruption("Connect timed out: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 21600000L, -1, false);
        }
        if (e instanceof InterruptedIOException) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        Logging.connectors.warn((Object)("Csws: IO exception ingesting " + contextMsg + ": " + e.getMessage()), (Throwable)e);
        throw new ServiceInterruption("IO exception ingesting " + contextMsg + ": " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 21600000L, -1, false);
    }

    protected static String packCategoryAttribute(String category, String attribute) {
        StringBuilder sb = new StringBuilder();
        CswsConnector.pack((StringBuilder)sb, (String)category, (char)':');
        CswsConnector.pack((StringBuilder)sb, (String)attribute, (char)':');
        return sb.toString();
    }

    protected static void unpackCategoryAttribute(StringBuilder category, StringBuilder attribute, String value) {
        int startPos = 0;
        startPos = CswsConnector.unpack((StringBuilder)category, (String)value, (int)startPos, (char)':');
        startPos = CswsConnector.unpack((StringBuilder)attribute, (String)value, (int)startPos, (char)':');
    }

    protected String[] getChildFolders(CswsContext llc, String pathString) throws ManifoldCFException, ServiceInterruption {
        RootValue rv = new RootValue(llc, pathString);
        Long vid = this.getPathId(rv);
        if (vid == null) {
            return null;
        }
        String filterString = "\"OTSubType\":0 OR \"OTSubType\":202 OR \"OTSubType\":136";
        ListObjectsThread t = new ListObjectsThread(vid, new String[]{"OTName"}, this.dataCollection, "\"OTSubType\":0 OR \"OTSubType\":202 OR \"OTSubType\":136", "OTName");
        try {
            t.start();
            List<? extends SGraph> children = t.finishUp();
            String[] rval = new String[children.size()];
            int j = 0;
            for (SGraph sGraph : children) {
                rval[j++] = CswsConnector.getString(sGraph, 0);
            }
            return rval;
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
    }

    protected String[] getChildCategories(CswsContext llc, String pathString) throws ManifoldCFException, ServiceInterruption {
        RootValue rv = new RootValue(llc, pathString);
        Long vid = this.getPathId(rv);
        if (vid == null) {
            return null;
        }
        String filterString = "\"OTSubType\":131";
        ListObjectsThread t = new ListObjectsThread(vid, new String[]{"OTName"}, this.dataCollection, filterString, "OTName");
        try {
            t.start();
            List<? extends SGraph> children = t.finishUp();
            String[] rval = new String[children.size()];
            int j = 0;
            for (SGraph sGraph : children) {
                rval[j++] = CswsConnector.getString(sGraph, 0);
            }
            return rval;
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
    }

    protected String[] getCategoryAttributes(long catObjectID) throws ManifoldCFException, ServiceInterruption {
        GetCategoryAttributesThread t = new GetCategoryAttributesThread(catObjectID);
        try {
            t.start();
            return t.finishUp();
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
    }

    protected NodeRights getObjectRights(long objID) throws ManifoldCFException, ServiceInterruption {
        GetObjectRightsThread t = new GetObjectRightsThread(objID);
        try {
            t.start();
            return t.finishUp();
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
    }

    protected static String[] lookupTokens(NodeRights rights, ObjectInformation objInfo) throws ManifoldCFException, ServiceInterruption {
        if (!objInfo.exists()) {
            return null;
        }
        ArrayList<String> tokenAccumulator = new ArrayList<String>();
        if (CswsConnector.evaluateRight(rights.getOwnerRight())) {
            tokenAccumulator.add(new Long(rights.getOwnerRight().getRightID()).toString());
        }
        if (CswsConnector.evaluateRight(rights.getOwnerGroupRight())) {
            tokenAccumulator.add(new Long(rights.getOwnerGroupRight().getRightID()).toString());
        }
        if (CswsConnector.evaluateRight(rights.getPublicRight())) {
            tokenAccumulator.add("SYSTEM");
        }
        for (NodeRight nr : rights.getACLRights()) {
            if (!CswsConnector.evaluateRight(nr)) continue;
            tokenAccumulator.add(new Long(nr.getRightID()).toString());
        }
        return tokenAccumulator.toArray(new String[tokenAccumulator.size()]);
    }

    protected static boolean evaluateRight(NodeRight nr) {
        if (nr == null) {
            return false;
        }
        NodePermissions np = nr.getPermissions();
        return np.isSeePermission() && np.isSeeContentsPermission();
    }

    protected long[] getSuperObjectCategoryIDs(long id) throws ManifoldCFException, ServiceInterruption {
        GetObjectCategoryIDsThread t = new GetObjectCategoryIDsThread(id);
        try {
            t.start();
            return t.finishUp();
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
    }

    protected Long getPathId(RootValue rv) throws ManifoldCFException, ServiceInterruption {
        return rv.getRootValue().getPathId(rv.getRemainderPath());
    }

    protected long getCategoryId(RootValue rv) throws ManifoldCFException, ServiceInterruption {
        return rv.getRootValue().getCategoryId(rv.getRemainderPath());
    }

    protected static boolean checkInclude(String filename, Specification documentSpecification) throws ManifoldCFException {
        String filespec;
        SpecificationNode sn;
        int i;
        for (i = 0; !(i >= documentSpecification.getChildCount() || (sn = documentSpecification.getChild(i)).getType().equals("include") && CswsConnector.checkMatch(filename, 0, filespec = sn.getAttributeValue("filespec"))); ++i) {
        }
        if (i == documentSpecification.getChildCount()) {
            return false;
        }
        for (i = 0; i < documentSpecification.getChildCount(); ++i) {
            sn = documentSpecification.getChild(i);
            if (!sn.getType().equals("exclude") || !CswsConnector.checkMatch(filename, 0, filespec = sn.getAttributeValue("filespec"))) continue;
            return false;
        }
        return true;
    }

    protected boolean checkIngest(CswsContext llc, long objID, Specification documentSpecification) throws ManifoldCFException {
        return true;
    }

    protected static boolean checkMatch(String sourceMatch, int sourceIndex, String match) {
        boolean caseSensitive = false;
        return CswsConnector.processCheck(caseSensitive, sourceMatch, sourceIndex, match, 0);
    }

    protected static boolean processCheck(boolean caseSensitive, String sourceMatch, int sourceIndex, String match, int matchIndex) {
        while (true) {
            if (sourceMatch.length() == sourceIndex && match.length() == matchIndex) {
                return true;
            }
            if (match.length() == matchIndex) {
                return false;
            }
            if (sourceMatch.length() == sourceIndex) {
                if (match.charAt(matchIndex) != '*') {
                    return false;
                }
                ++matchIndex;
                continue;
            }
            char x = sourceMatch.charAt(sourceIndex);
            char y = match.charAt(matchIndex);
            if (!caseSensitive) {
                if (x >= 'A' && x <= 'Z') {
                    x = (char)(x + 32);
                }
                if (y >= 'A' && y <= 'Z') {
                    y = (char)(y + 32);
                }
            }
            if (y == '*') {
                return CswsConnector.processCheck(caseSensitive, sourceMatch, sourceIndex + 1, match, matchIndex) || CswsConnector.processCheck(caseSensitive, sourceMatch, sourceIndex, match, matchIndex + 1);
            }
            if (y != '?' && x != y) break;
            ++sourceIndex;
            ++matchIndex;
        }
        return false;
    }

    static {
        try {
            currentAddr = InetAddress.getLocalHost();
            currentHost = currentAddr.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    protected static class ExecuteMethodThread
    extends Thread {
        protected final HttpClient httpClient;
        protected final HttpRequestBase executeMethod;
        protected HttpResponse response = null;
        protected Throwable responseException = null;
        protected XThreadInputStream threadStream = null;
        protected InputStream bodyStream = null;
        protected boolean streamCreated = false;
        protected Throwable streamException = null;
        protected boolean abortThread = false;
        protected Throwable shutdownException = null;
        protected Throwable generalException = null;

        public ExecuteMethodThread(HttpClient httpClient, HttpRequestBase executeMethod) {
            this.setDaemon(true);
            this.httpClient = httpClient;
            this.executeMethod = executeMethod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ExecuteMethodThread executeMethodThread;
                try {
                    executeMethodThread = this;
                    synchronized (executeMethodThread) {
                        if (!this.abortThread) {
                            try {
                                this.response = this.httpClient.execute((HttpUriRequest)this.executeMethod);
                            }
                            catch (SocketTimeoutException e) {
                                this.responseException = e;
                            }
                            catch (ConnectTimeoutException e) {
                                this.responseException = e;
                            }
                            catch (InterruptedIOException e) {
                                throw e;
                            }
                            catch (Throwable e) {
                                this.responseException = e;
                            }
                            this.notifyAll();
                        }
                    }
                    if (this.responseException == null) {
                        executeMethodThread = this;
                        synchronized (executeMethodThread) {
                            if (!this.abortThread) {
                                try {
                                    this.bodyStream = this.response.getEntity().getContent();
                                    if (this.bodyStream != null) {
                                        this.threadStream = new XThreadInputStream(this.bodyStream);
                                    }
                                    this.streamCreated = true;
                                }
                                catch (SocketTimeoutException e) {
                                    this.streamException = e;
                                }
                                catch (ConnectTimeoutException e) {
                                    this.streamException = e;
                                }
                                catch (InterruptedIOException e) {
                                    throw e;
                                }
                                catch (Throwable e) {
                                    this.streamException = e;
                                }
                                this.notifyAll();
                            }
                        }
                    }
                    if (this.responseException == null && this.streamException == null && this.threadStream != null) {
                        this.threadStream.stuffQueue();
                    }
                }
                finally {
                    if (this.bodyStream != null) {
                        try {
                            this.bodyStream.close();
                        }
                        catch (IOException iOException) {}
                        this.bodyStream = null;
                    }
                    executeMethodThread = this;
                    synchronized (executeMethodThread) {
                        try {
                            this.executeMethod.abort();
                        }
                        catch (Throwable e) {
                            this.shutdownException = e;
                        }
                        this.notifyAll();
                    }
                }
            }
            catch (Throwable e) {
                this.generalException = e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getResponseCode() throws InterruptedException, IOException, HttpException {
            while (true) {
                ExecuteMethodThread executeMethodThread = this;
                synchronized (executeMethodThread) {
                    this.checkException(this.responseException);
                    if (this.response != null) {
                        return this.response.getStatusLine().getStatusCode();
                    }
                    this.wait();
                }
            }
        }

        public long getResponseContentLength() throws InterruptedException, IOException, HttpException {
            String contentLength = this.getFirstHeader("Content-Length");
            if (contentLength == null || contentLength.length() == 0) {
                return -1L;
            }
            return new Long(contentLength.trim());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getFirstHeader(String headerName) throws InterruptedException, IOException, HttpException {
            while (true) {
                ExecuteMethodThread executeMethodThread = this;
                synchronized (executeMethodThread) {
                    this.checkException(this.responseException);
                    if (this.response != null) {
                        Header h = this.response.getFirstHeader(headerName);
                        if (h == null) {
                            return null;
                        }
                        return h.getValue();
                    }
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream getSafeInputStream() throws InterruptedException, IOException, HttpException {
            while (true) {
                ExecuteMethodThread executeMethodThread = this;
                synchronized (executeMethodThread) {
                    if (this.responseException != null) {
                        throw new IllegalStateException("Check for response before getting stream");
                    }
                    this.checkException(this.streamException);
                    if (this.streamCreated) {
                        return this.threadStream;
                    }
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abort() {
            ExecuteMethodThread executeMethodThread = this;
            synchronized (executeMethodThread) {
                if (this.streamCreated && this.threadStream != null) {
                    this.threadStream.abort();
                }
                this.abortThread = true;
            }
        }

        public void finishUp() throws InterruptedException {
            this.join();
        }

        protected synchronized void checkException(Throwable exception) throws IOException, HttpException {
            if (exception != null) {
                Throwable e = exception;
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof HttpException) {
                    throw (HttpException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new RuntimeException("Unhandled exception of type: " + e.getClass().getName(), e);
            }
        }
    }

    protected class DocumentReadingThread
    extends Thread {
        protected Throwable exception = null;
        protected final long docID;
        protected final long versionNumber;
        protected final XThreadInputStream stream;

        public DocumentReadingThread(long docID, long versionNumber) {
            this.docID = docID;
            this.versionNumber = versionNumber;
            this.stream = new XThreadInputStream();
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try (XThreadOutputStream outputStream = new XThreadOutputStream(this.stream);){
                CswsConnector.this.cswsSession.getVersionContents(this.docID, this.versionNumber, (OutputStream)outputStream);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public InputStream getSafeInputStream() {
            return this.stream;
        }

        public void finishUp() throws InterruptedException, ManifoldCFException, ServiceInterruption {
            this.stream.abort();
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof ServiceInterruption) {
                    throw (ServiceInterruption)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unhandled exception of type: " + thr.getClass().getName(), thr);
            }
        }
    }

    protected class RootValue {
        protected final CswsContext llc;
        protected final String workspaceName;
        protected ObjectInformation rootValue = null;
        protected final String remainderPath;

        public RootValue(CswsContext llc, String pathString) {
            this.llc = llc;
            int colonPos = pathString.indexOf(":");
            if (colonPos == -1) {
                this.remainderPath = pathString;
                this.workspaceName = CswsConnector.enterpriseWSName;
            } else {
                this.workspaceName = pathString.substring(0, colonPos);
                this.remainderPath = pathString.substring(colonPos + 1);
            }
        }

        public String getRemainderPath() {
            return this.remainderPath;
        }

        public ObjectInformation getRootValue() throws ManifoldCFException, ServiceInterruption {
            if (this.rootValue == null) {
                this.rootValue = this.llc.getObjectInformation(this.workspaceName);
            }
            if (!this.rootValue.exists()) {
                Logging.connectors.warn((Object)"Csws: Could not get workspace/volume ID!  Retrying...");
                throw new ServiceInterruption("Service interruption getting root value", (Throwable)new ManifoldCFException("Could not get workspace/volume id"), System.currentTimeMillis() + 60000L, System.currentTimeMillis() + 600000L, -1, true);
            }
            return this.rootValue;
        }
    }

    protected class CategoryPathAccumulator {
        protected final CswsContext llc;
        protected final Map<Long, String> categoryPathMap = new HashMap<Long, String>();
        protected final Map<Long, String[]> attributeMap = new HashMap<Long, String[]>();

        public CategoryPathAccumulator(CswsContext llc) {
            this.llc = llc;
        }

        public String[] getCategoryPathsAttributeNames(long[] catIDs) throws ManifoldCFException, ServiceInterruption {
            HashSet<String> set = new HashSet<String>();
            for (long x : catIDs) {
                String[] attributeNames;
                Long key = new Long(x);
                String pathValue = this.categoryPathMap.get(key);
                if (pathValue == null) {
                    pathValue = this.findPath(key.intValue());
                    if (pathValue == null) continue;
                    this.categoryPathMap.put(key, pathValue);
                }
                if ((attributeNames = this.attributeMap.get(key)) == null) {
                    attributeNames = this.findAttributes(key.intValue());
                    if (attributeNames == null) continue;
                    this.attributeMap.put(key, attributeNames);
                }
                for (String attributeName : attributeNames) {
                    String metadataName = CswsConnector.packCategoryAttribute(pathValue, attributeName);
                    set.add(metadataName);
                }
            }
            String[] rval = new String[set.size()];
            int i = 0;
            for (String value : set) {
                rval[i++] = value;
            }
            return rval;
        }

        protected String findPath(long catID) throws ManifoldCFException, ServiceInterruption {
            return this.getObjectPath(this.llc.getObjectInformation(catID));
        }

        protected String getObjectPath(ObjectInformation currentObject) throws ManifoldCFException, ServiceInterruption {
            Object path = null;
            while (currentObject.getWorkspaceName() == null) {
                if (!currentObject.exists()) {
                    Logging.connectors.warn((Object)("Csws: Bad identifier found? " + currentObject.toString() + " apparently does not exist, but need to look up its path"));
                    return null;
                }
                String name = currentObject.getName();
                path = path == null ? name : name + "/" + (String)path;
                if (currentObject.getParentId() == null) {
                    Logging.connectors.warn((Object)("Csws: Object ID " + currentObject.toString() + " doesn't seem to live in enterprise or category workspace!  Path I got was '" + (String)path + "'"));
                    return null;
                }
                long parentID = currentObject.getParentId();
                currentObject = this.llc.getObjectInformation(parentID);
            }
            return currentObject.getWorkspaceName() + (String)(path == null ? "" : ":" + path);
        }

        protected String[] findAttributes(int catID) throws ManifoldCFException, ServiceInterruption {
            return CswsConnector.this.getCategoryAttributes(catID);
        }
    }

    protected class MetadataDescription {
        protected final CswsContext llc;
        protected final Map<String, MetadataPathItem> categoryMap = new HashMap<String, MetadataPathItem>();

        public MetadataDescription(CswsContext llc) {
            this.llc = llc;
        }

        public Iterator<MetadataItem> getItems(String[] metadataItems) throws ManifoldCFException, ServiceInterruption {
            HashMap<String, MetadataItem> newMap = new HashMap<String, MetadataItem>();
            ObjectInformation rootValue = null;
            for (String metadataSpec : metadataItems) {
                StringBuilder categoryBuffer = new StringBuilder();
                StringBuilder attributeBuffer = new StringBuilder();
                CswsConnector.unpackCategoryAttribute(categoryBuffer, attributeBuffer, metadataSpec);
                String category = categoryBuffer.toString();
                String attributeName = attributeBuffer.toString();
                MetadataItem mi = (MetadataItem)newMap.get(category);
                if (mi == null) {
                    MetadataPathItem item = this.categoryMap.get(category);
                    if (item == null) {
                        long catObjectID;
                        RootValue rv = new RootValue(this.llc, category);
                        if (rootValue == null) {
                            rootValue = rv.getRootValue();
                        }
                        if ((catObjectID = rootValue.getCategoryId(rv.getRemainderPath())) != -1L) {
                            item = new MetadataPathItem(catObjectID, rv.getRemainderPath());
                            this.categoryMap.put(category, item);
                        }
                    }
                    mi = new MetadataItem(item);
                    newMap.put(category, mi);
                }
                mi.addAttribute(attributeName);
            }
            return newMap.values().iterator();
        }
    }

    protected class SystemMetadataDescription {
        protected final CswsContext llc;
        protected final String pathAttributeName;
        protected final String pathSeparator;
        protected final Map<String, String> pathMap = new HashMap<String, String>();
        protected final MatchMap matchMap = new MatchMap();
        protected final Set<String> aclMap = new HashSet<String>();
        protected final boolean securityOn;
        protected final String filterString;
        protected final Set<String> holder = new HashSet<String>();
        protected final boolean includeAllMetadata;

        public SystemMetadataDescription(CswsContext llc, Specification spec) throws ManifoldCFException, ServiceInterruption {
            this.llc = llc;
            String pathAttributeName = null;
            String pathSeparator = null;
            boolean securityOn = true;
            StringBuilder fsb = new StringBuilder();
            boolean first = true;
            boolean includeAllMetadata = false;
            for (int i = 0; i < spec.getChildCount(); ++i) {
                SpecificationNode n = spec.getChild(i);
                if (n.getType().equals("pathnameattribute")) {
                    pathAttributeName = n.getAttributeValue("value");
                    pathSeparator = n.getAttributeValue("separator");
                    if (pathSeparator != null) continue;
                    pathSeparator = "/";
                    continue;
                }
                if (n.getType().equals("pathmap")) {
                    String pathMatch = n.getAttributeValue("match");
                    String pathReplace = n.getAttributeValue("replace");
                    this.matchMap.appendMatchPair(pathMatch, pathReplace);
                    continue;
                }
                if (n.getType().equals("access")) {
                    String token = n.getAttributeValue("token");
                    this.aclMap.add(token);
                    continue;
                }
                if (n.getType().equals("security")) {
                    String value = n.getAttributeValue("value");
                    if (value.equals("on")) {
                        securityOn = true;
                        continue;
                    }
                    if (!value.equals("off")) continue;
                    securityOn = false;
                    continue;
                }
                if (n.getType().equals("include")) {
                    int index;
                    String includeMatch = n.getAttributeValue("filespec");
                    if (includeMatch == null || (index = includeMatch.lastIndexOf(".")) == -1) continue;
                    String type = includeMatch.substring(index + 1).toLowerCase(Locale.ROOT);
                    if (first) {
                        first = false;
                    } else {
                        fsb.append(" OR ");
                    }
                    fsb.append("(\"OTFileType\":").append(type).append(")");
                    continue;
                }
                if (n.getType().equals("allmetadata")) {
                    String isAll = n.getAttributeValue("all");
                    if (isAll == null || !isAll.equals("true")) continue;
                    includeAllMetadata = true;
                    continue;
                }
                if (!n.getType().equals("metadata")) continue;
                String category = n.getAttributeValue("category");
                String attributeName = n.getAttributeValue("attribute");
                String isAll = n.getAttributeValue("all");
                if (isAll != null && isAll.equals("true")) {
                    CswsConnector.this.getSession();
                    String[] attrs = CswsConnector.this.getCategoryAttributes(llc, category);
                    if (attrs == null) continue;
                    int j = 0;
                    while (j < attrs.length) {
                        attributeName = attrs[j++];
                        String metadataName = CswsConnector.packCategoryAttribute(category, attributeName);
                        this.holder.add(metadataName);
                    }
                    continue;
                }
                String metadataName = CswsConnector.packCategoryAttribute(category, attributeName);
                this.holder.add(metadataName);
            }
            this.includeAllMetadata = includeAllMetadata;
            this.pathAttributeName = pathAttributeName;
            this.pathSeparator = pathSeparator;
            this.securityOn = securityOn;
            String filterStringPiece = fsb.toString();
            if (filterStringPiece.length() == 0) {
                this.filterString = "0>1";
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("\"OTSubType\":0 OR \"OTSubType\":136 OR \"OTSubType\":202 OR (\"OTSubType\":144 AND (");
                sb.append(filterStringPiece);
                sb.append("))");
                this.filterString = sb.toString();
            }
        }

        public boolean includeAllMetadata() {
            return this.includeAllMetadata;
        }

        public String[] getMetadataAttributes() {
            String[] specifiedMetadataAttributes = new String[this.holder.size()];
            int i = 0;
            for (String attrName : this.holder) {
                specifiedMetadataAttributes[i++] = attrName;
            }
            return specifiedMetadataAttributes;
        }

        public String getFilterString() {
            return this.filterString;
        }

        public String[] getAcls() {
            if (!this.securityOn) {
                return null;
            }
            String[] rval = new String[this.aclMap.size()];
            int i = 0;
            for (String token : this.aclMap) {
                rval[i++] = token;
            }
            return rval;
        }

        public String getPathAttributeName() {
            return this.pathAttributeName;
        }

        public String getPathSeparator() {
            return this.pathSeparator;
        }

        public String getPathAttributeValue(String documentIdentifier) throws ManifoldCFException, ServiceInterruption {
            String path = this.getNodePathString(documentIdentifier);
            if (path == null) {
                return null;
            }
            return this.matchMap.translate(path);
        }

        public String getMatchMapString() {
            return this.matchMap.toString();
        }

        public String getNodePathString(String documentIdentifier) throws ManifoldCFException, ServiceInterruption {
            Object path;
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Looking up path for '" + documentIdentifier + "'"));
            }
            if ((path = this.pathMap.get(documentIdentifier)) == null) {
                long objectID;
                String identifierPart = documentIdentifier;
                if (identifierPart.startsWith("D") || identifierPart.startsWith("F")) {
                    identifierPart = identifierPart.substring(1);
                }
                try {
                    objectID = Integer.parseInt(identifierPart);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Bad document identifier: " + e.getMessage(), (Throwable)e);
                }
                ObjectInformation objInfo = this.llc.getObjectInformation(objectID);
                if (!objInfo.exists()) {
                    Logging.connectors.warn((Object)("Csws: Bad document identifier: '" + documentIdentifier + "' apparently does not exist, but need to find its path"));
                    return null;
                }
                String name = objInfo.getName();
                if (objInfo.getParentId() == null) {
                    path = name;
                } else {
                    long parentID = objInfo.getParentId();
                    String parentIdentifier = "F" + parentID;
                    String parentPath = this.getNodePathString(parentIdentifier);
                    if (parentPath == null) {
                        return null;
                    }
                    path = parentPath + this.pathSeparator + name;
                }
                this.pathMap.put(documentIdentifier, (String)path);
            }
            return path;
        }
    }

    protected static class MetadataItem {
        protected final MetadataPathItem pathItem;
        protected final Set<String> attributeNames = new HashSet<String>();

        public MetadataItem(MetadataPathItem pathItem) {
            this.pathItem = pathItem;
        }

        public void addAttribute(String attributeName) {
            this.attributeNames.add(attributeName);
        }

        public MetadataPathItem getPathItem() {
            return this.pathItem;
        }

        public Iterator<String> getAttributeNames() {
            return this.attributeNames.iterator();
        }
    }

    protected static class MetadataPathItem {
        protected final long catID;
        protected final String catName;

        public MetadataPathItem(long catID, String catName) {
            this.catID = catID;
            this.catName = catName;
        }

        public long getCatID() {
            return this.catID;
        }

        public String getCatName() {
            return this.catName;
        }
    }

    protected class GetObjectCategoryIDsThread
    extends Thread {
        protected final long id;
        protected Throwable exception = null;
        protected long[] rval;

        public GetObjectCategoryIDsThread(long id) {
            this.setDaemon(true);
            this.id = id;
        }

        @Override
        public void run() {
            try {
                List<? extends Node> categories = CswsConnector.this.cswsSession.listNodes(this.id);
                if (categories == null) {
                    return;
                }
                int catCount = 0;
                for (Node node : categories) {
                    if (!node.getType().equals("Category")) continue;
                    ++catCount;
                }
                this.rval = new long[catCount];
                for (Node node : categories) {
                    if (!node.getType().equals("Category")) continue;
                    this.rval[catCount++] = node.getID();
                }
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public long[] finishUp() throws ManifoldCFException, ServiceInterruption, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof ServiceInterruption) {
                    throw (ServiceInterruption)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unrecognized exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class GetWorkspaceInfoThread
    extends Thread {
        protected final String workspaceName;
        protected Throwable exception = null;
        protected Node rval = null;

        public GetWorkspaceInfoThread(String workspaceName) {
            this.setDaemon(true);
            this.workspaceName = workspaceName;
        }

        @Override
        public void run() {
            try {
                this.rval = CswsConnector.this.cswsSession.getRootNode(this.workspaceName);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Node finishUp() throws ManifoldCFException, ServiceInterruption, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof ServiceInterruption) {
                    throw (ServiceInterruption)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unrecognized exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class GetObjectInfoThread
    extends Thread {
        protected final long id;
        protected Throwable exception = null;
        protected Node rval = null;

        public GetObjectInfoThread(long id) {
            this.setDaemon(true);
            this.id = id;
        }

        @Override
        public void run() {
            try {
                this.rval = CswsConnector.this.cswsSession.getNode(this.id);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Node finishUp() throws ManifoldCFException, ServiceInterruption, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof ServiceInterruption) {
                    throw (ServiceInterruption)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unrecognized exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class GetVersionInfoThread
    extends Thread {
        protected final long id;
        protected final long revNumber;
        protected Throwable exception = null;
        protected Version rval = null;

        public GetVersionInfoThread(long id, long revNumber) {
            this.setDaemon(true);
            this.id = id;
            this.revNumber = revNumber;
        }

        @Override
        public void run() {
            try {
                this.rval = CswsConnector.this.cswsSession.getVersion(this.id, this.revNumber);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Version finishUp() throws ManifoldCFException, ServiceInterruption, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof ServiceInterruption) {
                    throw (ServiceInterruption)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unrecognized exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class GetUserInfoThread
    extends Thread {
        protected final long user;
        protected Throwable exception = null;
        protected Member rval = null;

        public GetUserInfoThread(long user) {
            this.setDaemon(true);
            this.user = user;
        }

        @Override
        public void run() {
            try {
                this.rval = CswsConnector.this.cswsSession.getMember(this.user);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Member finishUp() throws ManifoldCFException, ServiceInterruption, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof ServiceInterruption) {
                    throw (ServiceInterruption)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unrecognized exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class GetUserResultsThread
    extends Thread {
        protected final PageHandle pageHandle;
        protected List<? extends Member> rval = null;
        protected Throwable exception = null;

        public GetUserResultsThread(PageHandle pageHandle) {
            this.pageHandle = pageHandle;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.rval = CswsConnector.this.cswsSession.getNextUserSearchResults(this.pageHandle);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public List<? extends Member> finishUp() throws ManifoldCFException, ServiceInterruption, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof ServiceInterruption) {
                    throw (ServiceInterruption)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unrecognized exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class ListUsersThread
    extends Thread {
        protected PageHandle rval = null;
        protected Throwable exception = null;

        public ListUsersThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.rval = CswsConnector.this.cswsSession.getAllUsers();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public PageHandle finishUp() throws ManifoldCFException, ServiceInterruption, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof ServiceInterruption) {
                    throw (ServiceInterruption)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unrecognized exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class ObjectInformation {
        protected final long objectID;
        protected final String workspaceName;
        protected Node objectValue = null;
        protected boolean fetched = false;

        public ObjectInformation(long objectID) {
            this.objectID = objectID;
            this.workspaceName = null;
        }

        public ObjectInformation(String workspaceName) {
            this.workspaceName = workspaceName;
            this.objectID = -1L;
        }

        public String getWorkspaceName() {
            return this.workspaceName;
        }

        public boolean exists() throws ServiceInterruption, ManifoldCFException {
            return this.getObjectValue() != null;
        }

        public String toString() {
            return "(Object: " + this.objectID + ")";
        }

        public boolean getSpecifiedCategoryAttribute(RepositoryDocument rd, long catID, String catName) throws ServiceInterruption, ManifoldCFException {
            Node objInfo = this.getObjectValue();
            if (objInfo == null) {
                return false;
            }
            List<AttributeGroup> attributeGroups = objInfo.getMetadata().getAttributeGroups();
            for (AttributeGroup attribute : attributeGroups) {
                int index = attribute.getKey().indexOf(".");
                String categoryAttributeName = attribute.getDisplayName();
                String categoryId = attribute.getKey().substring(0, index);
                long attrCatID = new Long(categoryId);
                if (attrCatID != catID) continue;
                List<DataValue> dataValues = attribute.getValues();
                boolean i = false;
                for (DataValue dataValue : dataValues) {
                    List<Object> valArray;
                    PrimitiveValue typedAttr;
                    int j = 0;
                    String[] valuesToIndex1 = null;
                    if (dataValue instanceof StringValue) {
                        typedAttr = (StringValue)dataValue;
                        valArray = ((StringValue)typedAttr).getValues();
                        if (valArray != null) {
                            valuesToIndex1 = new String[valArray.size()];
                            for (Object valueToIndex : valArray) {
                                valuesToIndex1[j++] = valueToIndex;
                            }
                        }
                    } else if (dataValue instanceof DateValue && (valArray = ((DateValue)(typedAttr = (DateValue)dataValue)).getValues()) != null) {
                        valuesToIndex1 = new String[valArray.size()];
                        for (Object valueToIndex : valArray) {
                            valuesToIndex1[j++] = ((XMLGregorianCalendar)valueToIndex).toString();
                        }
                    }
                    if (valuesToIndex1 == null) continue;
                    rd.addField(catName + "." + dataValue.getDescription(), valuesToIndex1);
                }
            }
            return true;
        }

        public Long getPathId(String startPath) throws ServiceInterruption, ManifoldCFException {
            Node objInfo = this.getObjectValue();
            if (objInfo == null) {
                return null;
            }
            long obj = objInfo.getID();
            int charindex = 0;
            while (charindex < startPath.length()) {
                char x;
                StringBuilder currentTokenBuffer = new StringBuilder();
                while (charindex < startPath.length() && (x = startPath.charAt(charindex++)) != '/') {
                    if (x == '\\') {
                        x = startPath.charAt(charindex);
                        ++charindex;
                    }
                    currentTokenBuffer.append(x);
                }
                String subFolder = currentTokenBuffer.toString();
                String filterString = "(\"OTSubType\":0 OR \"OTSubType\":202 OR \"OTSubType\":136) AND \"OTName\":\"" + subFolder + "\"";
                ListObjectsThread t = new ListObjectsThread(obj, new String[]{"OTDataID", "OTSubTypeName"}, CswsConnector.this.dataCollection, filterString, "OTDataID");
                try {
                    t.start();
                    List<? extends SGraph> children = t.finishUp();
                    if (children == null) {
                        return null;
                    }
                    if (children.size() == 1) {
                        for (SGraph sGraph : children) {
                            obj = CswsConnector.getID(sGraph, 0);
                            String subtype = CswsConnector.getString(sGraph, 1);
                            if (!subtype.equals("Project")) continue;
                            obj = -obj;
                        }
                        continue;
                    }
                    return null;
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                }
            }
            return new Long(obj);
        }

        public List<? extends AttributeGroup> getAttributeGroups() throws ManifoldCFException, ServiceInterruption {
            Node elem = this.getObjectValue();
            if (elem == null) {
                return null;
            }
            Metadata m = elem.getMetadata();
            if (m == null) {
                return new ArrayList(0);
            }
            return m.getAttributeGroups();
        }

        public long[] getObjectCategoryIDs() throws ManifoldCFException, ServiceInterruption {
            return CswsConnector.this.getSuperObjectCategoryIDs(this.objectID);
        }

        public long getCategoryId(String startPath) throws ManifoldCFException, ServiceInterruption {
            Node objInfo = this.getObjectValue();
            if (objInfo == null) {
                return -1L;
            }
            long obj = objInfo.getID();
            if (startPath.length() == 0) {
                return -1L;
            }
            int charindex = 0;
            while (charindex < startPath.length()) {
                char x;
                StringBuilder currentTokenBuffer = new StringBuilder();
                while (charindex < startPath.length() && (x = startPath.charAt(charindex++)) != '/') {
                    if (x == '\\') {
                        x = startPath.charAt(charindex);
                        ++charindex;
                    }
                    currentTokenBuffer.append(x);
                }
                String subFolder = currentTokenBuffer.toString();
                Object filterString = charindex < startPath.length() ? "(\"OTSubType\":0 OR \"OTSubType\":202 OR \"OTSubType\":136)" : "\"OTSubType\":131";
                filterString = (String)filterString + " AND \"OTName\":\"" + subFolder + "\"";
                ListObjectsThread t = new ListObjectsThread(obj, new String[]{"OTDataID", "OTSubTypeName"}, CswsConnector.this.dataCollection, (String)filterString, "OTDataID");
                try {
                    t.start();
                    List<? extends SGraph> children = t.finishUp();
                    if (children == null) {
                        return -1L;
                    }
                    if (children.size() == 1) {
                        for (SGraph sGraph : children) {
                            obj = CswsConnector.getID(sGraph, 0);
                            String subtype = CswsConnector.getString(sGraph, 1);
                            if (!subtype.equals("Project")) continue;
                            obj = -obj;
                        }
                        continue;
                    }
                    return -1L;
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                }
            }
            return obj;
        }

        public NodePermissions getPermissions() throws ServiceInterruption, ManifoldCFException {
            Node elem = this.getObjectValue();
            if (elem == null) {
                return null;
            }
            return elem.getPermissions();
        }

        public String getName() throws ServiceInterruption, ManifoldCFException {
            Node elem = this.getObjectValue();
            if (elem == null) {
                return null;
            }
            return elem.getName();
        }

        public String getComments() throws ServiceInterruption, ManifoldCFException {
            Node elem = this.getObjectValue();
            if (elem == null) {
                return null;
            }
            return elem.getComment();
        }

        public Long getParentId() throws ServiceInterruption, ManifoldCFException {
            Node elem = this.getObjectValue();
            if (elem == null) {
                return null;
            }
            return elem.getParentID();
        }

        public Date getCreationDate() throws ServiceInterruption, ManifoldCFException {
            Node elem = this.getObjectValue();
            if (elem == null) {
                return null;
            }
            return new Date(elem.getCreateDate().toGregorianCalendar().getTimeInMillis());
        }

        public Long getCreatorId() throws ServiceInterruption, ManifoldCFException {
            Node elem = this.getObjectValue();
            if (elem == null) {
                return null;
            }
            return elem.getCreatedBy();
        }

        public Date getModifyDate() throws ServiceInterruption, ManifoldCFException {
            Node elem = this.getObjectValue();
            if (elem == null) {
                return null;
            }
            return new Date(elem.getModifyDate().toGregorianCalendar().getTimeInMillis());
        }

        protected Node getObjectValue() throws ServiceInterruption, ManifoldCFException {
            if (!this.fetched) {
                if (this.workspaceName != null) {
                    GetWorkspaceInfoThread t = new GetWorkspaceInfoThread(this.workspaceName);
                    try {
                        t.start();
                        this.objectValue = t.finishUp();
                    }
                    catch (InterruptedException e) {
                        t.interrupt();
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                    }
                    this.fetched = true;
                } else {
                    GetObjectInfoThread t = new GetObjectInfoThread(this.objectID);
                    try {
                        t.start();
                        this.objectValue = t.finishUp();
                    }
                    catch (InterruptedException e) {
                        t.interrupt();
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                    }
                    this.fetched = true;
                }
            }
            return this.objectValue;
        }

        public int hashCode() {
            if (this.workspaceName != null) {
                return this.workspaceName.hashCode();
            }
            return Long.hashCode(this.objectID);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ObjectInformation)) {
                return false;
            }
            ObjectInformation other = (ObjectInformation)o;
            if (this.workspaceName != null || other.workspaceName != null) {
                if (this.workspaceName == null || other.workspaceName == null) {
                    return false;
                }
                return this.workspaceName.equals(other.workspaceName);
            }
            return this.objectID == other.objectID;
        }
    }

    protected class VersionInformation {
        protected final long objectID;
        protected final long revisionNumber;
        protected boolean fetched = false;
        protected Version versionValue = null;

        public VersionInformation(long objectID, long revisionNumber) {
            this.objectID = objectID;
            this.revisionNumber = revisionNumber;
        }

        public boolean exists() throws ServiceInterruption, ManifoldCFException {
            return this.getVersionValue() != null;
        }

        public Long getDataSize() throws ServiceInterruption, ManifoldCFException {
            Version elem = this.getVersionValue();
            if (elem == null) {
                return null;
            }
            return elem.getFileDataSize();
        }

        public String getFileName() throws ServiceInterruption, ManifoldCFException {
            Version elem = this.getVersionValue();
            if (elem == null) {
                return null;
            }
            return elem.getFilename();
        }

        public String getMimeType() throws ServiceInterruption, ManifoldCFException {
            Version elem = this.getVersionValue();
            if (elem == null) {
                return null;
            }
            return elem.getMimeType();
        }

        public Date getModifyDate() throws ServiceInterruption, ManifoldCFException {
            Version elem = this.getVersionValue();
            if (elem == null) {
                return null;
            }
            return new Date(elem.getModifyDate().toGregorianCalendar().getTimeInMillis());
        }

        public Long getOwnerId() throws ServiceInterruption, ManifoldCFException {
            Version elem = this.getVersionValue();
            if (elem == null) {
                return null;
            }
            return elem.getOwner();
        }

        protected Version getVersionValue() throws ServiceInterruption, ManifoldCFException {
            if (!this.fetched) {
                GetVersionInfoThread t = new GetVersionInfoThread(this.objectID, this.revisionNumber);
                try {
                    t.start();
                    this.versionValue = t.finishUp();
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                }
                this.fetched = true;
            }
            return this.versionValue;
        }

        public int hashCode() {
            return Long.hashCode(this.objectID) + Long.hashCode(this.revisionNumber);
        }

        public boolean equals(Object o) {
            if (!(o instanceof VersionInformation)) {
                return false;
            }
            VersionInformation other = (VersionInformation)o;
            return this.objectID == other.objectID && this.revisionNumber == other.revisionNumber;
        }
    }

    protected class UserInformation {
        protected final long userID;
        protected boolean fetched = false;
        protected Member userValue = null;

        public UserInformation(long userID) {
            this.userID = userID;
        }

        public boolean exists() throws ServiceInterruption, ManifoldCFException {
            return this.getUserValue() != null;
        }

        public String getName() throws ServiceInterruption, ManifoldCFException {
            Member userValue = this.getUserValue();
            if (userValue == null) {
                return null;
            }
            return userValue.getName();
        }

        protected Member getUserValue() throws ServiceInterruption, ManifoldCFException {
            if (!this.fetched) {
                GetUserInfoThread t = new GetUserInfoThread(this.userID);
                try {
                    t.start();
                    this.userValue = t.finishUp();
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                }
                this.fetched = true;
            }
            return this.userValue;
        }

        public String toString() {
            return "(" + this.userID + ")";
        }

        public int hashCode() {
            return Long.hashCode(this.userID);
        }

        public boolean equals(Object o) {
            if (!(o instanceof UserInformation)) {
                return false;
            }
            UserInformation other = (UserInformation)o;
            return this.userID == other.userID;
        }
    }

    protected class CswsContext {
        protected final Map<ObjectInformation, ObjectInformation> objectInfoMap = new HashMap<ObjectInformation, ObjectInformation>();
        protected final Map<VersionInformation, VersionInformation> versionInfoMap = new HashMap<VersionInformation, VersionInformation>();
        protected final Map<UserInformation, UserInformation> userInfoMap = new HashMap<UserInformation, UserInformation>();

        public ObjectInformation getObjectInformation(String workspaceName) {
            ObjectInformation oi = new ObjectInformation(workspaceName);
            ObjectInformation lookupValue = this.objectInfoMap.get(oi);
            if (lookupValue == null) {
                this.objectInfoMap.put(oi, oi);
                return oi;
            }
            return lookupValue;
        }

        public ObjectInformation getObjectInformation(long objectID) {
            ObjectInformation oi = new ObjectInformation(objectID);
            ObjectInformation lookupValue = this.objectInfoMap.get(oi);
            if (lookupValue == null) {
                this.objectInfoMap.put(oi, oi);
                return oi;
            }
            return lookupValue;
        }

        public VersionInformation getVersionInformation(long objectID, int revisionNumber) {
            VersionInformation vi = new VersionInformation(objectID, revisionNumber);
            VersionInformation lookupValue = this.versionInfoMap.get(vi);
            if (lookupValue == null) {
                this.versionInfoMap.put(vi, vi);
                return vi;
            }
            return lookupValue;
        }

        public UserInformation getUserInformation(long userID) {
            UserInformation ui = new UserInformation(userID);
            UserInformation lookupValue = this.userInfoMap.get(ui);
            if (lookupValue == null) {
                this.userInfoMap.put(ui, ui);
                return ui;
            }
            return lookupValue;
        }
    }

    protected class GetObjectRightsThread
    extends Thread {
        protected final long objID;
        protected Throwable exception = null;
        protected NodeRights rval = null;

        public GetObjectRightsThread(long objID) {
            this.setDaemon(true);
            this.objID = objID;
        }

        @Override
        public void run() {
            try {
                this.rval = CswsConnector.this.cswsSession.getNodeRights(this.objID);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public NodeRights finishUp() throws ManifoldCFException, ServiceInterruption, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof ServiceInterruption) {
                    throw (ServiceInterruption)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unrecognized exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class GetCategoryAttributesThread
    extends Thread {
        protected final long catObjectID;
        protected Throwable exception = null;
        protected String[] rval = null;

        public GetCategoryAttributesThread(long catObjectID) {
            this.setDaemon(true);
            this.catObjectID = catObjectID;
        }

        @Override
        public void run() {
            try {
                AttributeGroupDefinition def = CswsConnector.this.cswsSession.getCategoryDefinition(this.catObjectID);
                if (def == null) {
                    return;
                }
                List<Attribute> atts = def.getAttributes();
                int attrCount = 0;
                for (Attribute at : atts) {
                    ++attrCount;
                }
                this.rval = new String[attrCount];
                attrCount = 0;
                for (Attribute at : atts) {
                    this.rval[attrCount++] = at.getDisplayName();
                }
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public String[] finishUp() throws ManifoldCFException, ServiceInterruption, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof ServiceInterruption) {
                    throw (ServiceInterruption)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unrecognized exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    public static final class Pair<L, R> {
        private final L left;
        private final R right;

        public Pair(L left, R right) {
            this.left = left;
            this.right = right;
        }

        public L getLeft() {
            return this.left;
        }

        public R getRight() {
            return this.right;
        }

        public String toString() {
            return String.valueOf(this.left) + "=" + String.valueOf(this.right);
        }
    }

    protected class ListObjectsThread
    extends Thread {
        protected final long objID;
        protected final String[] outputColumns;
        protected final String filterString;
        protected final String orderingColumn;
        protected final String dataCollection;
        protected Throwable exception = null;
        protected List<? extends SGraph> rval = null;

        public ListObjectsThread(long objID, String[] outputColumns, String dataCollection, String filterString, String orderingColumn) {
            this.setDaemon(true);
            this.objID = objID;
            this.outputColumns = outputColumns;
            this.dataCollection = dataCollection;
            this.filterString = filterString;
            this.orderingColumn = orderingColumn;
        }

        @Override
        public void run() {
            try {
                this.rval = CswsConnector.this.cswsSession.searchFor(this.objID, this.outputColumns, this.dataCollection, this.filterString, this.orderingColumn, 0, 100000);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public List<? extends SGraph> finishUp() throws ManifoldCFException, ServiceInterruption, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof ServiceInterruption) {
                    throw (ServiceInterruption)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unrecognized exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class GetSessionThread
    extends Thread {
        protected Throwable exception = null;

        public GetSessionThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                List<? extends String> workspaceNames = CswsConnector.this.cswsSession.getRootNodeTypes();
                CswsConnector.this.workspaceNodes.clear();
                for (String string : workspaceNames) {
                    CswsConnector.this.workspaceNodes.put(string, CswsConnector.this.cswsSession.getRootNode(string));
                }
                CswsConnector.this.enterpriseWSID = CswsConnector.this.workspaceNodes.get(CswsConnector.enterpriseWSName).getID();
                CswsConnector.this.categoryWSID = CswsConnector.this.workspaceNodes.get(CswsConnector.categoryWSName).getID();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws ManifoldCFException, ServiceInterruption, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof ServiceInterruption) {
                    throw (ServiceInterruption)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unrecognized exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
        }
    }
}

