/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.EmbeddedLessGenerator;
import com.github.sommeri.less4j.EmbeddedScriptGenerator;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.AnonymousExpression;
import com.github.sommeri.less4j.core.ast.BinaryExpression;
import com.github.sommeri.less4j.core.ast.BinaryExpressionOperator;
import com.github.sommeri.less4j.core.ast.ComparisonExpression;
import com.github.sommeri.less4j.core.ast.ComparisonExpressionOperator;
import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.DetachedRuleset;
import com.github.sommeri.less4j.core.ast.EmbeddedScript;
import com.github.sommeri.less4j.core.ast.EscapedValue;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FaultyExpression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.Guard;
import com.github.sommeri.less4j.core.ast.GuardBinary;
import com.github.sommeri.less4j.core.ast.GuardCondition;
import com.github.sommeri.less4j.core.ast.GuardNegated;
import com.github.sommeri.less4j.core.ast.IdentifierExpression;
import com.github.sommeri.less4j.core.ast.IndirectVariable;
import com.github.sommeri.less4j.core.ast.ListExpression;
import com.github.sommeri.less4j.core.ast.ListExpressionOperator;
import com.github.sommeri.less4j.core.ast.NamedExpression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.ast.ParenthesesExpression;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.SignedExpression;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.compiler.expressions.ArithmeticCalculator;
import com.github.sommeri.less4j.core.compiler.expressions.ColorFunctions;
import com.github.sommeri.less4j.core.compiler.expressions.ColorsCalculator;
import com.github.sommeri.less4j.core.compiler.expressions.CustomFunctions;
import com.github.sommeri.less4j.core.compiler.expressions.EmbeddedScriptFunctions;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionComparator;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionFilter;
import com.github.sommeri.less4j.core.compiler.expressions.FunctionsPackage;
import com.github.sommeri.less4j.core.compiler.expressions.GuardsComparator;
import com.github.sommeri.less4j.core.compiler.expressions.MathFunctions;
import com.github.sommeri.less4j.core.compiler.expressions.MiscFunctions;
import com.github.sommeri.less4j.core.compiler.expressions.StringFunctions;
import com.github.sommeri.less4j.core.compiler.expressions.TypeFunctions;
import com.github.sommeri.less4j.core.compiler.expressions.UnknownFunction;
import com.github.sommeri.less4j.core.compiler.expressions.VariableCycleDetector;
import com.github.sommeri.less4j.core.compiler.expressions.strings.StringInterpolator;
import com.github.sommeri.less4j.core.compiler.scopes.IScope;
import com.github.sommeri.less4j.core.compiler.scopes.NullScope;
import com.github.sommeri.less4j.core.compiler.scopes.ScopeFactory;
import com.github.sommeri.less4j.core.problems.BugHappened;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.utils.InStringCssPrinter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ExpressionEvaluator {
    private VariableCycleDetector cycleDetector = new VariableCycleDetector();
    private final IScope lazyScope;
    private final ProblemsHandler problemsHandler;
    private ArithmeticCalculator arithmeticCalculator;
    private ColorsCalculator colorsCalculator;
    private ExpressionComparator comparator = new GuardsComparator();
    private List<FunctionsPackage> functions = new ArrayList<FunctionsPackage>(10);
    private StringInterpolator stringInterpolator;
    private StringInterpolator embeddedScriptInterpolator;
    private EmbeddedScriptGenerator embeddedScripting;

    public ExpressionEvaluator(ProblemsHandler problemsHandler, LessCompiler.Configuration configuration) {
        this(new NullScope(), problemsHandler, configuration);
    }

    public ExpressionEvaluator(IScope scope, ProblemsHandler problemsHandler, LessCompiler.Configuration configuration) {
        this.lazyScope = scope == null ? new NullScope() : scope;
        this.problemsHandler = problemsHandler;
        this.arithmeticCalculator = new ArithmeticCalculator(problemsHandler);
        this.colorsCalculator = new ColorsCalculator(problemsHandler);
        this.embeddedScripting = configuration.getEmbeddedScriptGenerator() == null ? new EmbeddedLessGenerator() : configuration.getEmbeddedScriptGenerator();
        this.stringInterpolator = new StringInterpolator(problemsHandler);
        this.embeddedScriptInterpolator = new StringInterpolator(this.embeddedScripting, problemsHandler);
        this.functions.add(new CustomFunctions(problemsHandler, configuration.getCustomFunctions()));
        this.functions.add(new MathFunctions(problemsHandler));
        this.functions.add(new StringFunctions(problemsHandler));
        this.functions.add(new ColorFunctions(problemsHandler));
        this.functions.add(new EmbeddedScriptFunctions(problemsHandler));
        this.functions.add(new TypeFunctions(problemsHandler));
        this.functions.add(new MiscFunctions(problemsHandler, configuration));
    }

    protected void addFunctionsPack(FunctionsPackage pack) {
        this.functions.add(pack);
    }

    public List<Expression> evaluateAll(List<Expression> expressions) {
        ArrayList<Expression> values = new ArrayList<Expression>();
        for (Expression argument : expressions) {
            values.add(this.evaluate(argument));
        }
        return values;
    }

    public IScope evaluateValues(IScope scope) {
        IScope result = ScopeFactory.createDummyScope();
        result.addFilteredVariables(this.toEvaluationFilter(), scope);
        return result;
    }

    private ExpressionFilter toEvaluationFilter() {
        return new ExpressionFilter(){

            @Override
            public Expression apply(Expression input) {
                return ExpressionEvaluator.this.evaluate(input);
            }

            @Override
            public boolean accepts(String name, Expression value) {
                return true;
            }
        };
    }

    public Expression evaluate(CssString input) {
        String value = this.stringInterpolator.replaceIn(input.getValue(), this, input.getUnderlyingStructure());
        return new CssString(input.getUnderlyingStructure(), value, input.getQuoteType());
    }

    public Expression evaluate(EscapedValue input) {
        String value = this.stringInterpolator.replaceIn(input.getValue(), this, input.getUnderlyingStructure());
        return new EscapedValue(input.getUnderlyingStructure(), value, input.getQuoteType());
    }

    public Expression evaluate(EmbeddedScript input) {
        String value = this.embeddedScriptInterpolator.replaceIn(input.getValue(), this, input.getUnderlyingStructure());
        return new EmbeddedScript(input.getUnderlyingStructure(), value);
    }

    public Expression evaluate(Variable input) {
        return this.evaluate(input, true);
    }

    public Expression evaluateIfPresent(Variable input) {
        return this.evaluate(input, false);
    }

    private Expression evaluate(Variable input, boolean failOnUndefined) {
        if (this.cycleDetector.wouldCycle(input)) {
            this.problemsHandler.variablesCycle(this.cycleDetector.getCycleFor(input));
            return new FaultyExpression(input);
        }
        Expression expression = this.lazyScope.getValue(input);
        if (expression == null) {
            return this.handleUndefinedVariable(input, failOnUndefined);
        }
        this.cycleDetector.enteringVariableValue(input);
        Expression result = this.evaluate(expression);
        this.cycleDetector.leftVariableValue();
        return result;
    }

    public Expression evaluate(IndirectVariable input) {
        Expression reference = this.evaluate(this.lazyScope.getValue(input));
        InStringCssPrinter printer = new InStringCssPrinter();
        printer.append(reference);
        String realName = printer.toString();
        Variable directVariable = new Variable(input.getUnderlyingStructure(), "@" + realName);
        return this.evaluate(directVariable);
    }

    public Expression evaluate(Expression input) {
        switch (input.getType()) {
            case FUNCTION: {
                return this.evaluate((FunctionExpression)input);
            }
            case BINARY_EXPRESSION: {
                return this.evaluate((BinaryExpression)input);
            }
            case LIST_EXPRESSION: {
                return this.evaluate((ListExpression)input);
            }
            case INDIRECT_VARIABLE: {
                return this.evaluate((IndirectVariable)input);
            }
            case VARIABLE: {
                return this.evaluate((Variable)input);
            }
            case PARENTHESES_EXPRESSION: {
                return this.evaluate(((ParenthesesExpression)input).getEnclosedExpression());
            }
            case SIGNED_EXPRESSION: {
                return this.evaluate((SignedExpression)input);
            }
            case NAMED_EXPRESSION: {
                return this.evaluate((NamedExpression)input);
            }
            case STRING_EXPRESSION: {
                return this.evaluate((CssString)input);
            }
            case ESCAPED_VALUE: {
                return this.evaluate((EscapedValue)input);
            }
            case EMBEDDED_SCRIPT: {
                return this.evaluate((EmbeddedScript)input);
            }
            case DETACHED_RULESET: {
                return this.evaluate((DetachedRuleset)input);
            }
            case IDENTIFIER_EXPRESSION: 
            case COLOR_EXPRESSION: 
            case NUMBER: 
            case FAULTY_EXPRESSION: 
            case UNICODE_RANGE_EXPRESSION: 
            case EMPTY_EXPRESSION: 
            case ANONYMOUS: {
                return input.clone();
            }
        }
        throw new BugHappened("Unknown expression type " + (Object)((Object)input.getType()), (ASTCssNode)input);
    }

    private boolean booleanEvalueate(Expression input) {
        if (input.getType() == ASTCssNodeType.COMPARISON_EXPRESSION) {
            return this.booleanEvalueate((ComparisonExpression)input);
        }
        Expression value = this.evaluate(input);
        if (value.getType() != ASTCssNodeType.IDENTIFIER_EXPRESSION) {
            return false;
        }
        IdentifierExpression identifier = (IdentifierExpression)value;
        return "true".equals(identifier.getValue());
    }

    public boolean booleanEvalueate(ComparisonExpression input) {
        Expression leftE = this.evaluate(input.getLeft());
        Expression rightE = this.evaluate(input.getRight());
        ComparisonExpressionOperator operator = input.getOperator();
        if (operator.getOperator() == ComparisonExpressionOperator.Operator.OPEQ) {
            return this.comparator.equal(leftE, rightE);
        }
        if (leftE.getType() != ASTCssNodeType.NUMBER) {
            this.problemsHandler.incompatibleComparisonOperand(leftE, operator);
            return false;
        }
        if (rightE.getType() != ASTCssNodeType.NUMBER) {
            this.problemsHandler.incompatibleComparisonOperand(rightE, operator);
            return false;
        }
        return this.compareNumbers((NumberExpression)leftE, (NumberExpression)rightE, operator);
    }

    private boolean compareNumbers(NumberExpression leftE, NumberExpression rightE, ComparisonExpressionOperator operator) {
        if (!leftE.convertibleTo(rightE)) {
            return false;
        }
        Double left = leftE.convertIfPossible(rightE.getSuffix()).getValueAsDouble();
        Double right = rightE.getValueAsDouble();
        switch (operator.getOperator()) {
            case GREATER: {
                return left.compareTo(right) > 0;
            }
            case GREATER_OR_EQUAL: {
                return left.compareTo(right) >= 0;
            }
            case LOWER_OR_EQUAL: {
                return left.compareTo(right) <= 0;
            }
            case LOWER: {
                return left.compareTo(right) < 0;
            }
        }
        throw new BugHappened("Unexpected comparison operator", (ASTCssNode)operator);
    }

    public Expression evaluate(FunctionExpression input) {
        ArrayList<Expression> splitParameters;
        Expression evaluatedParameter = this.evaluate(input.getParameter());
        List<Object> list = splitParameters = evaluatedParameter.getType() == ASTCssNodeType.EMPTY_EXPRESSION ? new ArrayList() : evaluatedParameter.splitByComma();
        if (!input.isCssOnlyFunction()) {
            for (FunctionsPackage pack : this.functions) {
                if (!pack.canEvaluate(input, splitParameters)) continue;
                return pack.evaluate(input, splitParameters, evaluatedParameter);
            }
        }
        UnknownFunction unknownFunction = new UnknownFunction();
        return unknownFunction.evaluate(splitParameters, this.problemsHandler, input, evaluatedParameter);
    }

    public Expression evaluate(ListExpression input) {
        ArrayList<Expression> evaluated = new ArrayList<Expression>();
        for (Expression expression : input.getExpressions()) {
            evaluated.add(this.evaluate(expression));
        }
        ListExpression result = new ListExpression(input.getUnderlyingStructure(), evaluated, input.getOperator().clone(), input.getScope());
        result.configureParentToAllChilds();
        return result;
    }

    public Expression evaluate(NamedExpression input) {
        NamedExpression result = new NamedExpression(input.getUnderlyingStructure(), input.getName(), this.evaluate(input.getExpression()), input.getScope());
        result.configureParentToAllChilds();
        return result;
    }

    public Expression evaluate(SignedExpression input) {
        Expression evaluate = this.evaluate(input.getExpression());
        if (evaluate instanceof NumberExpression) {
            NumberExpression negation = ((NumberExpression)evaluate).clone();
            if (input.getSign() == SignedExpression.Sign.PLUS) {
                return negation;
            }
            negation.negate();
            negation.setOriginalString(null);
            negation.setExpliciteSign(false);
            return negation;
        }
        this.problemsHandler.nonNumberNegation(input);
        return new FaultyExpression(input);
    }

    public Expression evaluate(BinaryExpression input) {
        Expression leftValue = this.evaluate(input.getLeft());
        Expression rightValue = this.evaluate(input.getRight());
        BinaryExpressionOperator operator = input.getOperator();
        if (leftValue.isFaulty() || rightValue.isFaulty()) {
            return new FaultyExpression(input);
        }
        if (this.arithmeticCalculator.accepts(operator, leftValue, rightValue)) {
            return this.arithmeticCalculator.evalute(input, leftValue, rightValue);
        }
        if (this.colorsCalculator.accepts(operator, leftValue, rightValue)) {
            return this.colorsCalculator.evalute(input, leftValue, rightValue);
        }
        List<Expression> members = Arrays.asList(leftValue, new AnonymousExpression(operator.getUnderlyingStructure(), operator.getOperator().getSymbol()), rightValue);
        ListExpression result = new ListExpression(input.getUnderlyingStructure(), members, new ListExpressionOperator(input.getUnderlyingStructure(), ListExpressionOperator.Operator.EMPTY_OPERATOR), this.lazyScope);
        return result;
    }

    public boolean guardsSatisfied(ReusableStructure mixin) {
        return this.evaluate(mixin.getGuards());
    }

    public boolean guardsSatisfied(RuleSet ruleSet) {
        return this.evaluate(ruleSet.getGuards());
    }

    public boolean evaluate(List<Guard> guards) {
        if (guards == null || guards.isEmpty()) {
            return true;
        }
        for (Guard guard : guards) {
            if (!this.evaluate(guard)) continue;
            return true;
        }
        return false;
    }

    public boolean evaluate(Guard guard) {
        switch (guard.getGuardType()) {
            case BINARY: {
                return this.evaluate((GuardBinary)guard);
            }
            case CONDITION: {
                return this.evaluate((GuardCondition)guard);
            }
            case NEGATED: {
                return this.evaluate((GuardNegated)guard);
            }
        }
        throw new BugHappened("Unexpected guard type (" + (Object)((Object)guard.getGuardType()) + ")", (ASTCssNode)guard);
    }

    private boolean evaluate(GuardBinary guard) {
        boolean left = this.evaluate(guard.getLeft());
        switch (guard.getOperator()) {
            case AND: {
                boolean result = !left ? false : this.evaluate(guard.getRight());
                return result;
            }
            case OR: {
                boolean result = left ? true : this.evaluate(guard.getRight());
                return result;
            }
        }
        throw new BugHappened("Unexpected guard logical operator (" + (Object)((Object)guard.getOperator()) + ")", (ASTCssNode)guard);
    }

    private boolean evaluate(GuardNegated guard) {
        boolean nestedGuardValue = this.evaluate(guard.getGuard());
        boolean result = guard.isNegated() ? !nestedGuardValue : nestedGuardValue;
        return result;
    }

    private boolean evaluate(GuardCondition guardCondition) {
        Expression condition = guardCondition.getCondition();
        boolean result = this.booleanEvalueate(condition);
        return result;
    }

    public boolean isRatioExpression(Expression expression) {
        if (!(expression instanceof BinaryExpression)) {
            return false;
        }
        BinaryExpression composed = (BinaryExpression)expression;
        if (composed.getOperator().getOperator() != BinaryExpressionOperator.Operator.SOLIDUS) {
            return false;
        }
        if (composed.getLeft().getType() != ASTCssNodeType.NUMBER) {
            return false;
        }
        return composed.getRight().getType() == ASTCssNodeType.NUMBER;
    }

    public Expression evaluate(DetachedRuleset input) {
        DetachedRuleset clone = input.clone();
        IScope owningScope = clone.getScope();
        if (owningScope == null) {
            throw new BugHappened("Detached ruleset with unknown scope.", (ASTCssNode)input);
        }
        return clone;
    }

    private Expression handleUndefinedVariable(Variable variable, boolean failOnUndefined) {
        if (failOnUndefined) {
            this.problemsHandler.undefinedVariable(variable);
            return new FaultyExpression(variable);
        }
        return null;
    }
}

