/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.skeleton;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.gagravarr.ogg.HighLevelOggStreamPacket;
import org.gagravarr.ogg.IOUtils;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.skeleton.SkeletonPacket;

public class SkeletonFishead
extends HighLevelOggStreamPacket
implements SkeletonPacket {
    private int versionMajor;
    private int versionMinor;
    private long presentationTimeNumerator;
    private long presentationTimeDenominator;
    private long baseTimeNumerator;
    private long baseTimeDenominator;
    private String utc;
    private long segmentLength;
    private long contentOffset;

    public SkeletonFishead() {
        this.versionMajor = 4;
        this.versionMinor = 0;
    }

    public SkeletonFishead(OggPacket pkt) {
        super(pkt);
        byte[] data = this.getData();
        if (!IOUtils.byteRangeMatches(MAGIC_FISHEAD_BYTES, data, 0)) {
            throw new IllegalArgumentException("Invalid type, not a Skeleton Fishead Header");
        }
        this.versionMajor = IOUtils.getInt2(data, 8);
        this.versionMinor = IOUtils.getInt2(data, 10);
        if (this.versionMajor < 3 || this.versionMajor > 4) {
            throw new IllegalArgumentException("Unsupported Skeleton version " + this.versionMajor + " detected");
        }
        this.presentationTimeNumerator = IOUtils.getInt8(data, 12);
        this.presentationTimeDenominator = IOUtils.getInt8(data, 20);
        this.baseTimeNumerator = IOUtils.getInt8(data, 28);
        this.baseTimeDenominator = IOUtils.getInt8(data, 36);
        this.utc = data[44] == 0 && data[45] == 0 ? null : IOUtils.getUTF8(data, 44, 20);
        if (this.versionMajor == 4) {
            this.segmentLength = IOUtils.getInt8(data, 64);
            this.contentOffset = IOUtils.getInt8(data, 72);
        }
    }

    public OggPacket write() {
        int len = 64;
        if (this.versionMajor == 4) {
            len = 80;
        }
        byte[] data = new byte[len];
        IOUtils.putUTF8(data, 0, "fishead\u0000");
        IOUtils.putInt2(data, 8, this.versionMajor);
        IOUtils.putInt2(data, 10, this.versionMinor);
        IOUtils.putInt8(data, 12, this.presentationTimeNumerator);
        IOUtils.putInt8(data, 20, this.presentationTimeDenominator);
        IOUtils.putInt8(data, 28, this.baseTimeNumerator);
        IOUtils.putInt8(data, 36, this.baseTimeDenominator);
        if (this.utc != null) {
            IOUtils.putUTF8(data, 44, this.utc);
        }
        if (this.versionMajor == 4) {
            IOUtils.putInt8(data, 64, this.segmentLength);
            IOUtils.putInt8(data, 72, this.contentOffset);
        }
        this.setData(data);
        return super.write();
    }

    public int getVersionMajor() {
        return this.versionMajor;
    }

    public void setVersionMajor(int versionMajor) {
        this.versionMajor = versionMajor;
    }

    public int getVersionMinor() {
        return this.versionMinor;
    }

    public void setVersionMinor(int versionMinor) {
        this.versionMinor = versionMinor;
    }

    public String getVersion() {
        return this.versionMajor + "." + this.versionMinor;
    }

    public long getPresentationTimeNumerator() {
        return this.presentationTimeNumerator;
    }

    public void setPresentationTimeNumerator(long presentationTimeNumerator) {
        this.presentationTimeNumerator = presentationTimeNumerator;
    }

    public long getPresentationTimeDenominator() {
        return this.presentationTimeDenominator;
    }

    public void setPresentationTimeDenominator(long presentationTimeDenominator) {
        this.presentationTimeDenominator = presentationTimeDenominator;
    }

    public long getBaseTimeNumerator() {
        return this.baseTimeNumerator;
    }

    public void setBaseTimeNumerator(long baseTimeNumerator) {
        this.baseTimeNumerator = baseTimeNumerator;
    }

    public long getBaseTimeDenominator() {
        return this.baseTimeDenominator;
    }

    public void setBaseTimeDenominator(long baseTimeDenominator) {
        this.baseTimeDenominator = baseTimeDenominator;
    }

    public String getUtc() {
        return this.utc;
    }

    public void setUtc(String utc) {
        if (utc == null) {
            this.utc = null;
        } else if (utc.length() != 20) {
            throw new IllegalArgumentException("Must be of the form YYYYMMDDTHHMMSS.sssZ");
        }
    }

    public void setUtc(Date utcDate) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        this.utc = fmt.format(utcDate);
    }

    public long getSegmentLength() {
        return this.segmentLength;
    }

    public void setSegmentLength(long segmentLength) {
        this.segmentLength = segmentLength;
    }

    public long getContentOffset() {
        return this.contentOffset;
    }

    public void setContentOffset(long contentOffset) {
        this.contentOffset = contentOffset;
    }
}

