/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.secdispatcher.internal.sources;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.components.secdispatcher.MasterSourceMeta;
import org.codehaus.plexus.components.secdispatcher.SecDispatcher;
import org.codehaus.plexus.components.secdispatcher.SecDispatcherException;
import org.codehaus.plexus.components.secdispatcher.internal.sources.PrefixMasterSourceSupport;

@Singleton
@Named(value="file")
public final class FileMasterSource
extends PrefixMasterSourceSupport
implements MasterSourceMeta {
    public static final String NAME = "file";

    public FileMasterSource() {
        super("file:");
    }

    @Override
    public String description() {
        return "File (file name should be edited; use absolute path)";
    }

    @Override
    public Optional<String> configTemplate() {
        return Optional.of("file:$fileName");
    }

    @Override
    protected String doHandle(String transformed) throws SecDispatcherException {
        String value = this.readFile(transformed);
        if (value == null) {
            throw new SecDispatcherException("File '" + transformed + "' not found or is not readable");
        }
        return value;
    }

    @Override
    protected SecDispatcher.ValidationResponse doValidateConfiguration(String transformed) {
        String value = this.readFile(transformed);
        if (value == null) {
            return new SecDispatcher.ValidationResponse(this.getClass().getSimpleName(), true, Map.of(SecDispatcher.ValidationResponse.Level.WARNING, List.of("Configured file does not exist or is not readable")), List.of());
        }
        return new SecDispatcher.ValidationResponse(this.getClass().getSimpleName(), true, Map.of(SecDispatcher.ValidationResponse.Level.INFO, List.of("Configured file exist and is readable")), List.of());
    }

    private String readFile(String transformed) throws SecDispatcherException {
        Path file = Paths.get(transformed, new String[0]);
        if (file.isAbsolute() && Files.exists(file, new LinkOption[0])) {
            try {
                return Files.readAllLines(file).stream().filter(l -> !l.startsWith("#")).map(String::trim).findFirst().orElse(null);
            }
            catch (IOException e) {
                throw new SecDispatcherException("Failed to read file '" + transformed + "'", e);
            }
        }
        return null;
    }
}

