/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.maven.api.plugin.Log;
import org.slf4j.Logger;

public class DefaultLog
implements Log {
    private final Logger logger;

    public DefaultLog(Logger logger) {
        this.logger = Objects.requireNonNull(logger);
    }

    public void debug(CharSequence content) {
        if (this.isDebugEnabled()) {
            this.logger.debug(this.toString(content));
        }
    }

    public void debug(CharSequence content, Throwable error) {
        if (this.isDebugEnabled()) {
            this.logger.debug(this.toString(content), error);
        }
    }

    public void debug(Throwable error) {
        this.logger.debug("", error);
    }

    public void debug(Supplier<String> content) {
        if (this.isDebugEnabled()) {
            this.logger.debug(content.get());
        }
    }

    public void debug(Supplier<String> content, Throwable error) {
        if (this.isDebugEnabled()) {
            this.logger.debug(content.get(), error);
        }
    }

    public void info(CharSequence content) {
        if (this.isInfoEnabled()) {
            this.logger.info(this.toString(content));
        }
    }

    public void info(CharSequence content, Throwable error) {
        if (this.isInfoEnabled()) {
            this.logger.info(this.toString(content), error);
        }
    }

    public void info(Throwable error) {
        this.logger.info("", error);
    }

    public void info(Supplier<String> content) {
        if (this.isInfoEnabled()) {
            this.logger.info(content.get());
        }
    }

    public void info(Supplier<String> content, Throwable error) {
        if (this.isInfoEnabled()) {
            this.logger.info(content.get(), error);
        }
    }

    public void warn(CharSequence content) {
        if (this.isWarnEnabled()) {
            this.logger.warn(this.toString(content));
        }
    }

    public void warn(CharSequence content, Throwable error) {
        if (this.isWarnEnabled()) {
            this.logger.warn(this.toString(content), error);
        }
    }

    public void warn(Throwable error) {
        this.logger.warn("", error);
    }

    public void warn(Supplier<String> content) {
        if (this.isWarnEnabled()) {
            this.logger.warn(content.get());
        }
    }

    public void warn(Supplier<String> content, Throwable error) {
        if (this.isWarnEnabled()) {
            this.logger.info(content.get(), error);
        }
    }

    public void error(CharSequence content) {
        if (this.isErrorEnabled()) {
            this.logger.error(this.toString(content));
        }
    }

    public void error(CharSequence content, Throwable error) {
        if (this.isErrorEnabled()) {
            this.logger.error(this.toString(content), error);
        }
    }

    public void error(Throwable error) {
        this.logger.error("", error);
    }

    public void error(Supplier<String> content) {
        if (this.isErrorEnabled()) {
            this.logger.error(content.get());
        }
    }

    public void error(Supplier<String> content, Throwable error) {
        if (this.isErrorEnabled()) {
            this.logger.error(content.get(), error);
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    private String toString(CharSequence content) {
        return content != null ? content.toString() : "";
    }
}

