/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.DependencyScope;
import org.apache.maven.plugin.PluginValidationManager;
import org.apache.maven.plugin.internal.AbstractMavenPluginDependenciesValidator;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;

@Singleton
@Named
class Maven3CompatDependenciesValidator
extends AbstractMavenPluginDependenciesValidator {
    @Inject
    Maven3CompatDependenciesValidator(PluginValidationManager pluginValidationManager) {
        super(pluginValidationManager);
    }

    @Override
    protected void doValidate(RepositorySystemSession session, Artifact pluginArtifact, ArtifactDescriptorResult artifactDescriptorResult) {
        for (Dependency dependency : artifactDescriptorResult.getDependencies()) {
            if (!"org.apache.maven".equals(dependency.getArtifact().getGroupId()) || !"maven-compat".equals(dependency.getArtifact().getArtifactId()) || DependencyScope.TEST.is(dependency.getScope())) continue;
            this.pluginValidationManager.reportPluginValidationIssue(PluginValidationManager.IssueLocality.EXTERNAL, session, pluginArtifact, "Plugin depends on the deprecated Maven 2.x compatibility layer, which will be not supported in Maven 4.x");
        }
    }
}

