/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.metadata;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.metadata.ImmutableCollections;
import org.apache.maven.api.metadata.Plugin;
import org.apache.maven.api.metadata.Versioning;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Metadata
implements Serializable {
    final String namespaceUri;
    final String modelEncoding;
    final String modelVersion;
    final String groupId;
    final String artifactId;
    final Versioning versioning;
    final String version;
    final List<Plugin> plugins;

    protected Metadata(Builder builder) {
        String string = builder.namespaceUri != null ? builder.namespaceUri : (this.namespaceUri = builder.base != null ? builder.base.namespaceUri : null);
        String string2 = builder.modelEncoding != null ? builder.modelEncoding : (this.modelEncoding = builder.base != null ? builder.base.modelEncoding : "UTF-8");
        String string3 = builder.modelVersion != null ? builder.modelVersion : (this.modelVersion = builder.base != null ? builder.base.modelVersion : null);
        String string4 = builder.groupId != null ? builder.groupId : (this.groupId = builder.base != null ? builder.base.groupId : null);
        String string5 = builder.artifactId != null ? builder.artifactId : (this.artifactId = builder.base != null ? builder.base.artifactId : null);
        Versioning versioning = builder.versioning != null ? builder.versioning : (this.versioning = builder.base != null ? builder.base.versioning : null);
        String string6 = builder.version != null ? builder.version : (this.version = builder.base != null ? builder.base.version : null);
        this.plugins = ImmutableCollections.copy(builder.plugins != null ? builder.plugins : (builder.base != null ? builder.base.plugins : null));
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public Versioning getVersioning() {
        return this.versioning;
    }

    public String getVersion() {
        return this.version;
    }

    @Nonnull
    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    @Nonnull
    public Builder with() {
        return Metadata.newBuilder(this);
    }

    @Nonnull
    public Metadata withModelVersion(String modelVersion) {
        return Metadata.newBuilder(this, true).modelVersion(modelVersion).build();
    }

    @Nonnull
    public Metadata withGroupId(String groupId) {
        return Metadata.newBuilder(this, true).groupId(groupId).build();
    }

    @Nonnull
    public Metadata withArtifactId(String artifactId) {
        return Metadata.newBuilder(this, true).artifactId(artifactId).build();
    }

    @Nonnull
    public Metadata withVersioning(Versioning versioning) {
        return Metadata.newBuilder(this, true).versioning(versioning).build();
    }

    @Nonnull
    public Metadata withVersion(String version) {
        return Metadata.newBuilder(this, true).version(version).build();
    }

    @Nonnull
    public Metadata withPlugins(Collection<Plugin> plugins) {
        return Metadata.newBuilder(this, true).plugins(plugins).build();
    }

    @Nonnull
    public static Metadata newInstance() {
        return Metadata.newInstance(true);
    }

    @Nonnull
    public static Metadata newInstance(boolean withDefaults) {
        return Metadata.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Metadata.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Metadata from) {
        return Metadata.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Metadata from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        Metadata base;
        String namespaceUri;
        String modelEncoding;
        String modelVersion;
        String groupId;
        String artifactId;
        Versioning versioning;
        String version;
        Collection<Plugin> plugins;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(Metadata base, boolean forceCopy) {
            this.namespaceUri = base.namespaceUri;
            this.modelEncoding = base.modelEncoding;
            if (forceCopy) {
                this.modelVersion = base.modelVersion;
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.versioning = base.versioning;
                this.version = base.version;
                this.plugins = base.plugins;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder namespaceUri(String namespaceUri) {
            this.namespaceUri = namespaceUri;
            return this;
        }

        @Nonnull
        public Builder modelEncoding(String modelEncoding) {
            this.modelEncoding = modelEncoding;
            return this;
        }

        @Nonnull
        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder versioning(Versioning versioning) {
            this.versioning = versioning;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder plugins(Collection<Plugin> plugins) {
            this.plugins = plugins;
            return this;
        }

        @Nonnull
        public Metadata build() {
            if (!(this.base == null || this.modelVersion != null && this.modelVersion != this.base.modelVersion || this.groupId != null && this.groupId != this.base.groupId || this.artifactId != null && this.artifactId != this.base.artifactId || this.versioning != null && this.versioning != this.base.versioning || this.version != null && this.version != this.base.version || this.plugins != null && this.plugins != this.base.plugins)) {
                return this.base;
            }
            return new Metadata(this);
        }
    }
}

