/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.wagon;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamingWagon;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.GetTask;
import org.eclipse.aether.spi.connector.transport.PeekTask;
import org.eclipse.aether.spi.connector.transport.PutTask;
import org.eclipse.aether.spi.connector.transport.TransportTask;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transport.wagon.WagonCancelledException;
import org.eclipse.aether.transport.wagon.WagonConfigurator;
import org.eclipse.aether.transport.wagon.WagonProvider;
import org.eclipse.aether.transport.wagon.WagonTransferListener;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WagonTransporter
implements Transporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(WagonTransporter.class);
    private final RemoteRepository repository;
    private final RepositorySystemSession session;
    private final AuthenticationContext repoAuthContext;
    private final AuthenticationContext proxyAuthContext;
    private final WagonProvider wagonProvider;
    private final WagonConfigurator wagonConfigurator;
    private final String wagonHint;
    private final Repository wagonRepo;
    private final AuthenticationInfo wagonAuth;
    private final ProxyInfoProvider wagonProxy;
    private final Properties headers;
    private final Queue<Wagon> wagons = new ConcurrentLinkedQueue<Wagon>();
    private final AtomicBoolean closed = new AtomicBoolean();

    WagonTransporter(WagonProvider wagonProvider, WagonConfigurator wagonConfigurator, RemoteRepository repository, RepositorySystemSession session) throws NoTransporterException {
        this.wagonProvider = wagonProvider;
        this.wagonConfigurator = wagonConfigurator;
        this.repository = repository;
        this.session = session;
        this.wagonRepo = new Repository(repository.getId(), repository.getUrl());
        this.wagonRepo.setPermissions(WagonTransporter.getPermissions(repository.getId(), session));
        this.wagonHint = this.wagonRepo.getProtocol().toLowerCase(Locale.ENGLISH);
        if (this.wagonHint.isEmpty()) {
            throw new NoTransporterException(repository);
        }
        try {
            this.wagons.add(this.lookupWagon());
        }
        catch (Exception e) {
            LOGGER.debug("No transport", (Throwable)e);
            throw new NoTransporterException(repository, (Throwable)e);
        }
        this.repoAuthContext = AuthenticationContext.forRepository((RepositorySystemSession)session, (RemoteRepository)repository);
        this.proxyAuthContext = AuthenticationContext.forProxy((RepositorySystemSession)session, (RemoteRepository)repository);
        this.wagonAuth = this.getAuthenticationInfo(this.repoAuthContext);
        this.wagonProxy = this.getProxy(repository, this.proxyAuthContext);
        this.headers = new Properties();
        this.headers.put("User-Agent", ConfigUtils.getString((RepositorySystemSession)session, (String)"Aether", (String[])new String[]{"aether.transport.http.userAgent"}));
        Map headers = ConfigUtils.getMap((RepositorySystemSession)session, null, (String[])new String[]{"aether.transport.http.headers." + repository.getId(), "aether.transport.http.headers"});
        if (headers != null) {
            this.headers.putAll((Map<?, ?>)headers);
        }
    }

    private static RepositoryPermissions getPermissions(String repoId, RepositorySystemSession session) {
        String group;
        String dirMode;
        RepositoryPermissions result = null;
        RepositoryPermissions perms = new RepositoryPermissions();
        String suffix = '.' + repoId;
        String fileMode = ConfigUtils.getString((RepositorySystemSession)session, null, (String[])new String[]{"aether.transport.wagon.perms.fileMode" + suffix});
        if (fileMode != null) {
            perms.setFileMode(fileMode);
            result = perms;
        }
        if ((dirMode = ConfigUtils.getString((RepositorySystemSession)session, null, (String[])new String[]{"aether.transport.wagon.perms.dirMode" + suffix})) != null) {
            perms.setDirectoryMode(dirMode);
            result = perms;
        }
        if ((group = ConfigUtils.getString((RepositorySystemSession)session, null, (String[])new String[]{"aether.transport.wagon.perms.group" + suffix})) != null) {
            perms.setGroup(group);
            result = perms;
        }
        return result;
    }

    private AuthenticationInfo getAuthenticationInfo(final AuthenticationContext authContext) {
        AuthenticationInfo auth = null;
        if (authContext != null) {
            auth = new AuthenticationInfo(){

                public String getUserName() {
                    return authContext.get("username");
                }

                public String getPassword() {
                    return authContext.get("password");
                }

                public String getPrivateKey() {
                    return authContext.get("privateKey.path");
                }

                public String getPassphrase() {
                    return authContext.get("privateKey.passphrase");
                }
            };
        }
        return auth;
    }

    private ProxyInfoProvider getProxy(RemoteRepository repository, final AuthenticationContext authContext) {
        ProxyInfoProvider proxy = null;
        Proxy p = repository.getProxy();
        if (p != null) {
            ProxyInfo prox = authContext != null ? new ProxyInfo(){

                public String getUserName() {
                    return authContext.get("username");
                }

                public String getPassword() {
                    return authContext.get("password");
                }

                public String getNtlmDomain() {
                    return authContext.get("ntlm.domain");
                }

                public String getNtlmHost() {
                    return authContext.get("ntlm.workstation");
                }
            } : new ProxyInfo();
            prox.setType(p.getType());
            prox.setHost(p.getHost());
            prox.setPort(p.getPort());
            proxy = protocol -> prox;
        }
        return proxy;
    }

    private Wagon lookupWagon() throws Exception {
        return this.wagonProvider.lookup(this.wagonHint);
    }

    private void releaseWagon(Wagon wagon) {
        this.wagonProvider.release(wagon);
    }

    private void connectWagon(Wagon wagon) throws WagonException {
        if (!this.headers.isEmpty()) {
            try {
                Method setHttpHeaders = wagon.getClass().getMethod("setHttpHeaders", Properties.class);
                setHttpHeaders.invoke((Object)wagon, this.headers);
            }
            catch (NoSuchMethodException setHttpHeaders) {
            }
            catch (IllegalAccessException | RuntimeException | InvocationTargetException e) {
                LOGGER.debug("Could not set user agent for Wagon {}", (Object)wagon.getClass().getName(), (Object)e);
            }
        }
        int connectTimeout = ConfigUtils.getInteger((RepositorySystemSession)this.session, (int)30000, (String[])new String[]{"aether.transport.http.connectTimeout"});
        int requestTimeout = ConfigUtils.getInteger((RepositorySystemSession)this.session, (int)1800000, (String[])new String[]{"aether.transport.http.requestTimeout"});
        wagon.setTimeout(Math.max(Math.max(connectTimeout, requestTimeout), 0));
        wagon.setInteractive(ConfigUtils.getBoolean((RepositorySystemSession)this.session, (boolean)false, (String[])new String[]{"aether.interactive"}));
        Object configuration = ConfigUtils.getObject((RepositorySystemSession)this.session, null, (String[])new String[]{"aether.transport.wagon.config." + this.repository.getId()});
        if (configuration != null && this.wagonConfigurator != null) {
            try {
                this.wagonConfigurator.configure(wagon, configuration);
            }
            catch (Exception e) {
                LOGGER.warn("Could not apply configuration for {} to Wagon {}", new Object[]{this.repository.getId(), wagon.getClass().getName(), e});
            }
        }
        wagon.connect(this.wagonRepo, this.wagonAuth, this.wagonProxy);
    }

    private void disconnectWagon(Wagon wagon) {
        try {
            if (wagon != null) {
                wagon.disconnect();
            }
        }
        catch (ConnectionException e) {
            LOGGER.debug("Could not disconnect Wagon {}", (Object)wagon, (Object)e);
        }
    }

    private Wagon pollWagon() throws Exception {
        Wagon wagon = this.wagons.poll();
        if (wagon == null) {
            try {
                wagon = this.lookupWagon();
                this.connectWagon(wagon);
            }
            catch (Exception e) {
                this.releaseWagon(wagon);
                throw e;
            }
        }
        if (wagon.getRepository() == null) {
            try {
                this.connectWagon(wagon);
            }
            catch (Exception e) {
                this.wagons.add(wagon);
                throw e;
            }
        }
        return wagon;
    }

    public int classify(Throwable error) {
        if (error instanceof ResourceDoesNotExistException) {
            return 1;
        }
        return 0;
    }

    public void peek(PeekTask task) throws Exception {
        this.execute((TransportTask)task, new PeekTaskRunner(task));
    }

    public void get(GetTask task) throws Exception {
        this.execute((TransportTask)task, new GetTaskRunner(task));
    }

    public void put(PutTask task) throws Exception {
        this.execute((TransportTask)task, new PutTaskRunner(task));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(TransportTask task, TaskRunner runner) throws Exception {
        Objects.requireNonNull(task, "task cannot be null");
        if (this.closed.get()) {
            throw new IllegalStateException("transporter closed, cannot execute task " + task);
        }
        try {
            WagonTransferListener listener = new WagonTransferListener(task.getListener());
            Wagon wagon = this.pollWagon();
            try {
                wagon.addTransferListener((TransferListener)listener);
                runner.run(wagon);
            }
            finally {
                wagon.removeTransferListener((TransferListener)listener);
                this.wagons.add(wagon);
            }
        }
        catch (RuntimeException e) {
            throw WagonCancelledException.unwrap(e);
        }
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            AuthenticationContext.close((AuthenticationContext)this.repoAuthContext);
            AuthenticationContext.close((AuthenticationContext)this.proxyAuthContext);
            Wagon wagon = this.wagons.poll();
            while (wagon != null) {
                this.disconnectWagon(wagon);
                this.releaseWagon(wagon);
                wagon = this.wagons.poll();
            }
        }
    }

    private static class PeekTaskRunner
    implements TaskRunner {
        private final PeekTask task;

        PeekTaskRunner(PeekTask task) {
            this.task = task;
        }

        @Override
        public void run(Wagon wagon) throws WagonException {
            String src = this.task.getLocation().toString();
            if (!wagon.resourceExists(src)) {
                throw new ResourceDoesNotExistException("Could not find " + src + " in " + wagon.getRepository().getUrl());
            }
        }
    }

    private static interface TaskRunner {
        public void run(Wagon var1) throws IOException, WagonException;
    }

    private static class GetTaskRunner
    implements TaskRunner {
        private final GetTask task;

        GetTaskRunner(GetTask task) {
            this.task = task;
        }

        @Override
        public void run(Wagon wagon) throws IOException, WagonException {
            block21: {
                String src = this.task.getLocation().toString();
                File file = this.task.getDataFile();
                if (file == null && wagon instanceof StreamingWagon) {
                    try (OutputStream dst = this.task.newOutputStream();){
                        ((StreamingWagon)wagon).getToStream(src, dst);
                    }
                }
                try (FileUtils.TempFile tempFile = file == null ? FileUtils.newTempFile() : FileUtils.newTempFile((Path)file.toPath());){
                    File dst = tempFile.getPath().toFile();
                    wagon.get(src, dst);
                    if (!dst.exists() && !dst.createNewFile()) {
                        throw new IOException(String.format("Failure creating file '%s'.", dst.getAbsolutePath()));
                    }
                    if (file != null) {
                        ((FileUtils.CollocatedTempFile)tempFile).move();
                        break block21;
                    }
                    try (OutputStream outputStream = this.task.newOutputStream();){
                        Files.copy(dst.toPath(), outputStream);
                    }
                }
            }
        }
    }

    private static class PutTaskRunner
    implements TaskRunner {
        private final PutTask task;

        PutTaskRunner(PutTask task) {
            this.task = task;
        }

        @Override
        public void run(Wagon wagon) throws WagonException, IOException {
            String dst = this.task.getLocation().toString();
            File file = this.task.getDataFile();
            if (file == null && wagon instanceof StreamingWagon) {
                try (InputStream src = this.task.newInputStream();){
                    ((StreamingWagon)wagon).putFromStream(src, dst, this.task.getDataLength(), -1L);
                }
            }
            if (file == null) {
                try (FileUtils.TempFile tempFile = FileUtils.newTempFile();){
                    try (InputStream inputStream = this.task.newInputStream();){
                        Files.copy(inputStream, tempFile.getPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    wagon.put(tempFile.getPath().toFile(), dst);
                }
            }
            wagon.put(file, dst);
        }
    }
}

