/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.synccontext.named;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.named.NamedLock;
import org.eclipse.aether.named.NamedLockFactory;
import org.eclipse.aether.named.NamedLockKey;
import org.eclipse.aether.named.providers.FileLockNamedLockFactory;
import org.eclipse.aether.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NamedLockFactoryAdapter {
    public static final String CONFIG_PROPS_PREFIX = "aether.syncContext.named.";
    public static final String CONFIG_PROP_TIME = "aether.syncContext.named.time";
    public static final long DEFAULT_TIME = 30L;
    public static final String CONFIG_PROP_TIME_UNIT = "aether.syncContext.named.time.unit";
    public static final String DEFAULT_TIME_UNIT = "SECONDS";
    public static final String CONFIG_PROP_RETRY = "aether.syncContext.named.retry";
    public static final int DEFAULT_RETRY = 1;
    public static final String CONFIG_PROP_RETRY_WAIT = "aether.syncContext.named.retry.wait";
    public static final long DEFAULT_RETRY_WAIT = 200L;
    private final NameMapper nameMapper;
    private final NamedLockFactory namedLockFactory;

    public NamedLockFactoryAdapter(NameMapper nameMapper, NamedLockFactory namedLockFactory) {
        this.nameMapper = Objects.requireNonNull(nameMapper);
        this.namedLockFactory = Objects.requireNonNull(namedLockFactory);
        if (this.namedLockFactory instanceof FileLockNamedLockFactory && !this.nameMapper.isFileSystemFriendly()) {
            throw new IllegalArgumentException("Misconfiguration: FileLockNamedLockFactory lock factory requires FS friendly NameMapper");
        }
    }

    public SyncContext newInstance(RepositorySystemSession session, boolean shared) {
        return new AdaptedLockSyncContext(session, shared, this.nameMapper, this.namedLockFactory);
    }

    public NameMapper getNameMapper() {
        return this.nameMapper;
    }

    public NamedLockFactory getNamedLockFactory() {
        return this.namedLockFactory;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(nameMapper=" + this.nameMapper + ", namedLockFactory=" + this.namedLockFactory + ")";
    }

    private static class AdaptedLockSyncContext
    implements SyncContext {
        private static final Logger LOGGER = LoggerFactory.getLogger(AdaptedLockSyncContext.class);
        private final RepositorySystemSession session;
        private final boolean shared;
        private final NameMapper lockNaming;
        private final NamedLockFactory namedLockFactory;
        private final long time;
        private final TimeUnit timeUnit;
        private final int retry;
        private final long retryWait;
        private final Deque<NamedLock> locks;

        private AdaptedLockSyncContext(RepositorySystemSession session, boolean shared, NameMapper lockNaming, NamedLockFactory namedLockFactory) {
            this.session = session;
            this.shared = shared;
            this.lockNaming = lockNaming;
            this.namedLockFactory = namedLockFactory;
            this.time = this.getTime(session);
            this.timeUnit = this.getTimeUnit(session);
            this.retry = this.getRetry(session);
            this.retryWait = this.getRetryWait(session);
            this.locks = new ArrayDeque<NamedLock>();
            if (this.time < 0L) {
                throw new IllegalArgumentException("aether.syncContext.named.time value cannot be negative");
            }
            if ((long)this.retry < 0L) {
                throw new IllegalArgumentException("aether.syncContext.named.retry value cannot be negative");
            }
            if (this.retryWait < 0L) {
                throw new IllegalArgumentException("aether.syncContext.named.retry.wait value cannot be negative");
            }
        }

        private long getTime(RepositorySystemSession session) {
            return ConfigUtils.getLong((RepositorySystemSession)session, (long)30L, (String[])new String[]{NamedLockFactoryAdapter.CONFIG_PROP_TIME});
        }

        private TimeUnit getTimeUnit(RepositorySystemSession session) {
            return TimeUnit.valueOf(ConfigUtils.getString((RepositorySystemSession)session, (String)NamedLockFactoryAdapter.DEFAULT_TIME_UNIT, (String[])new String[]{NamedLockFactoryAdapter.CONFIG_PROP_TIME_UNIT}));
        }

        private int getRetry(RepositorySystemSession session) {
            return ConfigUtils.getInteger((RepositorySystemSession)session, (int)1, (String[])new String[]{NamedLockFactoryAdapter.CONFIG_PROP_RETRY});
        }

        private long getRetryWait(RepositorySystemSession session) {
            return ConfigUtils.getLong((RepositorySystemSession)session, (long)200L, (String[])new String[]{NamedLockFactoryAdapter.CONFIG_PROP_RETRY_WAIT});
        }

        public void acquire(Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
            Collection<NamedLockKey> keys = this.lockNaming.nameLocks(this.session, artifacts, metadatas);
            if (keys.isEmpty()) {
                return;
            }
            String timeStr = this.time + " " + (Object)((Object)this.timeUnit);
            String lockKind = this.shared ? "shared" : "exclusive";
            NamedLock namedLock = this.namedLockFactory.getLock(keys);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Need {} lock for {} from {}", new Object[]{lockKind, namedLock.key().resources(), namedLock.key().name()});
            }
            int attempts = this.retry + 1;
            for (int attempt = 1; attempt <= attempts; ++attempt) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Attempt {}: Acquire {} lock from {}", new Object[]{attempt, lockKind, namedLock.key().name()});
                }
                try {
                    boolean locked;
                    if (attempt > 1) {
                        Thread.sleep(this.retryWait);
                    }
                    if (locked = this.shared ? namedLock.lockShared(this.time, this.timeUnit) : namedLock.lockExclusively(this.time, this.timeUnit)) {
                        this.locks.push(namedLock);
                        return;
                    }
                    if (!LOGGER.isTraceEnabled()) continue;
                    LOGGER.trace("Failed to acquire {} lock for '{}' in {}", new Object[]{lockKind, namedLock.key().name(), timeStr});
                    continue;
                }
                catch (InterruptedException e) {
                    this.close();
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }
            this.close();
            IllegalStateException ex = new IllegalStateException("Could not acquire " + lockKind + " lock for " + namedLock.key().resources() + " using lock " + namedLock.key().name() + " in " + timeStr);
            throw (IllegalStateException)this.namedLockFactory.onFailure((Throwable)ex);
        }

        public void close() {
            while (!this.locks.isEmpty()) {
                NamedLock namedLock = this.locks.pop();
                try {
                    namedLock.unlock();
                    if (!LOGGER.isTraceEnabled()) continue;
                    LOGGER.trace("Unlocked and closed {} lock of {}", (Object)(this.shared ? "shared" : "exclusive"), (Object)namedLock.key());
                }
                finally {
                    if (namedLock == null) continue;
                    namedLock.close();
                }
            }
        }
    }
}

