/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;

public class MonotonicClock
extends Clock {
    private static final MonotonicClock CLOCK = new MonotonicClock();
    private final long startNanos = System.nanoTime();
    private final Instant startInstant = Clock.systemUTC().instant();

    private MonotonicClock() {
    }

    public static MonotonicClock get() {
        return CLOCK;
    }

    public static Instant now() {
        return MonotonicClock.get().instant();
    }

    public static Instant start() {
        return MonotonicClock.get().startInstant();
    }

    public static Duration elapsed() {
        return MonotonicClock.get().elapsedTime();
    }

    @Override
    public Instant instant() {
        long elapsedNanos = System.nanoTime() - this.startNanos;
        return this.startInstant.plusNanos(elapsedNanos);
    }

    public Instant startInstant() {
        return this.startInstant;
    }

    public Duration elapsedTime() {
        long elapsedNanos = System.nanoTime() - this.startNanos;
        return Duration.ofNanos(elapsedNanos);
    }

    @Override
    public ZoneId getZone() {
        return ZoneOffset.UTC;
    }

    @Override
    public Clock withZone(ZoneId zone) {
        return this;
    }
}

