/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import org.apache.maven.api.annotations.Nonnull;

public interface MessageBuilder
extends Appendable {
    @Nonnull
    default public MessageBuilder trace(Object message) {
        return this.style(".trace:-bold,f:magenta", message);
    }

    @Nonnull
    default public MessageBuilder debug(Object message) {
        return this.style(".debug:-bold,f:cyan", message);
    }

    @Nonnull
    default public MessageBuilder info(Object message) {
        return this.style(".info:-bold,f:blue", message);
    }

    @Nonnull
    default public MessageBuilder warning(Object message) {
        return this.style(".warning:-bold,f:yellow", message);
    }

    @Nonnull
    default public MessageBuilder error(Object message) {
        return this.style(".error:-bold,f:red", message);
    }

    @Nonnull
    default public MessageBuilder success(Object message) {
        return this.style(".success:-bold,f:green", message);
    }

    @Nonnull
    default public MessageBuilder failure(Object message) {
        return this.style(".failure:-bold,f:red", message);
    }

    @Nonnull
    default public MessageBuilder strong(Object message) {
        return this.style(".strong:-bold", message);
    }

    @Nonnull
    default public MessageBuilder mojo(Object message) {
        return this.style(".mojo:-f:green", message);
    }

    @Nonnull
    default public MessageBuilder project(Object message) {
        return this.style(".project:-f:cyan", message);
    }

    @Nonnull
    default public MessageBuilder style(String style, Object message) {
        return this.style(style).a(message).resetStyle();
    }

    public MessageBuilder style(String var1);

    public MessageBuilder resetStyle();

    @Override
    @Nonnull
    public MessageBuilder append(CharSequence var1);

    @Override
    @Nonnull
    public MessageBuilder append(CharSequence var1, int var2, int var3);

    @Override
    @Nonnull
    public MessageBuilder append(char var1);

    @Nonnull
    default public MessageBuilder a(char[] value, int offset, int len) {
        return this.append(String.valueOf(value, offset, len));
    }

    @Nonnull
    default public MessageBuilder a(char[] value) {
        return this.append(String.valueOf(value));
    }

    @Nonnull
    default public MessageBuilder a(CharSequence value, int start, int end) {
        return this.append(value, start, end);
    }

    @Nonnull
    default public MessageBuilder a(CharSequence value) {
        return this.append(value);
    }

    @Nonnull
    default public MessageBuilder a(Object value) {
        return this.append(String.valueOf(value));
    }

    @Nonnull
    default public MessageBuilder newline() {
        return this.append(System.lineSeparator());
    }

    @Nonnull
    default public MessageBuilder format(String pattern, Object ... args) {
        return this.append(String.format(pattern, args));
    }

    public MessageBuilder setLength(int var1);

    @Nonnull
    public String build();
}

