/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.cache;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.maven.api.ProtoSession;
import org.apache.maven.api.Session;
import org.apache.maven.api.SessionData;
import org.apache.maven.api.cache.CacheMetadata;
import org.apache.maven.api.cache.CacheRetention;
import org.apache.maven.api.services.Request;
import org.apache.maven.api.services.RequestTrace;
import org.apache.maven.api.services.Result;
import org.apache.maven.impl.cache.AbstractRequestCache;
import org.apache.maven.impl.cache.CachingSupplier;
import org.apache.maven.impl.cache.SoftIdentityMap;

public class DefaultRequestCache
extends AbstractRequestCache {
    protected static final SessionData.Key<ConcurrentMap> KEY = SessionData.key(ConcurrentMap.class, CacheMetadata.class);
    protected static final Object ROOT = new Object();
    protected final Map<Object, CachingSupplier<?, ?>> forever = new ConcurrentHashMap();

    @Override
    protected <REQ extends Request<?>, REP extends Result<REQ>> CachingSupplier<REQ, REP> doCache(REQ req, Function<REQ, REP> supplier) {
        ProtoSession protoSession;
        CacheRetention cacheRetention;
        if (req instanceof CacheMetadata) {
            CacheMetadata metadata = (CacheMetadata)req;
            cacheRetention = metadata.getCacheRetention();
        } else {
            cacheRetention = null;
        }
        CacheRetention retention = Objects.requireNonNullElse(cacheRetention, CacheRetention.SESSION_SCOPED);
        Map cache = null;
        if ((retention == CacheRetention.REQUEST_SCOPED || retention == CacheRetention.SESSION_SCOPED) && (protoSession = req.getSession()) instanceof Session) {
            Session session = (Session)protoSession;
            Object key = retention == CacheRetention.REQUEST_SCOPED ? this.doGetOuterRequest(req) : ROOT;
            Map caches = (Map)session.getData().computeIfAbsent(KEY, ConcurrentHashMap::new);
            cache = caches.computeIfAbsent(key, k -> new SoftIdentityMap());
        } else if (retention == CacheRetention.PERSISTENT) {
            cache = this.forever;
        }
        if (cache != null) {
            return cache.computeIfAbsent(req, r -> new CachingSupplier(supplier));
        }
        return new CachingSupplier<REQ, REP>(supplier);
    }

    private <REQ extends Request<?>> Object doGetOuterRequest(REQ req) {
        RequestTrace trace;
        for (trace = req.getTrace(); trace != null && trace.parent() != null; trace = trace.parent()) {
        }
        return trace != null && trace.data() != null ? trace.data() : req;
    }
}

