/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.logging.slf4j;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import org.apache.maven.slf4j.MavenBaseLogger;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.helpers.MessageFormatter;

public class MvndDaemonLogger
extends MavenBaseLogger {
    final DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss.SSS").toFormatter();

    public MvndDaemonLogger(String name) {
        super(name);
    }

    protected String renderLevel(int levelInt) {
        switch (levelInt) {
            case 40: {
                return "E";
            }
            case 30: {
                return "W";
            }
            case 20: {
                return "I";
            }
            case 10: {
                return "D";
            }
            case 0: {
                return "T";
            }
        }
        throw new IllegalStateException("Unrecognized level [" + levelInt + "]");
    }

    protected void handleNormalizedLoggingCall(Level level, Marker marker, String messagePattern, Object[] arguments, Throwable throwable) {
        StringBuilder buf = new StringBuilder(32);
        buf.append(this.dateTimeFormatter.format(LocalTime.now()));
        buf.append(" ");
        buf.append(this.renderLevel(level.toInt()));
        buf.append(" ");
        String message = MessageFormatter.basicArrayFormat((String)messagePattern, (Object[])arguments);
        buf.append(message);
        this.write(buf, throwable);
    }
}

