/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.error.ShouldBeFalse;
import org.assertj.core.error.ShouldBeTrue;
import org.assertj.core.internal.Booleans;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractBooleanAssert<SELF extends AbstractBooleanAssert<SELF>>
extends AbstractAssert<SELF, Boolean> {
    @VisibleForTesting
    Booleans booleans = Booleans.instance();

    protected AbstractBooleanAssert(Boolean actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isTrue() {
        this.objects.assertNotNull(this.info, this.actual);
        if (((Boolean)this.actual).booleanValue()) {
            return (SELF)((AbstractBooleanAssert)this.myself);
        }
        throw Failures.instance().failure(this.info, ShouldBeTrue.shouldBeTrue((Boolean)this.actual), this.actual, true);
    }

    public SELF isFalse() {
        this.objects.assertNotNull(this.info, this.actual);
        if (!((Boolean)this.actual).booleanValue()) {
            return (SELF)((AbstractBooleanAssert)this.myself);
        }
        throw Failures.instance().failure(this.info, ShouldBeFalse.shouldBeFalse((Boolean)this.actual), this.actual, false);
    }

    public SELF isEqualTo(boolean expected) {
        this.booleans.assertEqual(this.info, (Boolean)this.actual, expected);
        return (SELF)((AbstractBooleanAssert)this.myself);
    }

    public SELF isNotEqualTo(boolean other) {
        this.booleans.assertNotEqual(this.info, (Boolean)this.actual, other);
        return (SELF)((AbstractBooleanAssert)this.myself);
    }

    @Override
    @Deprecated
    public final SELF usingComparator(Comparator<? super Boolean> customComparator) {
        return (SELF)this.usingComparator((Comparator)customComparator, (String)null);
    }

    @Override
    @Deprecated
    public final SELF usingComparator(Comparator<? super Boolean> customComparator, String customComparatorDescription) {
        throw new UnsupportedOperationException("custom Comparator is not supported for Boolean comparison");
    }
}

