/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileBuiltQuery;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.queries.FileBuiltQueryImplementation;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;

final class FileBuiltQueryImpl
implements FileBuiltQueryImplementation,
PropertyChangeListener {
    private FileBuiltQueryImplementation delegate;
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testRoots;
    private File buildGeneratedDir = null;
    private final FileChangeListener buildGeneratedDirListener = new FileChangeAdapter(){

        @Override
        public void fileFolderCreated(FileEvent fe) {
            FileBuiltQueryImpl.this.invalidate();
        }

        @Override
        public void fileDeleted(FileEvent fe) {
            FileBuiltQueryImpl.this.invalidate();
        }

        @Override
        public void fileRenamed(FileRenameEvent fe) {
            FileBuiltQueryImpl.this.invalidate();
        }
    };

    FileBuiltQueryImpl(AntProjectHelper helper, PropertyEvaluator evaluator, SourceRoots sourceRoots, SourceRoots testRoots) {
        assert (helper != null);
        assert (evaluator != null);
        assert (sourceRoots != null);
        assert (testRoots != null);
        this.helper = helper;
        this.evaluator = evaluator;
        this.sourceRoots = sourceRoots;
        this.testRoots = testRoots;
        this.sourceRoots.addPropertyChangeListener(this);
        this.testRoots.addPropertyChangeListener(this);
    }

    @Override
    public FileBuiltQuery.Status getStatus(final FileObject file) {
        return ProjectManager.mutex().readAccess(new Mutex.Action<FileBuiltQuery.Status>(){

            @Override
            public FileBuiltQuery.Status run() {
                return FileBuiltQueryImpl.this.getStatusImpl(file);
            }
        });
    }

    private synchronized FileBuiltQuery.Status getStatusImpl(FileObject file) {
        if (this.delegate == null) {
            this.delegate = this.createDelegate();
        }
        return this.delegate.getStatus(file);
    }

    private FileBuiltQueryImplementation createDelegate() {
        ArrayList<String> from = new ArrayList<String>();
        ArrayList<String> to = new ArrayList<String>();
        for (String r : this.sourceRoots.getRootProperties()) {
            from.add("${" + r + "}/*.java");
            to.add("${build.classes.dir}/*.class");
        }
        for (String r : this.testRoots.getRootProperties()) {
            from.add("${" + r + "}/*.java");
            to.add("${build.test.classes.dir}/*.class");
        }
        String buildGeneratedDirS = this.evaluator.getProperty("build.generated.sources.dir");
        if (buildGeneratedDirS != null) {
            File _buildGeneratedDir = this.helper.resolveFile(buildGeneratedDirS);
            if (!_buildGeneratedDir.equals(this.buildGeneratedDir)) {
                if (this.buildGeneratedDir != null) {
                    FileUtil.removeFileChangeListener(this.buildGeneratedDirListener, this.buildGeneratedDir);
                }
                this.buildGeneratedDir = _buildGeneratedDir;
                FileUtil.addFileChangeListener(this.buildGeneratedDirListener, this.buildGeneratedDir);
            }
            if (this.buildGeneratedDir.isDirectory()) {
                for (File root : this.buildGeneratedDir.listFiles()) {
                    if (!root.isDirectory()) continue;
                    from.add(root + "/*.java");
                    to.add("${build.classes.dir}/*.class");
                }
            }
        }
        return this.helper.createGlobFileBuiltQuery(this.evaluator, from.toArray(new String[from.size()]), to.toArray(new String[to.size()]));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (SourceRoots.PROP_ROOT_PROPERTIES.equals(evt.getPropertyName())) {
            this.invalidate();
        }
    }

    private synchronized void invalidate() {
        this.delegate = null;
    }
}

