/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.Plannable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.ObjStack;
import io.questdb.std.Sinkable;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;

public abstract class BasePlanSink
implements PlanSink {
    protected final ObjStack<RecordCursorFactory> factoryStack;
    protected final HtmlEscapingStringSink htmlSink = new HtmlEscapingStringSink();
    protected final EscapingStringSink textSink;
    protected int depth = 0;
    protected SqlExecutionContext executionContext;
    protected int order = -1;
    protected EscapingStringSink sink = this.textSink = new EscapingStringSink();
    protected boolean useBaseMetadata;

    public BasePlanSink() {
        this.factoryStack = new ObjStack();
    }

    @Override
    public PlanSink child(Plannable p, int order) {
        this.order = order;
        this.child(p);
        this.order = -1;
        return this;
    }

    @Override
    public void clear() {
        this.sink.clear();
        this.depth = 0;
        this.factoryStack.clear();
        this.executionContext = null;
        this.order = -1;
    }

    @Override
    public SqlExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public StringSink getSink() {
        return this.sink;
    }

    @Override
    public PlanSink optAttr(CharSequence name, Sinkable value) {
        if (value != null) {
            this.attr(name).val(value);
        }
        return this;
    }

    @Override
    public PlanSink optAttr(CharSequence name, Plannable value) {
        if (value != null) {
            if (value instanceof ConstantFunction && ((ConstantFunction)value).isNullConstant()) {
                return this;
            }
            this.attr(name).val(value);
        }
        return this;
    }

    @Override
    public PlanSink optAttr(CharSequence name, ObjList<? extends Plannable> value) {
        if (value != null && value.size() > 0) {
            this.attr(name).val(value);
        }
        return this;
    }

    @Override
    public PlanSink optAttr(CharSequence name, ObjList<? extends Plannable> value, boolean useBaseMetadata) {
        this.useBaseMetadata = useBaseMetadata;
        this.optAttr(name, value);
        this.useBaseMetadata = false;
        return this;
    }

    @Override
    public PlanSink putBaseColumnName(int columnIdx) {
        return this.val(this.factoryStack.peek().getBaseColumnName(columnIdx));
    }

    @Override
    public PlanSink putBaseColumnNameNoRemap(int columnIdx) {
        return this.val(this.factoryStack.peek().getBaseColumnNameNoRemap(columnIdx));
    }

    @Override
    public PlanSink putColumnName(int columnIdx) {
        if (this.useBaseMetadata) {
            this.putBaseColumnName(columnIdx);
        } else {
            this.val(this.factoryStack.peek().getMetadata().getColumnName(columnIdx));
        }
        return this;
    }

    @Override
    public PlanSink val(ObjList<?> list) {
        return this.val(list, 0, list.size());
    }

    @Override
    public PlanSink val(ObjList<?> list, int from) {
        return this.val(list, from, list.size());
    }

    @Override
    public PlanSink val(ObjList<?> list, int from, int to) {
        this.sink.put('[');
        for (int i = from; i < to; ++i) {
            Object obj;
            if (i > from) {
                this.sink.put(',');
            }
            if ((obj = list.getQuick(i)) instanceof Plannable) {
                ((Plannable)obj).toPlan(this);
                continue;
            }
            if (obj instanceof Sinkable) {
                this.sink.put((Sinkable)obj);
                continue;
            }
            if (obj == null) {
                this.sink.put("null");
                continue;
            }
            this.sink.put(obj.toString());
        }
        this.sink.put(']');
        return this;
    }

    static class HtmlEscapingStringSink
    extends EscapingStringSink {
        HtmlEscapingStringSink() {
        }

        @Override
        protected void escape(char c) {
            if (c == '<') {
                super.put("&lt;");
            } else if (c == '>') {
                super.put("&gt;");
            } else {
                super.escape(c);
            }
        }
    }

    static class EscapingStringSink
    extends StringSink {
        EscapingStringSink() {
        }

        @Override
        public CharSink put(CharSequence cs) {
            return this.put(cs, 0, cs.length());
        }

        @Override
        public CharSink put(CharSequence cs, int lo, int hi) {
            for (int i = lo; i < hi; ++i) {
                this.escape(cs.charAt(i));
            }
            return this;
        }

        @Override
        public CharSink put(char c) {
            this.escape(c);
            return this;
        }

        @Override
        public CharSink put(char[] chars, int start, int len) {
            for (int i = start; i < start + len; ++i) {
                this.escape(chars[i]);
            }
            return this;
        }

        public CharSink putNoEsc(CharSequence cs) {
            super.put(cs);
            return this;
        }

        protected void escape(char c) {
            if (c < ' ') {
                switch (c) {
                    case '\b': {
                        super.put("\\b");
                        break;
                    }
                    case '\f': {
                        super.put("\\f");
                        break;
                    }
                    case '\n': {
                        super.put("\\n");
                        break;
                    }
                    case '\r': {
                        super.put("\\r");
                        break;
                    }
                    case '\t': {
                        super.put("\\t");
                        break;
                    }
                    default: {
                        super.put("\\u00");
                        super.put(c >> 4);
                        super.put(Numbers.hexDigits[c & 0xF]);
                        break;
                    }
                }
            } else {
                super.put(c);
            }
        }
    }
}

