/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.DelegatingRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.Chars;
import io.questdb.std.Misc;

public class RecordAsAFieldRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory base;
    private final RecordAsAFieldRecordCursor cursor;

    public RecordAsAFieldRecordCursorFactory(RecordCursorFactory base, CharSequence columnAlias) {
        super(new GenericRecordMetadata());
        this.base = base;
        this.cursor = new RecordAsAFieldRecordCursor();
        GenericRecordMetadata metadata = (GenericRecordMetadata)this.getMetadata();
        metadata.add(new TableColumnMetadata(Chars.toString(columnAlias), 22, base.getMetadata()));
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor cursor1 = this.base.getCursor(executionContext);
        try {
            this.cursor.of(cursor1, executionContext);
            return this.cursor;
        }
        catch (Throwable th) {
            cursor1.close();
            throw th;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.base.recordCursorSupportsRandomAccess();
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("RecordAsAField");
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    protected void _close() {
        Misc.free(this.base);
    }

    private static final class RecordAsAFieldRecordCursor
    implements DelegatingRecordCursor {
        private final RecordAsAFieldRecord record = new RecordAsAFieldRecord();
        private final RecordAsAFieldRecord recordB = new RecordAsAFieldRecord();
        private RecordCursor base;

        private RecordAsAFieldRecordCursor() {
        }

        @Override
        public void close() {
            Misc.free(this.base);
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public Record getRecordB() {
            return this.recordB;
        }

        @Override
        public boolean hasNext() {
            return this.base.hasNext();
        }

        @Override
        public void of(RecordCursor base, SqlExecutionContext executionContext) {
            this.base = base;
            this.record.base = base.getRecord();
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            this.base.recordAt(((RecordAsAFieldRecord)record).base, atRowId);
        }

        @Override
        public long size() {
            return this.base.size();
        }

        @Override
        public void toTop() {
            this.base.toTop();
        }
    }

    private static final class RecordAsAFieldRecord
    implements Record {
        private Record base;

        private RecordAsAFieldRecord() {
        }

        @Override
        public Record getRecord(int col) {
            assert (col == 0);
            return this.base;
        }
    }
}

