/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.groups;

import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.flow.ScheduledState;
import org.apache.nifi.groups.ComponentScheduler;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.registry.flow.mapping.VersionedComponentStateLookup;
import org.apache.nifi.remote.RemoteGroupPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComponentScheduler
implements ComponentScheduler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractComponentScheduler.class);
    private final ControllerServiceProvider serviceProvider;
    private final VersionedComponentStateLookup stateLookup;
    private final AtomicLong pauseCount = new AtomicLong(0L);
    private final Queue<Connectable> connectablesToStart = new LinkedBlockingQueue<Connectable>();
    private final Queue<ReportingTaskNode> reportingTasksToStart = new LinkedBlockingQueue<ReportingTaskNode>();
    private final Queue<ControllerServiceNode> toEnable = new LinkedBlockingQueue<ControllerServiceNode>();

    public AbstractComponentScheduler(ControllerServiceProvider controllerServiceProvider, VersionedComponentStateLookup stateLookup) {
        this.serviceProvider = controllerServiceProvider;
        this.stateLookup = stateLookup;
    }

    @Override
    public void pause() {
        long count = this.pauseCount.incrementAndGet();
        logger.debug("{} paused; count = {}", (Object)this, (Object)count);
    }

    @Override
    public void resume() {
        ReportingTaskNode taskNode;
        Connectable connectable;
        long updatedCount = this.pauseCount.decrementAndGet();
        logger.debug("{} resumed; count = {}", (Object)this, (Object)updatedCount);
        if (updatedCount > 0L) {
            return;
        }
        logger.debug("{} enabling {}", (Object)this, this.toEnable);
        this.enableNow(this.toEnable);
        while ((connectable = this.connectablesToStart.poll()) != null) {
            logger.debug("{} starting {}", (Object)this, (Object)connectable);
            this.startNow(connectable);
        }
        while ((taskNode = this.reportingTasksToStart.poll()) != null) {
            logger.debug("{} starting {}", (Object)this, (Object)taskNode);
            this.startNow(taskNode);
        }
    }

    private boolean isPaused() {
        return this.pauseCount.get() > 0L;
    }

    @Override
    public void transitionComponentState(Connectable component, ScheduledState desiredState) {
        ScheduledState scheduledState = this.getScheduledState(component);
        ScheduledState finalState = desiredState == null ? ScheduledState.ENABLED : desiredState;
        switch (finalState) {
            case DISABLED: {
                if (scheduledState == ScheduledState.RUNNING) {
                    logger.debug("Stopping {}", (Object)component);
                    this.stopComponent(component);
                }
                logger.debug("Disabling {}", (Object)component);
                this.disable(component);
                break;
            }
            case ENABLED: {
                if (scheduledState == ScheduledState.DISABLED) {
                    logger.debug("Enabling {}", (Object)component);
                    this.enable(component);
                    break;
                }
                if (scheduledState != ScheduledState.RUNNING) break;
                logger.debug("Stopping {}", (Object)component);
                this.stopComponent(component);
                break;
            }
            case RUNNING: {
                if (scheduledState == ScheduledState.DISABLED) {
                    logger.debug("Enabling {}", (Object)component);
                    this.enable(component);
                }
                logger.debug("Starting {}", (Object)component);
                this.startComponent(component);
            }
        }
    }

    private ScheduledState getScheduledState(Connectable component) {
        switch (component.getConnectableType()) {
            case INPUT_PORT: 
            case OUTPUT_PORT: 
            case REMOTE_INPUT_PORT: 
            case REMOTE_OUTPUT_PORT: {
                return this.stateLookup.getState((Port)component);
            }
            case PROCESSOR: {
                return this.stateLookup.getState((ProcessorNode)component);
            }
            case FUNNEL: {
                return ScheduledState.RUNNING;
            }
        }
        switch (component.getScheduledState()) {
            case DISABLED: {
                return ScheduledState.DISABLED;
            }
            case RUN_ONCE: 
            case STOPPED: 
            case STOPPING: {
                return ScheduledState.ENABLED;
            }
        }
        return ScheduledState.RUNNING;
    }

    private void enable(Connectable component) {
        ProcessGroup group = component.getProcessGroup();
        switch (component.getConnectableType()) {
            case INPUT_PORT: {
                group.enableInputPort((Port)component);
                break;
            }
            case OUTPUT_PORT: {
                group.enableOutputPort((Port)component);
                break;
            }
            case PROCESSOR: {
                group.enableProcessor((ProcessorNode)component);
            }
        }
    }

    private void disable(Connectable component) {
        ProcessGroup group = component.getProcessGroup();
        switch (component.getConnectableType()) {
            case INPUT_PORT: {
                group.disableInputPort((Port)component);
                break;
            }
            case OUTPUT_PORT: {
                group.disableOutputPort((Port)component);
                break;
            }
            case PROCESSOR: {
                group.disableProcessor((ProcessorNode)component);
            }
        }
    }

    @Override
    public void startComponent(Connectable component) {
        if (this.isPaused()) {
            logger.debug("{} called to start {} but paused so will queue it for start later", (Object)this, (Object)component);
            this.connectablesToStart.offer(component);
        } else {
            logger.debug("{} starting {} now", (Object)this, (Object)component);
            this.startNow(component);
        }
    }

    @Override
    public void stopComponent(Connectable component) {
        ProcessGroup processGroup = component.getProcessGroup();
        switch (component.getConnectableType()) {
            case INPUT_PORT: {
                processGroup.stopInputPort((Port)component);
                break;
            }
            case OUTPUT_PORT: {
                processGroup.stopOutputPort((Port)component);
                break;
            }
            case PROCESSOR: {
                processGroup.stopProcessor((ProcessorNode)component);
                break;
            }
            case REMOTE_INPUT_PORT: 
            case REMOTE_OUTPUT_PORT: {
                RemoteGroupPort port = (RemoteGroupPort)component;
                port.getRemoteProcessGroup().stopTransmitting(port);
            }
        }
    }

    @Override
    public void enableControllerServicesAsync(Collection<ControllerServiceNode> controllerServices) {
        if (this.isPaused()) {
            logger.debug("{} called to enable {} but paused so will queue them for start later", (Object)this, controllerServices);
            this.toEnable.addAll(controllerServices);
        } else {
            logger.debug("{} enabling {} now", (Object)this, controllerServices);
            this.enableNow(controllerServices);
        }
    }

    @Override
    public void disableControllerServicesAsync(Collection<ControllerServiceNode> controllerServices) {
        this.serviceProvider.disableControllerServicesAsync(controllerServices);
    }

    protected ControllerServiceProvider getControllerServiceProvider() {
        return this.serviceProvider;
    }

    @Override
    public void startReportingTask(ReportingTaskNode reportingTask) {
        if (this.isPaused()) {
            logger.debug("{} called to start {} but paused so will queue it for start later", (Object)this, (Object)reportingTask);
            this.reportingTasksToStart.offer(reportingTask);
        } else {
            logger.debug("{} starting {} now", (Object)this, (Object)reportingTask);
            this.startNow(reportingTask);
        }
    }

    protected abstract void startNow(Connectable var1);

    protected abstract void enableNow(Collection<ControllerServiceNode> var1);

    protected abstract void startNow(ReportingTaskNode var1);
}

