/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.extension;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.registry.client.BundleVersionClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryClientConfig;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.client.RequestConfig;
import org.apache.nifi.registry.client.impl.JerseyNiFiRegistryClient;
import org.apache.nifi.registry.client.impl.request.ProxiedEntityRequestConfig;
import org.apache.nifi.registry.extension.AbstractExtensionRegistry;
import org.apache.nifi.registry.extension.ExtensionRegistryException;
import org.apache.nifi.registry.extension.NiFiRegistryExtensionBundleMetadata;
import org.apache.nifi.registry.extension.bundle.BundleVersionFilterParams;
import org.apache.nifi.registry.extension.bundle.BundleVersionMetadata;

public class NiFiRegistryExtensionRegistry
extends AbstractExtensionRegistry<NiFiRegistryExtensionBundleMetadata> {
    private NiFiRegistryClient registryClient;

    public NiFiRegistryExtensionRegistry(String identifier, String url, String name, SSLContext sslContext) {
        super(identifier, url, name, sslContext);
    }

    private synchronized NiFiRegistryClient getRegistryClient() {
        if (this.registryClient != null) {
            return this.registryClient;
        }
        NiFiRegistryClientConfig config = new NiFiRegistryClientConfig.Builder().connectTimeout(Integer.valueOf(30000)).readTimeout(Integer.valueOf(30000)).sslContext(this.getSSLContext()).baseUrl(this.getURL()).build();
        this.registryClient = new JerseyNiFiRegistryClient.Builder().config(config).build();
        return this.registryClient;
    }

    private synchronized void invalidateClient() {
        this.registryClient = null;
    }

    @Override
    public void setURL(String url) {
        super.setURL(url);
        this.invalidateClient();
    }

    public Set<NiFiRegistryExtensionBundleMetadata> getExtensionBundleMetadata(NiFiUser user) throws IOException, ExtensionRegistryException {
        RequestConfig requestConfig = this.getRequestConfig(user);
        NiFiRegistryClient registryClient = this.getRegistryClient();
        BundleVersionClient bundleVersionClient = registryClient.getBundleVersionClient(requestConfig);
        try {
            List bundleVersions = bundleVersionClient.getBundleVersions(BundleVersionFilterParams.empty());
            return bundleVersions.stream().map((? super T bv) -> this.map((BundleVersionMetadata)bv)).collect(Collectors.toSet());
        }
        catch (NiFiRegistryException nre) {
            throw new ExtensionRegistryException(nre.getMessage(), (Throwable)nre);
        }
    }

    public InputStream getExtensionBundleContent(NiFiUser user, NiFiRegistryExtensionBundleMetadata bundleMetadata) throws IOException, ExtensionRegistryException {
        RequestConfig requestConfig = this.getRequestConfig(user);
        NiFiRegistryClient registryClient = this.getRegistryClient();
        BundleVersionClient bundleVersionClient = registryClient.getBundleVersionClient(requestConfig);
        try {
            return bundleVersionClient.getBundleVersionContent(bundleMetadata.getBundleIdentifier(), bundleMetadata.getVersion());
        }
        catch (NiFiRegistryException nre) {
            throw new ExtensionRegistryException(nre.getMessage(), (Throwable)nre);
        }
    }

    private RequestConfig getRequestConfig(NiFiUser user) {
        String identity = this.getIdentity(user);
        return identity == null ? null : new ProxiedEntityRequestConfig(new String[]{identity});
    }

    private String getIdentity(NiFiUser user) {
        return user == null || user.isAnonymous() ? null : user.getIdentity();
    }

    private NiFiRegistryExtensionBundleMetadata map(BundleVersionMetadata bundleVersionMetadata) {
        return new NiFiRegistryExtensionBundleMetadata.Builder().group(bundleVersionMetadata.getGroupId()).artifact(bundleVersionMetadata.getArtifactId()).version(bundleVersionMetadata.getVersion()).bundleIdentifier(bundleVersionMetadata.getBundleId()).timestamp(bundleVersionMetadata.getTimestamp()).registryIdentifier(this.getIdentifier()).build();
    }
}

