/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flow.resource;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.flow.resource.ExternalResourceConflictResolutionStrategy;
import org.apache.nifi.flow.resource.ExternalResourceDescriptor;
import org.apache.nifi.flow.resource.ExternalResourceProvider;
import org.apache.nifi.flow.resource.ExternalResourceProviderWorker;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ConflictResolvingExternalResourceProviderWorker
implements ExternalResourceProviderWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConflictResolvingExternalResourceProviderWorker.class);
    private final String id = UUID.randomUUID().toString();
    private final String name;
    private final ClassLoader providerClassLoader;
    private final ExternalResourceProvider provider;
    private final File targetDirectory;
    private final long pollTimeInMs;
    private final ExternalResourceConflictResolutionStrategy resolutionStrategy;
    private final CountDownLatch restrainStartupLatch;
    private final AtomicLong loopCounter = new AtomicLong(1L);
    private volatile boolean stopped = false;

    ConflictResolvingExternalResourceProviderWorker(String namePrefix, ClassLoader providerClassLoader, ExternalResourceProvider provider, ExternalResourceConflictResolutionStrategy resolutionStrategy, File targetDirectory, long pollTimeInMs, CountDownLatch restrainStartupLatch) {
        this.name = namePrefix + " - " + this.id;
        this.providerClassLoader = providerClassLoader;
        this.provider = provider;
        this.resolutionStrategy = resolutionStrategy;
        this.targetDirectory = targetDirectory;
        this.pollTimeInMs = pollTimeInMs;
        this.restrainStartupLatch = restrainStartupLatch;
    }

    @Override
    public void run() {
        LOGGER.info("External resource provider worker is started");
        while (!this.stopped) {
            try {
                FileUtils.ensureDirectoryExistAndCanReadAndWrite((File)this.targetDirectory);
            }
            catch (IOException e) {
                LOGGER.error("Could not ensure that target directory is accessible", (Throwable)e);
                this.stopped = true;
            }
            if (!this.stopped) {
                try {
                    this.poll();
                    if (this.loopCounter.get() == 1L) {
                        this.restrainStartupLatch.countDown();
                    }
                }
                catch (Throwable e) {
                    LOGGER.error("Error during polling for external resources", e);
                }
            }
            try {
                Thread.sleep(this.pollTimeInMs);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warn("External resource provider worker is interrupted");
                this.stopped = true;
            }
            this.loopCounter.incrementAndGet();
        }
    }

    private void poll() throws IOException {
        Collection availableResources;
        LOGGER.debug("Worker starts polling provider for resources");
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ClassLoader)this.providerClassLoader);){
            availableResources = this.provider.listResources();
        }
        for (ExternalResourceDescriptor availableResource : availableResources) {
            if (this.resolutionStrategy.shouldBeFetched(this.targetDirectory, availableResource)) {
                this.acquireResource(availableResource);
                continue;
            }
            LOGGER.trace("External resource {} is not to be fetched", (Object)availableResource.getLocation());
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final ExternalResourceProvider getProvider() {
        return this.provider;
    }

    @Override
    public final boolean isRunning() {
        return !this.stopped;
    }

    @Override
    public final void stop() {
        LOGGER.info("External resource provider worker is stopped");
        this.stopped = true;
    }

    protected final String getId() {
        return this.id;
    }

    protected final File getTargetDirectory() {
        return this.targetDirectory;
    }

    protected final ClassLoader getProviderClassLoader() {
        return this.providerClassLoader;
    }

    protected abstract void acquireResource(ExternalResourceDescriptor var1) throws IOException;
}

