/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.configuration.dto;

import java.util.HashMap;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.minifi.commons.schema.RemotePortSchema;
import org.apache.nifi.minifi.commons.schema.RemoteProcessGroupSchema;
import org.apache.nifi.minifi.toolkit.configuration.dto.RemotePortSchemaFunction;
import org.apache.nifi.web.api.dto.RemoteProcessGroupContentsDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;

public class RemoteProcessGroupSchemaFunction
implements Function<RemoteProcessGroupDTO, RemoteProcessGroupSchema> {
    private final RemotePortSchemaFunction remotePortSchemaFunction;

    public RemoteProcessGroupSchemaFunction(RemotePortSchemaFunction remotePortSchemaFunction) {
        this.remotePortSchemaFunction = remotePortSchemaFunction;
    }

    @Override
    public RemoteProcessGroupSchema apply(RemoteProcessGroupDTO remoteProcessGroupDTO) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", remoteProcessGroupDTO.getId());
        map.put("name", remoteProcessGroupDTO.getName());
        String targetUris = remoteProcessGroupDTO.getTargetUris();
        map.put("url", StringUtils.isNotBlank((CharSequence)targetUris) ? targetUris : remoteProcessGroupDTO.getTargetUri());
        RemoteProcessGroupContentsDTO contents = remoteProcessGroupDTO.getContents();
        if (contents != null) {
            Set outputPorts;
            Set inputPorts = contents.getInputPorts();
            if (inputPorts != null) {
                map.put("Input Ports", inputPorts.stream().map(this.remotePortSchemaFunction).map(RemotePortSchema::toMap).collect(Collectors.toList()));
            }
            if ((outputPorts = contents.getOutputPorts()) != null) {
                map.put("Output Ports", outputPorts.stream().map(this.remotePortSchemaFunction).map(RemotePortSchema::toMap).collect(Collectors.toList()));
            }
        }
        map.put("comment", remoteProcessGroupDTO.getComments());
        map.put("timeout", remoteProcessGroupDTO.getCommunicationsTimeout());
        map.put("yield period", remoteProcessGroupDTO.getYieldDuration());
        map.put("transport protocol", remoteProcessGroupDTO.getTransportProtocol());
        map.put("proxy host", remoteProcessGroupDTO.getProxyHost());
        map.put("proxy port", remoteProcessGroupDTO.getProxyPort());
        map.put("proxy user", remoteProcessGroupDTO.getProxyUser());
        map.put("proxy password", remoteProcessGroupDTO.getProxyPassword());
        map.put("local network interface", remoteProcessGroupDTO.getLocalNetworkInterface());
        return new RemoteProcessGroupSchema(map);
    }
}

