/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.repository.schema;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.repository.schema.FieldType;
import org.apache.nifi.repository.schema.RecordField;
import org.apache.nifi.repository.schema.Repetition;

public class SimpleRecordField
implements RecordField {
    private final String fieldName;
    private final FieldType fieldType;
    private final Repetition repetition;

    public SimpleRecordField(String fieldName, FieldType fieldType, Repetition repetition) {
        Objects.requireNonNull(fieldName);
        Objects.requireNonNull(fieldType);
        Objects.requireNonNull(repetition);
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.repetition = repetition;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public FieldType getFieldType() {
        return this.fieldType;
    }

    @Override
    public Repetition getRepetition() {
        return this.repetition;
    }

    @Override
    public List<RecordField> getSubFields() {
        return Collections.emptyList();
    }

    public int hashCode() {
        return 31 + this.fieldName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordField)) {
            return false;
        }
        RecordField other = (RecordField)obj;
        return this.fieldName.equals(other.getFieldName());
    }

    public String toString() {
        return "SimpleRecordField[fieldName=" + this.fieldName + ", type=" + this.fieldType.name() + "]";
    }
}

