/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.wal.WalDataRecord;
import io.questdb.cairo.wal.WalReader;
import io.questdb.std.Misc;

public class WalDataCursor
implements RecordCursor {
    private final WalDataRecord recordA = new WalDataRecord();
    private long maxRecordIndex = -1L;
    private WalReader reader;

    @Override
    public void close() {
        this.reader = Misc.free(this.reader);
    }

    @Override
    public Record getRecord() {
        return this.recordA;
    }

    @Override
    public Record getRecordB() {
        throw new UnsupportedOperationException("No B record for WAL");
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        if (this.recordA.getRecordIndex() < this.maxRecordIndex) {
            this.recordA.incrementRecordIndex();
            return true;
        }
        return false;
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        throw new UnsupportedOperationException();
    }

    public void of(WalReader reader) {
        this.close();
        this.reader = reader;
        this.recordA.of(reader);
        long segmentSize = reader.openSegment();
        this.maxRecordIndex = segmentSize - 1L;
    }

    @Override
    public void recordAt(Record record, long rowId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long size() {
        return this.reader.size();
    }

    @Override
    public void toTop() {
        this.recordA.jumpTo(-1L);
    }
}

