/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.columns;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;

public class StrColumn
extends StrFunction
implements ScalarFunction {
    private static final ObjList<StrColumn> COLUMNS = new ObjList(32);
    private final int columnIndex;

    public StrColumn(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public static StrColumn newInstance(int columnIndex) {
        if (columnIndex < 32) {
            return COLUMNS.getQuick(columnIndex);
        }
        return new StrColumn(columnIndex);
    }

    @Override
    public CharSequence getStr(Record rec) {
        return rec.getStr(this.columnIndex);
    }

    @Override
    public void getStr(Record rec, CharSink sink) {
        rec.getStr(this.columnIndex, sink);
    }

    @Override
    public CharSequence getStrB(Record rec) {
        return rec.getStrB(this.columnIndex);
    }

    @Override
    public int getStrLen(Record rec) {
        return rec.getStrLen(this.columnIndex);
    }

    @Override
    public boolean isReadThreadSafe() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.putColumnName(this.columnIndex);
    }

    static {
        COLUMNS.setPos(32);
        for (int i = 0; i < 32; ++i) {
            COLUMNS.setQuick(i, new StrColumn(i));
        }
    }
}

