/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.date.TimestampFloorFunctions;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class DateTruncFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "date_trunc(sN)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function kindFunction = args.getQuick(0);
        CharSequence kind = kindFunction.getStr(null);
        Function innerFunction = args.getQuick(1);
        if (kind == null) {
            throw SqlException.position(argPositions.getQuick(0)).put("invalid kind 'null'");
        }
        if (Chars.equals(kind, (CharSequence)"microseconds")) {
            return innerFunction;
        }
        if (Chars.equals(kind, (CharSequence)"milliseconds")) {
            return new TimestampFloorFunctions.TimestampFloorMSFunction(innerFunction);
        }
        if (Chars.equals(kind, (CharSequence)"second")) {
            return new TimestampFloorFunctions.TimestampFloorSSFunction(innerFunction);
        }
        if (Chars.equals(kind, (CharSequence)"minute")) {
            return new TimestampFloorFunctions.TimestampFloorMIFunction(innerFunction);
        }
        if (Chars.equals(kind, (CharSequence)"hour")) {
            return new TimestampFloorFunctions.TimestampFloorHHFunction(innerFunction);
        }
        if (Chars.equals(kind, (CharSequence)"day")) {
            return new TimestampFloorFunctions.TimestampFloorDDFunction(innerFunction);
        }
        if (Chars.equals(kind, (CharSequence)"week")) {
            return new TimestampFloorFunctions.TimestampFloorDayOfWeekFunction(innerFunction);
        }
        if (Chars.equals(kind, (CharSequence)"month")) {
            return new TimestampFloorFunctions.TimestampFloorMMFunction(innerFunction);
        }
        if (Chars.equals(kind, (CharSequence)"quarter")) {
            return new TimestampFloorFunctions.TimestampFloorQuarterFunction(innerFunction);
        }
        if (Chars.equals(kind, (CharSequence)"year")) {
            return new TimestampFloorFunctions.TimestampFloorYYYYFunction(innerFunction);
        }
        if (Chars.equals(kind, (CharSequence)"decade")) {
            return new TimestampFloorFunctions.TimestampFloorDecadeFunction(innerFunction);
        }
        if (Chars.equals(kind, (CharSequence)"century")) {
            return new TimestampFloorFunctions.TimestampFloorCenturyFunction(innerFunction);
        }
        if (Chars.equals(kind, (CharSequence)"millennium")) {
            return new TimestampFloorFunctions.TimestampFloorMillenniumFunction(innerFunction);
        }
        throw SqlException.$(argPositions.getQuick(0), "invalid kind '").put(kind).put('\'');
    }
}

