/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.protocol.socket;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.nifi.remote.Peer;
import org.apache.nifi.remote.PeerDescription;
import org.apache.nifi.remote.PeerDescriptionModifiable;
import org.apache.nifi.remote.PeerDescriptionModifier;
import org.apache.nifi.remote.RemoteResourceFactory;
import org.apache.nifi.remote.StandardVersionNegotiator;
import org.apache.nifi.remote.VersionNegotiator;
import org.apache.nifi.remote.cluster.ClusterNodeInformation;
import org.apache.nifi.remote.cluster.NodeInformation;
import org.apache.nifi.remote.codec.FlowFileCodec;
import org.apache.nifi.remote.exception.HandshakeException;
import org.apache.nifi.remote.exception.ProtocolException;
import org.apache.nifi.remote.protocol.AbstractFlowFileServerProtocol;
import org.apache.nifi.remote.protocol.CommunicationsSession;
import org.apache.nifi.remote.protocol.HandshakeProperties;
import org.apache.nifi.remote.protocol.RequestType;
import org.apache.nifi.remote.protocol.ResponseCode;
import org.apache.nifi.remote.protocol.SiteToSiteTransportProtocol;

public class SocketFlowFileServerProtocol
extends AbstractFlowFileServerProtocol
implements PeerDescriptionModifiable {
    public static final String RESOURCE_NAME = "SocketFlowFileProtocol";
    private final VersionNegotiator versionNegotiator = new StandardVersionNegotiator(new int[]{6, 5, 4, 3, 2, 1});
    private PeerDescriptionModifier peerDescriptionModifier;

    @Override
    public void setPeerDescriptionModifier(PeerDescriptionModifier modifier) {
        this.peerDescriptionModifier = modifier;
    }

    @Override
    protected HandshakeProperties doHandshake(Peer peer) throws IOException {
        HandshakeProperties confirmed = new HandshakeProperties();
        CommunicationsSession commsSession = peer.getCommunicationsSession();
        DataInputStream dis = new DataInputStream(commsSession.getInput().getInputStream());
        DataOutputStream dos = new DataOutputStream(commsSession.getOutput().getOutputStream());
        confirmed.setCommsIdentifier(dis.readUTF());
        if (this.versionNegotiator.getVersion() >= 3) {
            String transitUriPrefix = dis.readUTF();
            if (!transitUriPrefix.endsWith("/")) {
                transitUriPrefix = transitUriPrefix + "/";
            }
            confirmed.setTransitUriPrefix(transitUriPrefix);
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        int numProperties = dis.readInt();
        for (int i = 0; i < numProperties; ++i) {
            String propertyName = dis.readUTF();
            String propertyValue = dis.readUTF();
            properties.put(propertyName, propertyValue);
        }
        boolean responseWritten = false;
        try {
            this.validateHandshakeRequest(confirmed, peer, properties);
        }
        catch (HandshakeException e) {
            ResponseCode handshakeResult = e.getResponseCode();
            if (handshakeResult.containsMessage()) {
                handshakeResult.writeResponse(dos, e.getMessage());
            } else {
                handshakeResult.writeResponse(dos);
            }
            switch (handshakeResult) {
                case UNAUTHORIZED: 
                case PORT_NOT_IN_VALID_STATE: 
                case PORTS_DESTINATION_FULL: {
                    responseWritten = true;
                    break;
                }
                default: {
                    throw e;
                }
            }
        }
        if (!responseWritten) {
            ResponseCode.PROPERTIES_OK.writeResponse(dos);
        }
        return confirmed;
    }

    public FlowFileCodec negotiateCodec(Peer peer) throws IOException {
        if (!this.handshakeCompleted) {
            throw new IllegalStateException("Handshake has not been completed");
        }
        if (this.shutdown) {
            throw new IllegalStateException("Protocol is shutdown");
        }
        this.logger.debug("{} Negotiating Codec with {} using {}", new Object[]{this, peer, peer.getCommunicationsSession()});
        CommunicationsSession commsSession = peer.getCommunicationsSession();
        DataInputStream dis = new DataInputStream(commsSession.getInput().getInputStream());
        DataOutputStream dos = new DataOutputStream(commsSession.getOutput().getOutputStream());
        if (this.port == null) {
            RemoteResourceFactory.rejectCodecNegotiation(dis, dos, "Cannot transfer FlowFiles because no port was specified");
        }
        try {
            this.negotiatedFlowFileCodec = RemoteResourceFactory.receiveCodecNegotiation(dis, dos);
            this.logger.debug("{} Negotiated Codec {} with {}", new Object[]{this, this.negotiatedFlowFileCodec, peer});
            return this.negotiatedFlowFileCodec;
        }
        catch (HandshakeException e) {
            throw new ProtocolException(e.toString());
        }
    }

    public RequestType getRequestType(Peer peer) throws IOException {
        if (!this.handshakeCompleted) {
            throw new IllegalStateException("Handshake has not been completed");
        }
        if (this.shutdown) {
            throw new IllegalStateException("Protocol is shutdown");
        }
        this.logger.debug("{} Reading Request Type from {} using {}", new Object[]{this, peer, peer.getCommunicationsSession()});
        RequestType requestType = RequestType.readRequestType((DataInputStream)new DataInputStream(peer.getCommunicationsSession().getInput().getInputStream()));
        this.logger.debug("{} Got Request Type {} from {}", new Object[]{this, requestType, peer});
        return requestType;
    }

    public void sendPeerList(Peer peer, Optional<ClusterNodeInformation> clusterNodeInfo, NodeInformation self) throws IOException {
        if (!this.handshakeCompleted) {
            throw new IllegalStateException("Handshake has not been completed");
        }
        if (this.shutdown) {
            throw new IllegalStateException("Protocol is shutdown");
        }
        this.logger.debug("{} Sending Peer List to {}", (Object)this, (Object)peer);
        CommunicationsSession commsSession = peer.getCommunicationsSession();
        DataOutputStream dos = new DataOutputStream(commsSession.getOutput().getOutputStream());
        this.logger.debug("{} Advertising Remote Input host name {}", (Object)this, (Object)peer);
        List<NodeInformation> nodeInfos = clusterNodeInfo.isPresent() ? new ArrayList<NodeInformation>(clusterNodeInfo.get().getNodeInformation()) : Collections.singletonList(self);
        int numPeers = 0;
        for (NodeInformation nodeInfo : nodeInfos) {
            if (nodeInfo.getSiteToSitePort() == null) continue;
            ++numPeers;
        }
        dos.writeInt(numPeers);
        for (NodeInformation nodeInfo : nodeInfos) {
            if (nodeInfo.getSiteToSitePort() == null) continue;
            if (this.peerDescriptionModifier != null && this.peerDescriptionModifier.isModificationNeeded(SiteToSiteTransportProtocol.RAW)) {
                PeerDescription target = new PeerDescription(nodeInfo.getSiteToSiteHostname(), nodeInfo.getSiteToSitePort().intValue(), nodeInfo.isSiteToSiteSecure());
                PeerDescription modifiedTarget = this.peerDescriptionModifier.modify(peer.getDescription(), target, SiteToSiteTransportProtocol.RAW, PeerDescriptionModifier.RequestType.Peers, new HashMap<String, String>());
                dos.writeUTF(modifiedTarget.getHostname());
                dos.writeInt(modifiedTarget.getPort());
                dos.writeBoolean(modifiedTarget.isSecure());
            } else {
                dos.writeUTF(nodeInfo.getSiteToSiteHostname());
                dos.writeInt(nodeInfo.getSiteToSitePort());
                dos.writeBoolean(nodeInfo.isSiteToSiteSecure());
            }
            dos.writeInt(nodeInfo.getTotalFlowFiles());
        }
        this.logger.info("Sending list of {} peers back to client {}", (Object)numPeers, (Object)peer);
        dos.flush();
    }

    public String getResourceName() {
        return RESOURCE_NAME;
    }

    public VersionNegotiator getVersionNegotiator() {
        return this.versionNegotiator;
    }

    @Override
    protected String createTransitUri(Peer peer, String sourceFlowFileIdentifier) {
        String transitUriPrefix = this.handshakeProperties.getTransitUriPrefix();
        return transitUriPrefix == null ? peer.getUrl() : transitUriPrefix + sourceFlowFileIdentifier;
    }
}

