/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.configuration.dto;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.minifi.commons.schema.ConnectionSchema;
import org.apache.nifi.minifi.commons.schema.common.CollectionUtil;
import org.apache.nifi.web.api.dto.ConnectionDTO;

public class ConnectionSchemaFunction
implements Function<ConnectionDTO, ConnectionSchema> {
    @Override
    public ConnectionSchema apply(ConnectionDTO connectionDTO) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", connectionDTO.getId());
        map.put("name", connectionDTO.getName());
        map.put("source id", connectionDTO.getSource().getId());
        Set selectedRelationships = CollectionUtil.nullToEmpty((Set)connectionDTO.getSelectedRelationships());
        map.put("source relationship names", selectedRelationships.stream().sorted().collect(Collectors.toList()));
        map.put("destination id", connectionDTO.getDestination().getId());
        map.put("max work queue size", connectionDTO.getBackPressureObjectThreshold());
        map.put("max work queue data size", connectionDTO.getBackPressureDataSizeThreshold());
        map.put("flowfile expiration", connectionDTO.getFlowFileExpiration());
        List queuePrioritizers = CollectionUtil.nullToEmpty((List)connectionDTO.getPrioritizers());
        if (queuePrioritizers.size() > 0) {
            map.put("queue prioritizer class", queuePrioritizers.get(0));
        }
        ConnectionSchema connectionSchema = new ConnectionSchema(map);
        if (ConnectableType.FUNNEL.name().equals(connectionDTO.getSource().getType())) {
            connectionSchema.addValidationIssue("Connection " + connectionDTO.getName() + " has type " + ConnectableType.FUNNEL.name() + " which is not supported by MiNiFi");
        }
        if (queuePrioritizers.size() > 1) {
            connectionSchema.addValidationIssue("queue prioritizer class", "Connections", " has more than one queue prioritizer");
        }
        return connectionSchema;
    }
}

