/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.ConstantEntityIterableHandle;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.FieldIndexIterator;
import org.jetbrains.annotations.NotNull;

public class EntitiesWithLinkIterable
extends EntityIterableBase {
    private final int entityTypeId;
    private final int linkId;

    public EntitiesWithLinkIterable(@NotNull PersistentStoreTransaction txn, int entityTypeId, int linkId) {
        super(txn);
        this.entityTypeId = entityTypeId;
        this.linkId = linkId;
    }

    public static EntityIterableType getType() {
        return EntityIterableType.ENTITIES_WITH_LINK;
    }

    @Override
    public int getEntityTypeId() {
        return this.entityTypeId;
    }

    @Override
    public boolean isSortedById() {
        return true;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new FieldIndexIterator(this, this.entityTypeId, this.linkId, this.getStore().getEntityWithLinkIterable(txn, this.entityTypeId, this.linkId));
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new EntitiesWithLinkIterableHandle();
    }

    static {
        EntitiesWithLinkIterable.registerType(EntitiesWithLinkIterable.getType(), (txn, store, parameters) -> new EntitiesWithLinkIterable(txn, Integer.parseInt((String)parameters[0]), Integer.parseInt((String)parameters[1])));
    }

    protected class EntitiesWithLinkIterableHandle
    extends ConstantEntityIterableHandle {
        public EntitiesWithLinkIterableHandle() {
            super(EntitiesWithLinkIterable.this.getStore(), EntitiesWithLinkIterable.getType());
        }

        @Override
        @NotNull
        public int[] getLinkIds() {
            return new int[]{EntitiesWithLinkIterable.this.linkId};
        }

        @Override
        public void toString(@NotNull StringBuilder builder) {
            super.toString(builder);
            builder.append(EntitiesWithLinkIterable.this.entityTypeId);
            builder.append('-');
            builder.append(EntitiesWithLinkIterable.this.linkId);
        }

        @Override
        public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
            hash.apply(EntitiesWithLinkIterable.this.entityTypeId);
            hash.applyDelimiter();
            hash.apply(EntitiesWithLinkIterable.this.linkId);
        }

        @Override
        public int getEntityTypeId() {
            return EntitiesWithLinkIterable.this.entityTypeId;
        }

        @Override
        public boolean isMatchedLinkAdded(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
            return EntitiesWithLinkIterable.this.entityTypeId == source.getTypeId();
        }

        @Override
        public boolean isMatchedLinkDeleted(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
            return EntitiesWithLinkIterable.this.entityTypeId == source.getTypeId();
        }
    }
}

