/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.pagestore.db;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import v14.h2.engine.Database;
import v14.h2.engine.SessionInterface;
import v14.h2.jdbc.JdbcConnection;
import v14.h2.message.DbException;
import v14.h2.store.CountingReaderInputStream;
import v14.h2.store.LobStorageInterface;
import v14.h2.tools.CompressTool;
import v14.h2.util.IOUtils;
import v14.h2.util.MathUtils;
import v14.h2.util.Utils;
import v14.h2.value.Value;
import v14.h2.value.ValueLobDb;

public class LobStorageBackend
implements LobStorageInterface {
    public static final String LOB_DATA_TABLE = "LOB_DATA";
    private static final String LOB_SCHEMA = "INFORMATION_SCHEMA";
    private static final String LOBS = "INFORMATION_SCHEMA.LOBS";
    private static final String LOB_MAP = "INFORMATION_SCHEMA.LOB_MAP";
    private static final String LOB_DATA = "INFORMATION_SCHEMA.LOB_DATA";
    private static final int BLOCK_LENGTH = 20000;
    private static final int HASH_CACHE_SIZE = 4096;
    JdbcConnection conn;
    final Database database;
    private final HashMap<String, PreparedStatement> prepared = new HashMap();
    private long nextBlock;
    private final CompressTool compress = CompressTool.getInstance();
    private long[] hashBlocks;
    private boolean init;

    public LobStorageBackend(Database database) {
        this.database = database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.init) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (this.init) {
                return;
            }
            this.init = true;
            this.conn = this.database.getLobConnectionForRegularUse();
            JdbcConnection jdbcConnection = this.database.getLobConnectionForInit();
            try {
                Statement statement = jdbcConnection.createStatement();
                boolean bl = true;
                PreparedStatement preparedStatement = jdbcConnection.prepareStatement("SELECT ZERO() FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA=? AND TABLE_NAME=? AND COLUMN_NAME=?");
                preparedStatement.setString(1, LOB_SCHEMA);
                preparedStatement.setString(2, "LOB_MAP");
                preparedStatement.setString(3, "POS");
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    preparedStatement = jdbcConnection.prepareStatement("SELECT ZERO() FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA=? AND TABLE_NAME=?");
                    preparedStatement.setString(1, LOB_SCHEMA);
                    preparedStatement.setString(2, LOB_DATA_TABLE);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        bl = false;
                    }
                }
                if (bl) {
                    statement.execute("CREATE CACHED TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOBS(ID BIGINT PRIMARY KEY, BYTE_COUNT BIGINT, `TABLE` INT) HIDDEN");
                    statement.execute("CREATE INDEX IF NOT EXISTS INFORMATION_SCHEMA.INDEX_LOB_TABLE ON INFORMATION_SCHEMA.LOBS(`TABLE`)");
                    statement.execute("CREATE CACHED TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOB_MAP(LOB BIGINT, SEQ INT, POS BIGINT, HASH INT, BLOCK BIGINT, PRIMARY KEY(LOB, SEQ)) HIDDEN");
                    statement.execute("ALTER TABLE INFORMATION_SCHEMA.LOB_MAP RENAME TO INFORMATION_SCHEMA.LOB_MAP HIDDEN");
                    statement.execute("ALTER TABLE INFORMATION_SCHEMA.LOB_MAP ADD IF NOT EXISTS POS BIGINT BEFORE HASH");
                    statement.execute("ALTER TABLE INFORMATION_SCHEMA.LOB_MAP DROP COLUMN IF EXISTS \"OFFSET\"");
                    statement.execute("CREATE INDEX IF NOT EXISTS INFORMATION_SCHEMA.INDEX_LOB_MAP_DATA_LOB ON INFORMATION_SCHEMA.LOB_MAP(BLOCK, LOB)");
                    statement.execute("CREATE CACHED TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOB_DATA(BLOCK BIGINT PRIMARY KEY, COMPRESSED INT, DATA BINARY) HIDDEN");
                }
                resultSet = statement.executeQuery("SELECT MAX(BLOCK) FROM INFORMATION_SCHEMA.LOB_DATA");
                resultSet.next();
                this.nextBlock = resultSet.getLong(1) + 1L;
                statement.close();
            }
            catch (SQLException sQLException) {
                throw DbException.convert(sQLException);
            }
        }
    }

    private long getNextLobId() throws SQLException {
        String string = "SELECT MAX(LOB) FROM INFORMATION_SCHEMA.LOB_MAP";
        PreparedStatement preparedStatement = this.prepare(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        long l = resultSet.getLong(1) + 1L;
        this.reuse(string, preparedStatement);
        string = "SELECT MAX(ID) FROM INFORMATION_SCHEMA.LOBS";
        preparedStatement = this.prepare(string);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        l = Math.max(l, resultSet.getLong(1) + 1L);
        this.reuse(string, preparedStatement);
        return l;
    }

    @Override
    public void removeAllForTable(int n) {
        this.init();
        try {
            String string = "SELECT ID FROM INFORMATION_SCHEMA.LOBS WHERE `TABLE` = ?";
            PreparedStatement preparedStatement = this.prepare(string);
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                this.removeLob(resultSet.getLong(1));
            }
            this.reuse(string, preparedStatement);
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
        if (n == -1) {
            this.removeAllForTable(-2);
            this.removeAllForTable(-3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] readBlock(long l) throws SQLException {
        LobStorageBackend.assertNotHolds(this.conn.getSession());
        Database database = this.database;
        synchronized (database) {
            SessionInterface sessionInterface = this.conn.getSession();
            synchronized (sessionInterface) {
                String string = "SELECT COMPRESSED, DATA FROM INFORMATION_SCHEMA.LOB_DATA WHERE BLOCK = ?";
                PreparedStatement preparedStatement = this.prepare(string);
                preparedStatement.setLong(1, l);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) {
                    throw DbException.getJdbcSQLException(90028, "Missing lob entry, block: " + l);
                }
                int n = resultSet.getInt(1);
                byte[] byArray = resultSet.getBytes(2);
                if (n != 0) {
                    byArray = this.compress.expand(byArray);
                }
                this.reuse(string, preparedStatement);
                return byArray;
            }
        }
    }

    PreparedStatement prepare(String string) throws SQLException {
        assert (Thread.holdsLock(this.database));
        PreparedStatement preparedStatement = this.prepared.remove(string);
        if (preparedStatement == null) {
            preparedStatement = this.conn.prepareStatement(string);
        }
        return preparedStatement;
    }

    void reuse(String string, PreparedStatement preparedStatement) {
        assert (Thread.holdsLock(this.database));
        this.prepared.put(string, preparedStatement);
    }

    @Override
    public void removeLob(ValueLobDb valueLobDb) {
        this.removeLob(valueLobDb.getLobId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLob(long l) {
        try {
            LobStorageBackend.assertNotHolds(this.conn.getSession());
            Database database = this.database;
            synchronized (database) {
                SessionInterface sessionInterface = this.conn.getSession();
                synchronized (sessionInterface) {
                    String string = "SELECT BLOCK, HASH FROM INFORMATION_SCHEMA.LOB_MAP D WHERE D.LOB = ? AND NOT EXISTS(SELECT 1 FROM INFORMATION_SCHEMA.LOB_MAP O WHERE O.BLOCK = D.BLOCK AND O.LOB <> ?)";
                    PreparedStatement preparedStatement = this.prepare(string);
                    preparedStatement.setLong(1, l);
                    preparedStatement.setLong(2, l);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    ArrayList arrayList = Utils.newSmallArrayList();
                    while (resultSet.next()) {
                        arrayList.add(resultSet.getLong(1));
                        int n = resultSet.getInt(2);
                        this.setHashCacheBlock(n, -1L);
                    }
                    this.reuse(string, preparedStatement);
                    string = "DELETE FROM INFORMATION_SCHEMA.LOB_MAP WHERE LOB = ?";
                    preparedStatement = this.prepare(string);
                    preparedStatement.setLong(1, l);
                    preparedStatement.execute();
                    this.reuse(string, preparedStatement);
                    string = "DELETE FROM INFORMATION_SCHEMA.LOB_DATA WHERE BLOCK = ?";
                    preparedStatement = this.prepare(string);
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        long l2 = (Long)iterator.next();
                        preparedStatement.setLong(1, l2);
                        preparedStatement.execute();
                    }
                    this.reuse(string, preparedStatement);
                    string = "DELETE FROM INFORMATION_SCHEMA.LOBS WHERE ID = ?";
                    preparedStatement = this.prepare(string);
                    preparedStatement.setLong(1, l);
                    preparedStatement.execute();
                    this.reuse(string, preparedStatement);
                }
            }
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream(ValueLobDb valueLobDb, byte[] byArray, long l) throws IOException {
        try {
            this.init();
            LobStorageBackend.assertNotHolds(this.conn.getSession());
            Database database = this.database;
            synchronized (database) {
                SessionInterface sessionInterface = this.conn.getSession();
                synchronized (sessionInterface) {
                    long l2 = valueLobDb.getLobId();
                    return new LobInputStream(l2, l);
                }
            }
        }
        catch (SQLException sQLException) {
            throw DbException.convertToIOException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueLobDb addLob(InputStream inputStream, long l, int n, CountingReaderInputStream countingReaderInputStream) {
        try {
            byte[] byArray = new byte[20000];
            if (l < 0L) {
                l = Long.MAX_VALUE;
            }
            long l2 = 0L;
            long l3 = -1L;
            int n2 = this.database.getMaxLengthInplaceLob();
            String string = this.database.getLobCompressionAlgorithm(n);
            try {
                byte[] byArray2 = null;
                int n3 = 0;
                while (l > 0L) {
                    int n4 = (int)Math.min(20000L, l);
                    if ((n4 = IOUtils.readFully(inputStream, byArray, n4)) <= 0) break;
                    l -= (long)n4;
                    byte[] byArray3 = n4 != byArray.length ? Arrays.copyOf(byArray, n4) : byArray;
                    if (n3 == 0 && byArray3.length < 20000 && byArray3.length <= n2) {
                        byArray2 = byArray3;
                        break;
                    }
                    LobStorageBackend.assertNotHolds(this.conn.getSession());
                    Database database = this.database;
                    synchronized (database) {
                        SessionInterface sessionInterface = this.conn.getSession();
                        synchronized (sessionInterface) {
                            if (n3 == 0) {
                                l3 = this.getNextLobId();
                            }
                            this.storeBlock(l3, n3, l2, byArray3, string);
                        }
                    }
                    l2 += (long)n4;
                    ++n3;
                }
                if (l3 == -1L && byArray2 == null) {
                    byArray2 = new byte[]{};
                }
                if (byArray2 != null) {
                    long l4 = countingReaderInputStream == null ? (long)byArray2.length : countingReaderInputStream.getLength();
                    return ValueLobDb.createSmallLob(n, byArray2, l4);
                }
                long l5 = countingReaderInputStream == null ? l2 : countingReaderInputStream.getLength();
                return this.registerLob(n, l3, -2, l2, l5);
            }
            catch (IOException iOException) {
                if (l3 != -1L) {
                    this.removeLob(l3);
                }
                throw DbException.convertIOException(iOException, null);
            }
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueLobDb registerLob(int n, long l, int n2, long l2, long l3) throws SQLException {
        LobStorageBackend.assertNotHolds(this.conn.getSession());
        Database database = this.database;
        synchronized (database) {
            SessionInterface sessionInterface = this.conn.getSession();
            synchronized (sessionInterface) {
                String string = "INSERT INTO INFORMATION_SCHEMA.LOBS(ID, BYTE_COUNT, `TABLE`) VALUES(?, ?, ?)";
                PreparedStatement preparedStatement = this.prepare(string);
                preparedStatement.setLong(1, l);
                preparedStatement.setLong(2, l2);
                preparedStatement.setInt(3, n2);
                preparedStatement.execute();
                this.reuse(string, preparedStatement);
                return ValueLobDb.create(n, this.database, n2, l, null, l3);
            }
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.database.isReadOnly();
    }

    @Override
    public ValueLobDb copyLob(ValueLobDb valueLobDb, int n, long l) {
        int n2 = valueLobDb.getValueType();
        long l2 = valueLobDb.getLobId();
        LobStorageBackend.assertNotHolds(this.conn.getSession());
        Database database = this.database;
        synchronized (database) {
            SessionInterface sessionInterface = this.conn.getSession();
            synchronized (sessionInterface) {
                try {
                    this.init();
                    ValueLobDb valueLobDb2 = null;
                    if (!valueLobDb.isRecoveryReference()) {
                        long l3 = this.getNextLobId();
                        String string = "INSERT INTO INFORMATION_SCHEMA.LOB_MAP(LOB, SEQ, POS, HASH, BLOCK) SELECT ?, SEQ, POS, HASH, BLOCK FROM INFORMATION_SCHEMA.LOB_MAP WHERE LOB = ?";
                        PreparedStatement preparedStatement = this.prepare(string);
                        preparedStatement.setLong(1, l3);
                        preparedStatement.setLong(2, l2);
                        preparedStatement.executeUpdate();
                        this.reuse(string, preparedStatement);
                        string = "INSERT INTO INFORMATION_SCHEMA.LOBS(ID, BYTE_COUNT, `TABLE`) SELECT ?, BYTE_COUNT, ? FROM INFORMATION_SCHEMA.LOBS WHERE ID = ?";
                        preparedStatement = this.prepare(string);
                        preparedStatement.setLong(1, l3);
                        preparedStatement.setLong(2, n);
                        preparedStatement.setLong(3, l2);
                        preparedStatement.executeUpdate();
                        this.reuse(string, preparedStatement);
                        valueLobDb2 = ValueLobDb.create(n2, this.database, n, l3, null, l);
                    } else {
                        valueLobDb2 = ValueLobDb.create(n2, this.database, n, l2, null, l);
                    }
                    return valueLobDb2;
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
            }
        }
    }

    private long getHashCacheBlock(int n) {
        this.initHashCache();
        int n2 = n & 0xFFF;
        long l = this.hashBlocks[n2];
        if (l == (long)n) {
            return this.hashBlocks[n2 + 4096];
        }
        return -1L;
    }

    private void setHashCacheBlock(int n, long l) {
        this.initHashCache();
        int n2 = n & 0xFFF;
        this.hashBlocks[n2] = n;
        this.hashBlocks[n2 + 4096] = l;
    }

    private void initHashCache() {
        if (this.hashBlocks == null) {
            this.hashBlocks = new long[8192];
        }
    }

    void storeBlock(long l, int n, long l2, byte[] byArray, String string) throws SQLException {
        PreparedStatement preparedStatement;
        String string2;
        boolean bl = false;
        if (string != null) {
            byArray = this.compress.compress(byArray, string);
        }
        int n2 = Arrays.hashCode(byArray);
        LobStorageBackend.assertHoldsLock(this.conn.getSession());
        LobStorageBackend.assertHoldsLock(this.database);
        long l3 = this.getHashCacheBlock(n2);
        if (l3 != -1L) {
            string2 = "SELECT COMPRESSED, DATA FROM INFORMATION_SCHEMA.LOB_DATA WHERE BLOCK = ?";
            preparedStatement = this.prepare(string2);
            preparedStatement.setLong(1, l3);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                boolean bl2 = resultSet.getInt(1) != 0;
                byte[] byArray2 = resultSet.getBytes(2);
                if (bl2 == (string != null) && Arrays.equals(byArray, byArray2)) {
                    bl = true;
                }
            }
            this.reuse(string2, preparedStatement);
        }
        if (!bl) {
            l3 = this.nextBlock++;
            this.setHashCacheBlock(n2, l3);
            string2 = "INSERT INTO INFORMATION_SCHEMA.LOB_DATA(BLOCK, COMPRESSED, DATA) VALUES(?, ?, ?)";
            preparedStatement = this.prepare(string2);
            preparedStatement.setLong(1, l3);
            preparedStatement.setInt(2, string == null ? 0 : 1);
            preparedStatement.setBytes(3, byArray);
            preparedStatement.execute();
            this.reuse(string2, preparedStatement);
        }
        string2 = "INSERT INTO INFORMATION_SCHEMA.LOB_MAP(LOB, SEQ, POS, HASH, BLOCK) VALUES(?, ?, ?, ?, ?)";
        preparedStatement = this.prepare(string2);
        preparedStatement.setLong(1, l);
        preparedStatement.setInt(2, n);
        preparedStatement.setLong(3, l2);
        preparedStatement.setLong(4, n2);
        preparedStatement.setLong(5, l3);
        preparedStatement.execute();
        this.reuse(string2, preparedStatement);
    }

    @Override
    public Value createBlob(InputStream inputStream, long l) {
        this.init();
        return this.addLob(inputStream, l, 15, null);
    }

    @Override
    public Value createClob(Reader reader, long l) {
        this.init();
        long l2 = l == -1L ? Long.MAX_VALUE : l;
        CountingReaderInputStream countingReaderInputStream = new CountingReaderInputStream(reader, l2);
        return this.addLob(countingReaderInputStream, Long.MAX_VALUE, 16, countingReaderInputStream);
    }

    private static void assertNotHolds(Object object) {
        if (Thread.holdsLock(object)) {
            throw DbException.throwInternalError(object.toString());
        }
    }

    static void assertHoldsLock(Object object) {
        if (!Thread.holdsLock(object)) {
            throw DbException.throwInternalError(object.toString());
        }
    }

    public class LobInputStream
    extends InputStream {
        private final long[] lobMapBlocks;
        private int lobMapIndex;
        private long remainingBytes;
        private byte[] buffer;
        private int bufferPos;

        public LobInputStream(long l, long l2) throws SQLException {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            String string;
            LobStorageBackend.assertHoldsLock(LobStorageBackend.this.conn.getSession());
            LobStorageBackend.assertHoldsLock(LobStorageBackend.this.database);
            if (l2 == -1L) {
                string = "SELECT BYTE_COUNT FROM INFORMATION_SCHEMA.LOBS WHERE ID = ?";
                preparedStatement = LobStorageBackend.this.prepare(string);
                preparedStatement.setLong(1, l);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) {
                    throw DbException.getJdbcSQLException(90028, "Missing lob entry: " + l);
                }
                l2 = resultSet.getLong(1);
                LobStorageBackend.this.reuse(string, preparedStatement);
            }
            this.remainingBytes = l2;
            string = "SELECT COUNT(*) FROM INFORMATION_SCHEMA.LOB_MAP WHERE LOB = ?";
            preparedStatement = LobStorageBackend.this.prepare(string);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            int n = resultSet.getInt(1);
            if (n == 0) {
                throw DbException.getJdbcSQLException(90028, "Missing lob entry: " + l);
            }
            LobStorageBackend.this.reuse(string, preparedStatement);
            this.lobMapBlocks = new long[n];
            string = "SELECT BLOCK FROM INFORMATION_SCHEMA.LOB_MAP WHERE LOB = ? ORDER BY SEQ";
            preparedStatement = LobStorageBackend.this.prepare(string);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            int n2 = 0;
            while (resultSet.next()) {
                this.lobMapBlocks[n2] = resultSet.getLong(1);
                ++n2;
            }
            LobStorageBackend.this.reuse(string, preparedStatement);
        }

        @Override
        public int read() throws IOException {
            this.fillBuffer();
            if (this.remainingBytes <= 0L) {
                return -1;
            }
            --this.remainingBytes;
            return this.buffer[this.bufferPos++] & 0xFF;
        }

        @Override
        public long skip(long l) throws IOException {
            if (l <= 0L) {
                return 0L;
            }
            long l2 = l;
            if ((l2 -= (long)this.skipSmall(l2)) > 20000L) {
                while (l2 > 20000L) {
                    l2 -= 20000L;
                    this.remainingBytes -= 20000L;
                    ++this.lobMapIndex;
                }
                this.bufferPos = 0;
                this.buffer = null;
            }
            this.fillBuffer();
            l2 -= (long)this.skipSmall(l2);
            l2 -= super.skip(l2);
            return l - l2;
        }

        private int skipSmall(long l) {
            if (this.buffer != null && this.bufferPos < this.buffer.length) {
                int n = MathUtils.convertLongToInt(Math.min(l, (long)(this.buffer.length - this.bufferPos)));
                this.bufferPos += n;
                this.remainingBytes -= (long)n;
                return n;
            }
            return 0;
        }

        @Override
        public int available() throws IOException {
            return MathUtils.convertLongToInt(this.remainingBytes);
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.readFully(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.readFully(byArray, n, n2);
        }

        private int readFully(byte[] byArray, int n, int n2) throws IOException {
            if (n2 == 0) {
                return 0;
            }
            int n3 = 0;
            while (n2 > 0) {
                this.fillBuffer();
                if (this.remainingBytes <= 0L) break;
                int n4 = (int)Math.min((long)n2, this.remainingBytes);
                n4 = Math.min(n4, this.buffer.length - this.bufferPos);
                System.arraycopy(this.buffer, this.bufferPos, byArray, n, n4);
                this.bufferPos += n4;
                n3 += n4;
                this.remainingBytes -= (long)n4;
                n += n4;
                n2 -= n4;
            }
            return n3 == 0 ? -1 : n3;
        }

        private void fillBuffer() throws IOException {
            if (this.buffer != null && this.bufferPos < this.buffer.length) {
                return;
            }
            if (this.remainingBytes <= 0L) {
                return;
            }
            if (this.lobMapIndex >= this.lobMapBlocks.length) {
                System.out.println("halt!");
            }
            try {
                this.buffer = LobStorageBackend.this.readBlock(this.lobMapBlocks[this.lobMapIndex]);
                ++this.lobMapIndex;
                this.bufferPos = 0;
            }
            catch (SQLException sQLException) {
                throw DbException.convertToIOException(sQLException);
            }
        }
    }
}

