/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.state;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.controller.state.StandardStateMap;
import org.apache.nifi.controller.state.StateMapUpdate;
import org.wali.SerDe;
import org.wali.UpdateType;

public class StateMapSerDe
implements SerDe<StateMapUpdate> {
    private static final int VERSION = 0;

    public void serializeEdit(StateMapUpdate previousRecordState, StateMapUpdate newRecordState, DataOutputStream out) throws IOException {
        this.serializeRecord(newRecordState, out);
    }

    public void serializeRecord(StateMapUpdate record, DataOutputStream out) throws IOException {
        out.writeUTF(record.getComponentId());
        out.writeUTF(record.getUpdateType().name());
        if (record.getUpdateType() == UpdateType.DELETE) {
            return;
        }
        StateMap stateMap = record.getStateMap();
        long recordVersion = stateMap.getVersion();
        out.writeLong(recordVersion);
        Map map = stateMap.toMap();
        out.writeInt(map.size());
        for (Map.Entry entry : map.entrySet()) {
            boolean hasKey = entry.getKey() != null;
            boolean hasValue = entry.getValue() != null;
            out.writeBoolean(hasKey);
            if (hasKey) {
                out.writeUTF((String)entry.getKey());
            }
            out.writeBoolean(hasValue);
            if (!hasValue) continue;
            out.writeUTF((String)entry.getValue());
        }
    }

    public StateMapUpdate deserializeEdit(DataInputStream in, Map<Object, StateMapUpdate> currentRecordStates, int version) throws IOException {
        return this.deserializeRecord(in, version);
    }

    public StateMapUpdate deserializeRecord(DataInputStream in, int version) throws IOException {
        String componentId = in.readUTF();
        String updateTypeName = in.readUTF();
        UpdateType updateType = UpdateType.valueOf((String)updateTypeName);
        if (updateType == UpdateType.DELETE) {
            return new StateMapUpdate(null, componentId, updateType);
        }
        long recordVersion = in.readLong();
        int numEntries = in.readInt();
        HashMap<String, String> stateValues = new HashMap<String, String>(numEntries);
        for (int i = 0; i < numEntries; ++i) {
            boolean hasKey = in.readBoolean();
            String key = hasKey ? in.readUTF() : null;
            boolean hasValue = in.readBoolean();
            String value = hasValue ? in.readUTF() : null;
            stateValues.put(key, value);
        }
        return new StateMapUpdate((StateMap)new StandardStateMap(stateValues, recordVersion), componentId, updateType);
    }

    public Object getRecordIdentifier(StateMapUpdate record) {
        return record.getComponentId();
    }

    public UpdateType getUpdateType(StateMapUpdate record) {
        return record.getUpdateType();
    }

    public String getLocation(StateMapUpdate record) {
        return null;
    }

    public int getVersion() {
        return 0;
    }
}

