/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.sqlscript;

import java.util.HashMap;
import java.util.Map;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.license.FlywayTeamsUpgradeRequiredException;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.PlaceholderReplacingReader;

public class SqlScriptMetadata {
    private static final Log LOG = LogFactory.getLog(SqlScriptMetadata.class);
    private static final String EXECUTE_IN_TRANSACTION = "executeInTransaction";
    private static final String ENCODING = "encoding";
    private static final String PLACEHOLDER_REPLACEMENT = "placeholderReplacement";
    private static final String SHOULD_EXECUTE = "shouldExecute";
    private final Boolean executeInTransaction;
    private final String encoding;
    private final boolean placeholderReplacement;
    private boolean shouldExecute;

    private SqlScriptMetadata(Map<String, String> metadata) {
        metadata = new HashMap<String, String>(metadata);
        this.executeInTransaction = ConfigUtils.removeBoolean(metadata, EXECUTE_IN_TRANSACTION);
        this.encoding = metadata.remove(ENCODING);
        this.placeholderReplacement = Boolean.parseBoolean(metadata.getOrDefault(PLACEHOLDER_REPLACEMENT, "true"));
        metadata.remove(PLACEHOLDER_REPLACEMENT);
        this.shouldExecute = true;
        if (metadata.containsKey(SHOULD_EXECUTE)) {
            throw new FlywayTeamsUpgradeRequiredException(SHOULD_EXECUTE);
        }
        ConfigUtils.checkConfigurationForUnrecognisedProperties(metadata, null);
    }

    public Boolean executeInTransaction() {
        return this.executeInTransaction;
    }

    public String encoding() {
        return this.encoding;
    }

    public boolean placeholderReplacement() {
        return this.placeholderReplacement;
    }

    public boolean shouldExecute() {
        return this.shouldExecute;
    }

    public static boolean isMultilineBooleanExpression(String line) {
        return !line.startsWith(SHOULD_EXECUTE) && (line.contains("==") || line.contains("!="));
    }

    public static SqlScriptMetadata fromResource(LoadableResource resource, Parser parser) {
        if (resource != null) {
            LOG.debug("Found script configuration: " + resource.getFilename());
            if (parser == null) {
                return new SqlScriptMetadata(ConfigUtils.loadConfigurationFromReader(resource.read()));
            }
            return new SqlScriptMetadata(ConfigUtils.loadConfigurationFromReader(PlaceholderReplacingReader.create(parser.configuration, parser.parsingContext, resource.read())));
        }
        return new SqlScriptMetadata(new HashMap<String, String>());
    }

    public static LoadableResource getMetadataResource(ResourceProvider resourceProvider, LoadableResource resource) {
        if (resourceProvider == null) {
            return null;
        }
        return resourceProvider.getResource(resource.getRelativePath() + ".conf");
    }
}

