/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation.intellij;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class HashedBlockInputStream
extends InputStream {
    private static MessageDigest md5;
    private static final int HASH_SIZE = 32;
    private static final byte[] ZERO_HASH;
    private long expectedSequenceNumber = 0L;
    private boolean littleEndian = false;
    private boolean done = false;
    private InputStream inputStream;
    private ByteArrayInputStream blockInputStream = new ByteArrayInputStream(new byte[0]);

    public HashedBlockInputStream(InputStream inputStream) {
        this(inputStream, false);
    }

    public HashedBlockInputStream(InputStream inputStream, boolean littleEndian) {
        this.inputStream = inputStream;
        this.littleEndian = littleEndian;
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        return this.get(b, offset, length);
    }

    @Override
    public int read() throws IOException {
        byte[] buffer = new byte[1];
        if (this.get(buffer, 0, 1) != 1) {
            throw new IOException("Could not read int");
        }
        return buffer[0] & 0xFF;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    protected int get(byte[] b, int offset, int length) throws IOException {
        int bytesRead;
        if (this.done) {
            return -1;
        }
        int totalBytesRead = 0;
        while ((bytesRead = this.blockInputStream.read(b, offset, length)) < length && !this.done) {
            if (bytesRead == -1) {
                this.load();
                continue;
            }
            offset += bytesRead;
            length -= bytesRead;
            totalBytesRead += bytesRead;
        }
        return bytesRead > 0 ? totalBytesRead + bytesRead : totalBytesRead;
    }

    protected void load() throws IOException {
        long sequenceNumber = this.readUInt();
        if (sequenceNumber != this.expectedSequenceNumber) {
            throw new IllegalStateException("Expected sequence number " + this.expectedSequenceNumber + " got " + sequenceNumber);
        }
        ++this.expectedSequenceNumber;
        byte[] hash = new byte[32];
        this.readFully(hash);
        long readLength = this.readUInt();
        if (readLength < 0L) {
            throw new IllegalStateException("Got negative length for block");
        }
        if (readLength == 0L) {
            if (!Arrays.equals(hash, ZERO_HASH)) {
                throw new IllegalStateException("Block hash was not zero on final block");
            }
            this.done = true;
            return;
        }
        byte[] readBuffer = new byte[(int)readLength];
        this.readFully(readBuffer);
        md5.update(readBuffer);
        if (!Arrays.equals(md5.digest(), hash)) {
            throw new IllegalStateException("MD5 check failed while reading HashBlock");
        }
        this.blockInputStream = new ByteArrayInputStream(readBuffer);
    }

    private long readUInt() throws IOException {
        byte[] buf = new byte[4];
        this.readFully(buf);
        if (this.littleEndian) {
            return buf[3] << 24 | (buf[2] & 0xFF) << 16 | (buf[1] & 0xFF) << 8 | buf[0] & 0xFF;
        }
        return buf[0] << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF;
    }

    private void readFully(byte[] buffer) throws IOException {
        int bytesToRead = buffer.length;
        int bytesSoFar = 0;
        while (bytesSoFar < buffer.length) {
            int bytesRead = this.inputStream.read(buffer, bytesSoFar, bytesToRead);
            if (bytesRead <= 0) {
                throw new EOFException();
            }
            bytesSoFar += bytesRead;
            bytesToRead -= bytesRead;
        }
    }

    static {
        try {
            md5 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        ZERO_HASH = new byte[32];
    }
}

