/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.bundle.BundleDetails;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.service.ControllerServiceApiLookup;
import org.apache.nifi.flow.ControllerServiceAPI;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.util.BundleUtils;

public class StandardControllerServiceApiLookup
implements ControllerServiceApiLookup {
    private final ExtensionManager extensionManager;

    public StandardControllerServiceApiLookup(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public Map<String, ControllerServiceAPI> getRequiredServiceApis(String type, org.apache.nifi.flow.Bundle bundle) {
        Optional<BundleCoordinate> compatibleBundle = BundleUtils.getOptionalCompatibleBundle(this.extensionManager, type, BundleUtils.createBundleDto(bundle));
        if (!compatibleBundle.isPresent()) {
            return Collections.emptyMap();
        }
        HashMap<String, ControllerServiceAPI> serviceApis = new HashMap<String, ControllerServiceAPI>();
        ConfigurableComponent tempComponent = this.extensionManager.getTempComponent(type, compatibleBundle.get());
        for (PropertyDescriptor descriptor : tempComponent.getPropertyDescriptors()) {
            Class requiredServiceApiClass = descriptor.getControllerServiceDefinition();
            if (requiredServiceApiClass == null) continue;
            ClassLoader serviceApiClassLoader = requiredServiceApiClass.getClassLoader();
            Bundle serviceApiBundle = this.extensionManager.getBundle(serviceApiClassLoader);
            BundleDetails serviceApiBundleDetails = serviceApiBundle.getBundleDetails();
            BundleCoordinate serviceApiBundleCoordinate = serviceApiBundleDetails.getCoordinate();
            ControllerServiceAPI serviceApi = new ControllerServiceAPI();
            serviceApi.setType(requiredServiceApiClass.getCanonicalName());
            serviceApi.setBundle(new org.apache.nifi.flow.Bundle(serviceApiBundleCoordinate.getGroup(), serviceApiBundleCoordinate.getId(), serviceApiBundleCoordinate.getVersion()));
            serviceApis.put(descriptor.getName(), serviceApi);
        }
        return serviceApis;
    }
}

