/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.griffin.engine.functions.constants.CharConstant;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class InCharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "in(Av)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        IntHashSet set = new IntHashSet();
        int n = args.size();
        if (n == 1) {
            return BooleanConstant.FALSE;
        }
        for (int i = 1; i < n; ++i) {
            Function func = args.getQuick(i);
            if (ColumnType.isChar(func.getType())) {
                set.add(func.getChar(null));
                continue;
            }
            if (ColumnType.isString(func.getType())) {
                if (func.getStrLen(null) != 0) {
                    throw SqlException.$(argPositions.getQuick(i), "CHAR constant expected");
                }
                set.add(CharConstant.ZERO.getChar(null));
                continue;
            }
            throw SqlException.$(argPositions.getQuick(i), "CHAR constant expected");
        }
        Function var = args.getQuick(0);
        if (var.isConstant()) {
            return BooleanConstant.of(set.contains(var.getChar(null)));
        }
        return new Func(var, set);
    }

    private static class Func
    extends BooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final IntHashSet set;

        public Func(Function arg, IntHashSet set) {
            this.arg = arg;
            this.set = set;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.set.contains(this.arg.getChar(rec));
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg).val(" in ").val(this.set);
        }
    }
}

