/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Numbers;
import org.jetbrains.annotations.NotNull;

public class StdDevSampleDoubleGroupByFunction
extends DoubleFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    public StdDevSampleDoubleGroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        double d = this.arg.getDouble(record);
        if (Numbers.isFinite(d)) {
            double mean = 0.0;
            double sum = 0.0;
            long count = 1L;
            double oldMean = mean;
            mean += (d - mean) / (double)count;
            mapValue.putDouble(this.valueIndex, mean);
            mapValue.putDouble(this.valueIndex + 1, sum += (d - mean) * (d - oldMean));
            mapValue.putLong(this.valueIndex + 2, 1L);
        } else {
            mapValue.putDouble(this.valueIndex, 0.0);
            mapValue.putDouble(this.valueIndex + 1, 0.0);
            mapValue.putLong(this.valueIndex + 2, 0L);
        }
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        double d = this.arg.getDouble(record);
        if (Numbers.isFinite(d)) {
            double mean = mapValue.getDouble(this.valueIndex);
            double sum = mapValue.getDouble(this.valueIndex + 1);
            long count = mapValue.getLong(this.valueIndex + 2) + 1L;
            double oldMean = mean;
            mean += (d - mean) / (double)count;
            mapValue.putDouble(this.valueIndex, mean);
            mapValue.putDouble(this.valueIndex + 1, sum += (d - mean) * (d - oldMean));
            mapValue.addLong(this.valueIndex + 2, 1L);
        }
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public double getDouble(Record rec) {
        long count = rec.getLong(this.valueIndex + 2);
        if (count - 1L > 0L) {
            double sum = rec.getDouble(this.valueIndex + 1);
            double variance = sum / (double)(count - 1L);
            return Math.sqrt(variance);
        }
        return Double.NaN;
    }

    @Override
    public String getName() {
        return "stddev_samp";
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(10);
        columnTypes.add(10);
        columnTypes.add(6);
    }

    @Override
    public void setDouble(MapValue mapValue, double value) {
        mapValue.putDouble(this.valueIndex, value);
        mapValue.putLong(this.valueIndex + 2, 1L);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putDouble(this.valueIndex, Double.NaN);
        mapValue.putDouble(this.valueIndex + 1, Double.NaN);
        mapValue.putLong(this.valueIndex + 2, 0L);
    }
}

