/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.SymbolMapReaderImpl;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.DataFrameRecordCursor;
import io.questdb.griffin.engine.table.HeapRowCursorFactory;
import io.questdb.griffin.engine.table.SequentialRowCursorFactory;
import io.questdb.griffin.engine.table.SymbolFunctionRowCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexFilteredRowCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexRowCursorFactory;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterOnExcludedValuesRecordCursorFactory
extends AbstractDataFrameRecordCursorFactory {
    private final int columnIndex;
    private final IntList columnIndexes;
    private final DataFrameRecordCursor cursor;
    private final ObjList<SymbolFunctionRowCursorFactory> cursorFactories;
    private final int[] cursorFactoriesIdx;
    private final boolean dynamicExcludedKeys;
    private final IntHashSet excludedKeys = new IntHashSet();
    private final Function filter;
    private final boolean followedOrderByAdvice;
    private final IntHashSet includedKeys = new IntHashSet();
    private final int indexDirection;
    private final ObjList<Function> keyExcludedValueFunctions = new ObjList();
    private final int maxSymbolNotEqualsCount;

    public FilterOnExcludedValuesRecordCursorFactory(@NotNull RecordMetadata metadata, @NotNull DataFrameCursorFactory dataFrameCursorFactory, @NotNull ObjList<Function> keyValues, int columnIndex, @Nullable Function filter, int orderByMnemonic, boolean followedOrderByAdvice, int indexDirection, @NotNull IntList columnIndexes, int maxSymbolNotEqualsCount) {
        super(metadata, dataFrameCursorFactory);
        this.indexDirection = indexDirection;
        this.maxSymbolNotEqualsCount = maxSymbolNotEqualsCount;
        int nKeyValues = keyValues.size();
        boolean dynamicValues = false;
        for (int i = 0; i < nKeyValues; ++i) {
            if (keyValues.getQuick(i).isConstant()) continue;
            dynamicValues = true;
            break;
        }
        this.dynamicExcludedKeys = dynamicValues;
        this.keyExcludedValueFunctions.addAll(keyValues);
        this.columnIndex = columnIndex;
        this.filter = filter;
        this.cursorFactoriesIdx = new int[]{0};
        this.cursorFactories = new ObjList(nKeyValues);
        this.cursor = orderByMnemonic == 2 ? new DataFrameRecordCursor(new SequentialRowCursorFactory(this.cursorFactories, this.cursorFactoriesIdx), false, filter, columnIndexes) : new DataFrameRecordCursor(new HeapRowCursorFactory(this.cursorFactories, this.cursorFactoriesIdx), false, filter, columnIndexes);
        this.followedOrderByAdvice = followedOrderByAdvice;
        this.columnIndexes = columnIndexes;
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.followedOrderByAdvice;
    }

    public void recalculateIncludedValues(TableReader tableReader) {
        this.cursorFactoriesIdx[0] = this.cursorFactories.size();
        this.excludedKeys.clear();
        if (this.dynamicExcludedKeys) {
            this.includedKeys.clear();
            this.cursorFactoriesIdx[0] = 0;
        }
        SymbolMapReaderImpl symbolMapReader = (SymbolMapReaderImpl)tableReader.getSymbolMapReader(this.columnIndex);
        int n = this.keyExcludedValueFunctions.size();
        for (int i = 0; i < n; ++i) {
            CharSequence value = this.keyExcludedValueFunctions.getQuick(i).getStr(null);
            this.excludedKeys.add(symbolMapReader.keyOf(value));
        }
        n = symbolMapReader.getSymbolCount();
        for (int k = 0; k < n; ++k) {
            if (this.excludedKeys.contains(k) || !this.includedKeys.add(k)) continue;
            this.upsertRowCursorFactory(k);
        }
        if (symbolMapReader.containsNullValue() && !this.excludedKeys.contains(Integer.MIN_VALUE) && this.includedKeys.add(Integer.MIN_VALUE)) {
            this.upsertRowCursorFactory(Integer.MIN_VALUE);
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("FilterOnExcludedValues");
        sink.attr("symbolFilter").putColumnName(this.columnIndex).val(" not in ").val(this.keyExcludedValueFunctions);
        sink.optAttr((CharSequence)"filter", this.filter);
        sink.child(this.cursor.getRowCursorFactory());
        sink.child(this.dataFrameCursorFactory);
    }

    private void upsertRowCursorFactory(int symbolKey) {
        if (this.cursorFactoriesIdx[0] < this.cursorFactories.size()) {
            this.cursorFactories.get(this.cursorFactoriesIdx[0]).of(symbolKey);
            this.cursorFactoriesIdx[0] = this.cursorFactoriesIdx[0] + 1;
            return;
        }
        SymbolFunctionRowCursorFactory rowCursorFactory = this.filter == null ? new SymbolIndexRowCursorFactory(this.columnIndex, symbolKey, false, this.indexDirection, null) : new SymbolIndexFilteredRowCursorFactory(this.columnIndex, symbolKey, this.filter, false, this.indexDirection, this.columnIndexes, null);
        this.cursorFactories.add(rowCursorFactory);
        this.cursorFactoriesIdx[0] = this.cursorFactoriesIdx[0] + 1;
    }

    @Override
    protected void _close() {
        super._close();
        Misc.free(this.filter);
        Misc.freeObjList(this.keyExcludedValueFunctions);
    }

    @Override
    protected RecordCursor getCursorInstance(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        TableReader reader = dataFrameCursor.getTableReader();
        if (reader.getSymbolMapReader(this.columnIndex).getSymbolCount() > this.maxSymbolNotEqualsCount) {
            throw TableReferenceOutOfDateException.of(reader.getTableToken().getTableName());
        }
        Function.init(this.keyExcludedValueFunctions, reader, executionContext);
        this.recalculateIncludedValues(reader);
        this.cursor.of(dataFrameCursor, executionContext);
        if (this.filter != null) {
            this.filter.init(this.cursor, executionContext);
        }
        return this.cursor;
    }
}

