/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.network.EpollFacade;
import io.questdb.network.NetworkError;
import io.questdb.network.SuspendEvent;

public class EventFdSuspendEvent
extends SuspendEvent {
    private final EpollFacade epf;
    private final int fd;

    public EventFdSuspendEvent(EpollFacade epf) {
        this.epf = epf;
        int fd = epf.eventFd();
        if (fd < 0) {
            throw NetworkError.instance(epf.errno(), "could not create EventFdSuspendEvent");
        }
        this.fd = fd;
        epf.getNetworkFacade().bumpFdCount(fd);
    }

    @Override
    public void _close() {
        this.epf.getNetworkFacade().close(this.fd);
    }

    @Override
    public boolean checkTriggered() {
        return this.epf.readEventFd(this.fd) == 1L;
    }

    @Override
    public int getFd() {
        return this.fd;
    }

    @Override
    public void trigger() {
        if (this.epf.writeEventFd(this.fd) < 0) {
            throw NetworkError.instance(this.epf.errno()).put("could not write to eventfd [fd=").put(this.fd).put(']');
        }
    }
}

