/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import java.util.ArrayList;
import java.util.List;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.tree.btree.BTreeMutable;
import jetbrains.exodus.tree.btree.BTreeTraverser;
import jetbrains.exodus.tree.btree.BasePage;
import jetbrains.exodus.tree.btree.BasePageMutable;
import jetbrains.exodus.tree.btree.TreePos;
import org.jetbrains.annotations.NotNull;

class BTreeReclaimTraverser
extends BTreeTraverser {
    @NotNull
    protected final BTreeMutable mainTree;
    boolean wasReclaim;
    @NotNull
    final List<RandomAccessLoggable> dupLeafsLo = new ArrayList<RandomAccessLoggable>();
    @NotNull
    final List<RandomAccessLoggable> dupLeafsHi = new ArrayList<RandomAccessLoggable>();

    BTreeReclaimTraverser(@NotNull BTreeMutable mainTree) {
        super(mainTree.getRoot());
        this.mainTree = mainTree;
    }

    protected void setPage(BasePage node) {
        this.currentNode = node;
    }

    void pushChild(int index) {
        this.node = this.pushChild(new TreePos(this.currentNode, index), this.currentNode.getChild(index), 0);
    }

    void popAndMutate() {
        BasePage node = this.currentNode;
        this.moveUp();
        if (node.isMutable()) {
            BasePageMutable nodeMutable = this.currentNode.getMutableCopy(this.mainTree);
            nodeMutable.setMutableChild(this.currentPos, (BasePageMutable)node);
            this.currentNode = nodeMutable;
        }
    }
}

