/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.access.model;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.UUID;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.metamodel.Attribute;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;

public class JPATypeConverter {
    public static EdmSimpleTypeKind convertToEdmSimpleType(Class<?> jpaType, Attribute<?, ?> currentAttribute) throws ODataJPAModelException {
        if (jpaType.equals(String.class) || jpaType.equals(Character.class) || jpaType.equals(Character.TYPE) || jpaType.equals(char[].class) || jpaType.equals(Character[].class)) {
            return EdmSimpleTypeKind.String;
        }
        if (jpaType.equals(Long.class) || jpaType.equals(Long.TYPE)) {
            return EdmSimpleTypeKind.Int64;
        }
        if (jpaType.equals(Short.class) || jpaType.equals(Short.TYPE)) {
            return EdmSimpleTypeKind.Int16;
        }
        if (jpaType.equals(Integer.class) || jpaType.equals(Integer.TYPE)) {
            return EdmSimpleTypeKind.Int32;
        }
        if (jpaType.equals(Double.class) || jpaType.equals(Double.TYPE)) {
            return EdmSimpleTypeKind.Double;
        }
        if (jpaType.equals(Float.class) || jpaType.equals(Float.TYPE)) {
            return EdmSimpleTypeKind.Single;
        }
        if (jpaType.equals(BigDecimal.class)) {
            return EdmSimpleTypeKind.Decimal;
        }
        if (jpaType.equals(byte[].class)) {
            return EdmSimpleTypeKind.Binary;
        }
        if (jpaType.equals(Byte.class) || jpaType.equals(Byte.TYPE)) {
            return EdmSimpleTypeKind.Byte;
        }
        if (jpaType.equals(Boolean.class) || jpaType.equals(Boolean.TYPE)) {
            return EdmSimpleTypeKind.Boolean;
        }
        if (jpaType.equals(Time.class)) {
            return EdmSimpleTypeKind.Time;
        }
        if (jpaType.equals(Date.class) || jpaType.equals(Calendar.class) || jpaType.equals(Timestamp.class) || jpaType.equals(java.util.Date.class)) {
            try {
                if (currentAttribute != null && JPATypeConverter.determineTemporalType(currentAttribute) == TemporalType.TIME) {
                    return EdmSimpleTypeKind.Time;
                }
                return EdmSimpleTypeKind.DateTime;
            }
            catch (SecurityException e) {
                throw ODataJPAModelException.throwException((MessageReference)ODataJPAModelException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
            }
        }
        if (jpaType.equals(UUID.class)) {
            return EdmSimpleTypeKind.Guid;
        }
        if (jpaType.equals(Byte[].class)) {
            return EdmSimpleTypeKind.Binary;
        }
        if (jpaType.equals(Blob.class) && JPATypeConverter.isBlob(currentAttribute)) {
            return EdmSimpleTypeKind.Binary;
        }
        if (jpaType.equals(Clob.class) && JPATypeConverter.isBlob(currentAttribute)) {
            return EdmSimpleTypeKind.String;
        }
        if (jpaType.isEnum()) {
            return EdmSimpleTypeKind.String;
        }
        if (currentAttribute == null) {
            throw ODataJPAModelException.throwException((MessageReference)ODataJPAModelException.TYPE_NOT_SUPPORTED.addContent(new Object[]{jpaType.toString()}), null);
        }
        String propertyName = currentAttribute.getName();
        if (propertyName == null) {
            throw ODataJPAModelException.throwException((MessageReference)ODataJPAModelException.TYPE_NOT_SUPPORTED.addContent(new Object[]{jpaType.toString()}), null);
        }
        String getterName = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        try {
            Method method = currentAttribute.getDeclaringType().getJavaType().getMethod(getterName, new Class[0]);
            XmlJavaTypeAdapter xmlAdapterAnnotation = method.getAnnotation(XmlJavaTypeAdapter.class);
            if (xmlAdapterAnnotation == null) {
                throw ODataJPAModelException.throwException((MessageReference)ODataJPAModelException.TYPE_NOT_SUPPORTED.addContent(new Object[]{jpaType.toString()}), null);
            }
            Class xmlAdapterClass = xmlAdapterAnnotation.value();
            ParameterizedType genericSuperClass = (ParameterizedType)xmlAdapterClass.getGenericSuperclass();
            Class converterTargetType = (Class)genericSuperClass.getActualTypeArguments()[0];
            return JPATypeConverter.convertToEdmSimpleType(converterTargetType, currentAttribute);
        }
        catch (NoSuchMethodException e) {
            throw ODataJPAModelException.throwException((MessageReference)ODataJPAModelException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (SecurityException e) {
            throw ODataJPAModelException.throwException((MessageReference)ODataJPAModelException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    private static boolean isBlob(Attribute<?, ?> currentAttribute) {
        AnnotatedElement annotatedElement;
        return currentAttribute != null && (annotatedElement = (AnnotatedElement)((Object)currentAttribute.getJavaMember())) != null && annotatedElement.getAnnotation(Lob.class) != null;
    }

    private static TemporalType determineTemporalType(Attribute<?, ?> currentAttribute) throws ODataJPAModelException {
        AnnotatedElement annotatedElement;
        if (currentAttribute != null && (annotatedElement = (AnnotatedElement)((Object)currentAttribute.getJavaMember())) != null && annotatedElement.getAnnotation(Temporal.class) != null) {
            return annotatedElement.getAnnotation(Temporal.class).value();
        }
        return null;
    }
}

