/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.access.data;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TemporalType;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.api.uri.info.DeleteUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityUriInfo;
import org.apache.olingo.odata2.api.uri.info.PutMergePatchUriInfo;
import org.apache.olingo.odata2.core.uri.UriInfoImpl;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAContext;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAQueryExtensionEntityListener;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPATombstoneEntityListener;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContext;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextType;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextView;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLJoinContextView;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLJoinSelectSingleContextView;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLSelectContextView;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLSelectSingleContextView;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLStatement;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmMapping;
import org.apache.olingo.odata2.jpa.processor.core.ODataExpressionParser;

public class JPAQueryBuilder {
    private EntityManager em = null;
    private int pageSize = 0;
    private static final Pattern NORMALIZATION_NEEDED_PATTERN = Pattern.compile(".*[\\s(](\\S+\\.\\S+\\.\\S+).*");
    private static final Pattern VALUE_NORM_PATTERN = Pattern.compile("(?:^|\\s|\\()'(([^']*)')");
    private static final Pattern JOIN_ALIAS_PATTERN = Pattern.compile(".*\\sJOIN\\s(\\S*\\s\\S*).*");

    public JPAQueryBuilder(ODataJPAContext odataJPAContext) {
        this.em = odataJPAContext.getEntityManager();
        this.pageSize = odataJPAContext.getPageSize();
    }

    public JPAQueryInfo build(GetEntitySetUriInfo uriInfo) throws ODataJPARuntimeException {
        JPAQueryInfo queryInfo = new JPAQueryInfo();
        Query query = null;
        try {
            ODataJPATombstoneEntityListener listener = this.getODataJPATombstoneEntityListener((UriInfo)uriInfo);
            if (listener != null) {
                query = listener.getQuery(uriInfo, this.em);
                JPQLContext jpqlContext = JPQLContext.getJPQLContext();
                query = this.getParameterizedQueryForListeners(jpqlContext, query);
            }
            if (query == null) {
                query = this.buildQuery((UriInfo)uriInfo, UriInfoType.GetEntitySet);
            } else {
                queryInfo.setTombstoneQuery(true);
            }
        }
        catch (Exception e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPQL_QUERY_CREATE, (Throwable)e);
        }
        finally {
            JPQLContext.removeJPQLContext();
            ODataExpressionParser.removePositionalParametersThreadLocal();
        }
        queryInfo.setQuery(query);
        return queryInfo;
    }

    public void getCount(GetEntitySetUriInfo uriInfo) throws ODataJPARuntimeException {
        JPAQueryInfo queryInfo = new JPAQueryInfo();
        Query query = null;
        UriInfoImpl info = (UriInfoImpl)uriInfo;
        boolean count = info.isCount();
        info.setCount(true);
        try {
            ODataJPAQueryExtensionEntityListener listener = this.getODataJPAQueryEntityListener((UriInfo)uriInfo);
            if (listener != null && (query = listener.getQuery((GetEntitySetCountUriInfo)uriInfo, this.em)) != null) {
                JPQLContextType contextType = this.determineJPQLContextType((UriInfo)info, UriInfoType.GetEntitySetCount);
                JPQLContext jpqlContext = this.buildJPQLContext(contextType, (UriInfo)info);
                JPQLStatement jpqlStatement = JPQLStatement.createBuilder((JPQLContextView)jpqlContext).build();
                jpqlContext.setJPQLStatement(jpqlStatement.toString());
                query = this.getParameterizedQueryForListeners(jpqlContext, query);
            }
            if (query == null) {
                query = this.buildQuery((UriInfo)uriInfo, UriInfoType.GetEntitySetCount);
            } else {
                queryInfo.setTombstoneQuery(true);
            }
        }
        catch (Exception e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPQL_QUERY_CREATE, (Throwable)e);
        }
        finally {
            JPQLContext.removeJPQLContext();
            ODataExpressionParser.removePositionalParametersThreadLocal();
        }
        queryInfo.setQuery(query);
        Query countQuery = queryInfo.getQuery();
        List countList = countQuery.getResultList();
        info.setCount(count);
        if (countList != null && !countList.isEmpty()) {
            String countNumber = countList.get(0).toString();
            HashMap<String, String> customQueryOptions = new HashMap<String, String>();
            customQueryOptions.put("count", countNumber);
            info.setCustomQueryOptions(customQueryOptions);
        }
    }

    public Query build(GetEntityUriInfo uriInfo) throws ODataJPARuntimeException {
        Query query = null;
        try {
            ODataJPAQueryExtensionEntityListener listener = this.getODataJPAQueryEntityListener((UriInfo)uriInfo);
            if (listener != null) {
                query = listener.getQuery(uriInfo, this.em);
                JPQLContext jpqlContext = JPQLContext.getJPQLContext();
                query = this.getParameterizedQueryForListeners(jpqlContext, query);
            }
            if (query == null) {
                query = this.buildQuery((UriInfo)uriInfo, UriInfoType.GetEntity);
            }
        }
        catch (Exception e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPQL_QUERY_CREATE, (Throwable)e);
        }
        finally {
            JPQLContext.removeJPQLContext();
            ODataExpressionParser.removePositionalParametersThreadLocal();
        }
        return query;
    }

    public Query build(GetEntitySetCountUriInfo uriInfo) throws ODataJPARuntimeException {
        Query query = null;
        try {
            ODataJPAQueryExtensionEntityListener listener = this.getODataJPAQueryEntityListener((UriInfo)uriInfo);
            if (listener != null) {
                query = listener.getQuery(uriInfo, this.em);
                JPQLContext jpqlContext = JPQLContext.getJPQLContext();
                query = this.getParameterizedQueryForListeners(jpqlContext, query);
            }
            if (query == null) {
                query = this.buildQuery((UriInfo)uriInfo, UriInfoType.GetEntitySetCount);
            }
        }
        catch (Exception e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPQL_QUERY_CREATE, (Throwable)e);
        }
        finally {
            JPQLContext.removeJPQLContext();
            ODataExpressionParser.removePositionalParametersThreadLocal();
        }
        return query;
    }

    public Query build(GetEntityCountUriInfo uriInfo) throws ODataJPARuntimeException {
        Query query = null;
        try {
            ODataJPAQueryExtensionEntityListener listener = this.getODataJPAQueryEntityListener((UriInfo)uriInfo);
            if (listener != null) {
                query = listener.getQuery(uriInfo, this.em);
                JPQLContext jpqlContext = JPQLContext.getJPQLContext();
                query = this.getParameterizedQueryForListeners(jpqlContext, query);
            }
            if (query == null) {
                query = this.buildQuery((UriInfo)uriInfo, UriInfoType.GetEntityCount);
            }
        }
        catch (Exception e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPQL_QUERY_CREATE, (Throwable)e);
        }
        finally {
            JPQLContext.removeJPQLContext();
            ODataExpressionParser.removePositionalParametersThreadLocal();
        }
        return query;
    }

    public Query build(DeleteUriInfo uriInfo) throws ODataJPARuntimeException {
        Query query = null;
        try {
            ODataJPAQueryExtensionEntityListener listener = this.getODataJPAQueryEntityListener((UriInfo)uriInfo);
            if (listener != null) {
                query = listener.getQuery(uriInfo, this.em);
                JPQLContext jpqlContext = JPQLContext.getJPQLContext();
                query = this.getParameterizedQueryForListeners(jpqlContext, query);
            }
            if (query == null) {
                query = this.buildQuery((UriInfo)uriInfo, UriInfoType.Delete);
            }
        }
        catch (Exception e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPQL_QUERY_CREATE, (Throwable)e);
        }
        finally {
            JPQLContext.removeJPQLContext();
            ODataExpressionParser.removePositionalParametersThreadLocal();
        }
        return query;
    }

    public Query build(PutMergePatchUriInfo uriInfo) throws ODataJPARuntimeException {
        Query query = null;
        try {
            ODataJPAQueryExtensionEntityListener listener = this.getODataJPAQueryEntityListener((UriInfo)uriInfo);
            if (listener != null) {
                query = listener.getQuery(uriInfo, this.em);
                JPQLContext jpqlContext = JPQLContext.getJPQLContext();
                query = this.getParameterizedQueryForListeners(jpqlContext, query);
            }
            if (query == null) {
                query = this.buildQuery((UriInfo)uriInfo, UriInfoType.PutMergePatch);
            }
        }
        catch (Exception e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPQL_QUERY_CREATE, (Throwable)e);
        }
        finally {
            JPQLContext.removeJPQLContext();
            ODataExpressionParser.removePositionalParametersThreadLocal();
        }
        return query;
    }

    private Query buildQuery(UriInfo uriParserResultView, UriInfoType type) throws EdmException, ODataJPAModelException, ODataJPARuntimeException {
        JPQLContextType contextType = this.determineJPQLContextType(uriParserResultView, type);
        JPQLContext jpqlContext = this.buildJPQLContext(contextType, uriParserResultView);
        JPQLStatement jpqlStatement = JPQLStatement.createBuilder((JPQLContextView)jpqlContext).build();
        Query query = this.em.createQuery(JPAQueryBuilder.normalizeMembers(this.em, jpqlStatement.toString()));
        this.getParameterizedQuery(contextType, jpqlContext, jpqlStatement, query);
        return query;
    }

    private Query getParameterizedQuery(JPQLContextType contextType, JPQLContext jpqlContext, JPQLStatement jpqlStatement, Query query) {
        Map parameterizedMap = null;
        if (contextType == JPQLContextType.JOIN || contextType == JPQLContextType.JOIN_COUNT) {
            parameterizedMap = ((JPQLJoinContextView)jpqlContext).getParameterizedQueryMap();
        } else if (contextType == JPQLContextType.JOIN_SINGLE) {
            parameterizedMap = ((JPQLJoinSelectSingleContextView)jpqlContext).getParameterizedQueryMap();
        } else if (contextType == JPQLContextType.SELECT || contextType == JPQLContextType.SELECT_COUNT) {
            parameterizedMap = ((JPQLSelectContextView)jpqlContext).getParameterizedQueryMap();
        } else if (contextType == JPQLContextType.SELECT_SINGLE) {
            parameterizedMap = ((JPQLSelectSingleContextView)jpqlContext).getParameterizedQueryMap();
        }
        if (parameterizedMap != null && parameterizedMap.size() > 0) {
            for (Map.Entry parameterEntry : parameterizedMap.entrySet()) {
                if (!jpqlStatement.toString().contains((CharSequence)parameterEntry.getKey())) continue;
                Map positionalParameters = (Map)parameterEntry.getValue();
                for (Map.Entry param : positionalParameters.entrySet()) {
                    if (param.getValue() instanceof Calendar || param.getValue() instanceof Timestamp) {
                        query.setParameter(((Integer)param.getKey()).intValue(), (Calendar)param.getValue(), TemporalType.TIMESTAMP);
                        continue;
                    }
                    if (param.getValue() instanceof Time) {
                        query.setParameter(((Integer)param.getKey()).intValue(), (Date)((Time)param.getValue()), TemporalType.TIME);
                        continue;
                    }
                    query.setParameter(((Integer)param.getKey()).intValue(), param.getValue());
                }
            }
        }
        return query;
    }

    private Query getParameterizedQueryForListeners(JPQLContext jpqlContext, Query query) {
        Map parameterizedMap = null;
        String jpqlStatement = null;
        if (jpqlContext instanceof JPQLJoinContextView) {
            parameterizedMap = ((JPQLJoinContextView)jpqlContext).getParameterizedQueryMap();
            jpqlStatement = ((JPQLJoinContextView)jpqlContext).getJPQLStatement();
        } else if (jpqlContext instanceof JPQLJoinSelectSingleContextView) {
            parameterizedMap = ((JPQLJoinSelectSingleContextView)jpqlContext).getParameterizedQueryMap();
            jpqlStatement = ((JPQLJoinSelectSingleContextView)jpqlContext).getJPQLStatement();
        } else if (jpqlContext instanceof JPQLSelectContextView) {
            parameterizedMap = ((JPQLSelectContextView)jpqlContext).getParameterizedQueryMap();
            jpqlStatement = ((JPQLSelectContextView)jpqlContext).getJPQLStatement();
        } else if (jpqlContext instanceof JPQLSelectSingleContextView) {
            parameterizedMap = ((JPQLSelectSingleContextView)jpqlContext).getParameterizedQueryMap();
            jpqlStatement = ((JPQLSelectSingleContextView)jpqlContext).getJPQLStatement();
        }
        if (parameterizedMap != null && parameterizedMap.size() > 0) {
            for (Map.Entry parameterEntry : parameterizedMap.entrySet()) {
                if (!jpqlStatement.contains((CharSequence)parameterEntry.getKey())) continue;
                Map positionalParameters = (Map)parameterEntry.getValue();
                for (Map.Entry param : positionalParameters.entrySet()) {
                    if (param.getValue() instanceof Calendar || param.getValue() instanceof Timestamp) {
                        query.setParameter(((Integer)param.getKey()).intValue(), (Calendar)param.getValue(), TemporalType.TIMESTAMP);
                        continue;
                    }
                    if (param.getValue() instanceof Time) {
                        query.setParameter(((Integer)param.getKey()).intValue(), (Date)((Time)param.getValue()), TemporalType.TIME);
                        continue;
                    }
                    query.setParameter(((Integer)param.getKey()).intValue(), param.getValue());
                }
            }
        }
        return query;
    }

    public ODataJPAQueryExtensionEntityListener getODataJPAQueryEntityListener(UriInfo uriInfo) throws EdmException, InstantiationException, IllegalAccessException {
        ODataJPAQueryExtensionEntityListener queryListener = null;
        ODataJPATombstoneEntityListener listener = this.getODataJPATombstoneEntityListener(uriInfo);
        if (listener instanceof ODataJPAQueryExtensionEntityListener) {
            queryListener = (ODataJPAQueryExtensionEntityListener)listener;
        }
        return queryListener;
    }

    public ODataJPATombstoneEntityListener getODataJPATombstoneEntityListener(UriInfo uriParserResultView) throws InstantiationException, IllegalAccessException, EdmException {
        JPAEdmMapping mapping = (JPAEdmMapping)uriParserResultView.getTargetEntitySet().getEntityType().getMapping();
        if (null != mapping && mapping.getODataJPATombstoneEntityListener() != null) {
            return (ODataJPATombstoneEntityListener)mapping.getODataJPATombstoneEntityListener().newInstance();
        }
        return null;
    }

    public JPQLContext buildJPQLContext(JPQLContextType contextType, UriInfo uriParserResultView) throws ODataJPAModelException, ODataJPARuntimeException {
        if (this.pageSize > 0 && (contextType == JPQLContextType.SELECT || contextType == JPQLContextType.JOIN)) {
            return JPQLContext.createBuilder((JPQLContextType)contextType, (Object)uriParserResultView, (boolean)true).build();
        }
        return JPQLContext.createBuilder((JPQLContextType)contextType, (Object)uriParserResultView).build();
    }

    public JPQLContextType determineJPQLContextType(UriInfo uriParserResultView, UriInfoType type) {
        JPQLContextType contextType = null;
        if (uriParserResultView.getNavigationSegments() != null && !uriParserResultView.getNavigationSegments().isEmpty()) {
            if (type == UriInfoType.GetEntitySet) {
                contextType = JPQLContextType.JOIN;
            } else if (type == UriInfoType.Delete || type == UriInfoType.GetEntity || type == UriInfoType.PutMergePatch) {
                contextType = JPQLContextType.JOIN_SINGLE;
            } else if (type == UriInfoType.GetEntitySetCount || type == UriInfoType.GetEntityCount) {
                contextType = JPQLContextType.JOIN_COUNT;
            }
        } else if (type == UriInfoType.GetEntitySet) {
            contextType = JPQLContextType.SELECT;
        } else if (type == UriInfoType.Delete || type == UriInfoType.GetEntity || type == UriInfoType.PutMergePatch) {
            contextType = JPQLContextType.SELECT_SINGLE;
        } else if (type == UriInfoType.GetEntitySetCount || type == UriInfoType.GetEntityCount) {
            contextType = JPQLContextType.SELECT_COUNT;
        }
        return contextType;
    }

    private static String normalizeMembers(EntityManager em, String jpqlQuery) {
        String query = JPAQueryBuilder.checkConditionValues(jpqlQuery);
        query = JPAQueryBuilder.removeExtraClause(jpqlQuery);
        Matcher normalizationNeededMatcher = NORMALIZATION_NEEDED_PATTERN.matcher(query);
        if (!normalizationNeededMatcher.find()) {
            return jpqlQuery;
        }
        if (JPAQueryBuilder.containsEmbeddedAttributes(em, jpqlQuery)) {
            return jpqlQuery;
        }
        Object normalizedJpqlQuery = jpqlQuery;
        HashMap<String, Object> joinAliases = new HashMap<String, Object>();
        Matcher joinAliasMatcher = JOIN_ALIAS_PATTERN.matcher((CharSequence)normalizedJpqlQuery);
        if (joinAliasMatcher.find()) {
            for (int i = 1; i <= joinAliasMatcher.groupCount(); ++i) {
                String[] joinAlias = joinAliasMatcher.group(i).split(String.valueOf(' '));
                joinAliases.put(joinAlias[0], joinAlias[1]);
            }
        }
        boolean normalizationNeeded = true;
        while (normalizationNeeded) {
            Object alias;
            String membershipToNormalize = normalizationNeededMatcher.group(1);
            String memberInfo = membershipToNormalize.substring(0, JPAQueryBuilder.ordinalIndexOf(membershipToNormalize, '.', 1));
            if (joinAliases.containsKey(memberInfo)) {
                alias = (String)joinAliases.get(memberInfo);
            } else {
                alias = "R" + (joinAliases.size() + 1);
                int joinInsertPosition = ((String)normalizedJpqlQuery).indexOf("WHERE");
                if (joinInsertPosition == -1) {
                    joinInsertPosition = ((String)normalizedJpqlQuery).indexOf("ORDER BY");
                }
                normalizedJpqlQuery = ((String)normalizedJpqlQuery).substring(0, joinInsertPosition) + "JOIN " + memberInfo + " " + (String)alias + " " + ((String)normalizedJpqlQuery).substring(joinInsertPosition);
                joinAliases.put(memberInfo, alias);
            }
            normalizedJpqlQuery = ((String)normalizedJpqlQuery).replaceAll(memberInfo + "\\.", (String)alias + ".");
            query = JPAQueryBuilder.checkConditionValues((String)normalizedJpqlQuery);
            query = JPAQueryBuilder.removeExtraClause((String)normalizedJpqlQuery);
            normalizationNeededMatcher = NORMALIZATION_NEEDED_PATTERN.matcher(query);
            normalizationNeeded = normalizationNeededMatcher.find();
        }
        return ((String)normalizedJpqlQuery).replaceFirst("SELECT ", "SELECT DISTINCT ");
    }

    private static String removeExtraClause(String jpqlQuery) {
        String query = jpqlQuery;
        if (query.contains("ORDER BY")) {
            int index = query.indexOf("ORDER BY");
            query = query.substring(0, index);
        }
        return query;
    }

    private static String checkConditionValues(String jpqlQuery) {
        int i = 0;
        StringBuffer query = new StringBuffer();
        query.append(jpqlQuery);
        Matcher valueMatcher = VALUE_NORM_PATTERN.matcher(query);
        while (valueMatcher.find()) {
            String val = valueMatcher.group();
            int index = query.indexOf(val);
            String var = "[" + ++i + "] ";
            query.replace(index, index + val.length(), var);
            valueMatcher = VALUE_NORM_PATTERN.matcher(query);
        }
        return query.toString();
    }

    private static boolean containsEmbeddedAttributes(EntityManager em, String jpqlQuery) {
        Set types = em.getMetamodel().getEntities();
        int pos = jpqlQuery.indexOf("FROM ") + 5;
        int lastpos = jpqlQuery.indexOf(" ", pos);
        String queriedEntity = jpqlQuery.substring(pos, lastpos);
        for (EntityType type : types) {
            if (!queriedEntity.equals(type.getName())) continue;
            Set attributes = type.getAttributes();
            for (Attribute attribute : attributes) {
                if (!jpqlQuery.contains(attribute.getName()) || attribute.getPersistentAttributeType() != Attribute.PersistentAttributeType.EMBEDDED) continue;
                return true;
            }
        }
        return false;
    }

    private static int ordinalIndexOf(String str, char s, int n) {
        int pos = str.indexOf(s, 0);
        while (n-- > 0 && pos != -1) {
            pos = str.indexOf(s, pos + 1);
        }
        return pos;
    }

    final class JPAQueryInfo {
        private Query query = null;
        private boolean isTombstoneQuery = false;

        JPAQueryInfo() {
        }

        public Query getQuery() {
            return this.query;
        }

        public void setQuery(Query query) {
            this.query = query;
        }

        public boolean isTombstoneQuery() {
            return this.isTombstoneQuery;
        }

        public void setTombstoneQuery(boolean isTombstoneQuery) {
            this.isTombstoneQuery = isTombstoneQuery;
        }
    }

    static enum UriInfoType {
        GetEntitySet,
        GetEntity,
        GetEntitySetCount,
        GetEntityCount,
        PutMergePatch,
        Delete;

    }
}

