/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.olingo.client.api.communication.request.retrieve.ODataPropertyRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.domain.ClientComplexValue;
import org.apache.olingo.client.api.domain.ClientLinked;
import org.apache.olingo.client.api.domain.ClientProperty;
import org.apache.olingo.client.api.uri.URIBuilder;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.api.annotations.ComplexType;
import org.apache.olingo.ext.proxy.api.annotations.NavigationProperty;
import org.apache.olingo.ext.proxy.commons.AbstractStructuredInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.utils.ClassUtils;

public class ComplexInvocationHandler
extends AbstractStructuredInvocationHandler {
    private static Pair<ClientComplexValue, Class<?>> init(Class<?> typeRef, AbstractService<?> service) {
        Class<?> complexTypeRef = Collection.class.isAssignableFrom(typeRef) ? ClassUtils.extractTypeArg(typeRef, new Class[0]) : typeRef;
        ComplexType annotation = complexTypeRef.getAnnotation(ComplexType.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Invalid complex type " + complexTypeRef);
        }
        FullQualifiedName typeName = new FullQualifiedName(ClassUtils.getNamespace(complexTypeRef), annotation.name());
        ClientComplexValue complex = service.getClient().getObjectFactory().newComplexValue(typeName.toString());
        return new ImmutablePair(complex, complexTypeRef);
    }

    public static ComplexInvocationHandler getInstance(EntityInvocationHandler handler, Class<?> typeRef) {
        Pair<ClientComplexValue, Class<?>> init = ComplexInvocationHandler.init(typeRef, handler.service);
        return new ComplexInvocationHandler(init.getLeft(), init.getRight(), handler);
    }

    public static ComplexInvocationHandler getInstance(ClientComplexValue complex, Class<?> typeRef, AbstractService<?> service) {
        return new ComplexInvocationHandler(complex, typeRef, service);
    }

    public static ComplexInvocationHandler getInstance(Class<?> typeRef, AbstractService<?> service) {
        Pair<ClientComplexValue, Class<?>> init = ComplexInvocationHandler.init(typeRef, service);
        return new ComplexInvocationHandler(init.getLeft(), init.getRight(), service);
    }

    public static ComplexInvocationHandler getInstance(Class<?> typeRef, AbstractService<?> service, URIBuilder uri) {
        Pair<ClientComplexValue, Class<?>> init = ComplexInvocationHandler.init(typeRef, service);
        return new ComplexInvocationHandler(init.getLeft(), init.getRight(), service, uri);
    }

    public static ComplexInvocationHandler getInstance(ClientComplexValue complex, Class<?> typeRef, AbstractService<?> service, URIBuilder uri) {
        return new ComplexInvocationHandler(complex, typeRef, service, uri);
    }

    private ComplexInvocationHandler(ClientComplexValue complex, Class<?> typeRef, AbstractService<?> service, URIBuilder uri) {
        super(typeRef, (Object)complex, service);
        this.uri = uri;
        this.baseURI = this.uri == null ? null : this.uri.build();
    }

    private ComplexInvocationHandler(ClientComplexValue complex, Class<?> typeRef, EntityInvocationHandler handler) {
        super(typeRef, (Object)complex, handler);
        this.uri = null;
    }

    private ComplexInvocationHandler(ClientComplexValue complex, Class<?> typeRef, AbstractService<?> service) {
        super(typeRef, (Object)complex, service);
        this.uri = null;
    }

    public ClientComplexValue getComplex() {
        return (ClientComplexValue)this.internal;
    }

    @Override
    protected Object getNavigationPropertyValue(NavigationProperty property, Method getter) {
        if (!(this.internal instanceof ClientLinked)) {
            throw new UnsupportedOperationException("Internal object is not navigable");
        }
        return this.retrieveNavigationProperty(property, getter);
    }

    @Override
    protected void load() {
        try {
            if (this.uri != null) {
                ODataPropertyRequest<ClientProperty> req = this.getClient().getRetrieveRequestFactory().getPropertyRequest(this.uri.build());
                ODataRetrieveResponse res = (ODataRetrieveResponse)req.execute();
                this.internal = ((ClientProperty)res.getBody()).getValue();
            }
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Complex at '" + this.uri + "' not found", e);
            throw e;
        }
        catch (Exception e) {
            LOG.warn("Error retrieving complex '" + this.uri + "'", e);
            throw new IllegalArgumentException("Error retrieving " + this.typeRef.getSimpleName(), e);
        }
    }

    protected List<ClientProperty> getInternalProperties() {
        ArrayList<ClientProperty> res = new ArrayList<ClientProperty>();
        if (this.getComplex() != null) {
            for (ClientProperty property : this.getComplex()) {
                res.add(property);
            }
        }
        return res;
    }

    @Override
    protected ClientProperty getInternalProperty(String name) {
        return this.getComplex() == null ? null : this.getComplex().get(name);
    }
}

