/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.edm.geo.Polygon;
import org.apache.olingo.commons.core.edm.primitivetype.AbstractGeospatialType;

public final class EdmGeographyPolygon
extends AbstractGeospatialType<Polygon> {
    private static final EdmGeographyPolygon INSTANCE = new EdmGeographyPolygon();

    public static EdmGeographyPolygon getInstance() {
        return INSTANCE;
    }

    public EdmGeographyPolygon() {
        super(Polygon.class, Geospatial.Dimension.GEOGRAPHY, Geospatial.Type.POLYGON);
    }

    @Override
    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        Polygon polygon = this.stringToPolygon(value, isNullable, maxLength, precision, scale, isUnicode);
        if (returnType.isAssignableFrom(Polygon.class)) {
            return returnType.cast(polygon);
        }
        throw new EdmPrimitiveTypeException("The value type " + returnType + " is not supported.");
    }

    @Override
    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (value instanceof Polygon) {
            return this.toString((Polygon)value, isNullable, maxLength, precision, scale, isUnicode);
        }
        throw new EdmPrimitiveTypeException("The value type " + value.getClass() + " is not supported.");
    }
}

