/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.cud;

import java.io.InputStream;
import java.net.URI;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.cud.CUDRequestFactory;
import org.apache.olingo.client.api.communication.request.cud.ODataDeleteRequest;
import org.apache.olingo.client.api.communication.request.cud.ODataEntityCreateRequest;
import org.apache.olingo.client.api.communication.request.cud.ODataEntityUpdateRequest;
import org.apache.olingo.client.api.communication.request.cud.ODataPropertyUpdateRequest;
import org.apache.olingo.client.api.communication.request.cud.ODataReferenceAddingRequest;
import org.apache.olingo.client.api.communication.request.cud.ODataValueUpdateRequest;
import org.apache.olingo.client.api.communication.request.cud.UpdateType;
import org.apache.olingo.client.api.communication.request.streamed.ODataMediaEntityCreateRequest;
import org.apache.olingo.client.api.communication.request.streamed.ODataMediaEntityUpdateRequest;
import org.apache.olingo.client.api.communication.request.streamed.ODataStreamUpdateRequest;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientPrimitiveValue;
import org.apache.olingo.client.api.domain.ClientProperty;
import org.apache.olingo.client.api.domain.ClientSingleton;
import org.apache.olingo.client.core.communication.request.cud.ODataDeleteRequestImpl;
import org.apache.olingo.client.core.communication.request.cud.ODataEntityCreateRequestImpl;
import org.apache.olingo.client.core.communication.request.cud.ODataEntityUpdateRequestImpl;
import org.apache.olingo.client.core.communication.request.cud.ODataPropertyUpdateRequestImpl;
import org.apache.olingo.client.core.communication.request.cud.ODataReferenceAddingRequestImpl;
import org.apache.olingo.client.core.communication.request.cud.ODataValueUpdateRequestImpl;
import org.apache.olingo.client.core.communication.request.streamed.ODataMediaEntityCreateRequestImpl;
import org.apache.olingo.client.core.communication.request.streamed.ODataMediaEntityUpdateRequestImpl;
import org.apache.olingo.client.core.communication.request.streamed.ODataStreamUpdateRequestImpl;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.http.HttpMethod;

public class CUDRequestFactoryImpl
implements CUDRequestFactory {
    protected final ODataClient client;

    public CUDRequestFactoryImpl(ODataClient client) {
        this.client = client;
    }

    @Override
    public <E extends ClientEntity> ODataEntityCreateRequest<E> getEntityCreateRequest(URI targetURI, E entity) {
        return new ODataEntityCreateRequestImpl<E>(this.client, targetURI, entity);
    }

    @Override
    public <E extends ClientEntity> ODataEntityUpdateRequest<E> getEntityUpdateRequest(URI targetURI, UpdateType type, E changes) {
        ODataEntityUpdateRequestImpl<E> req;
        if (this.client.getConfiguration().isUseXHTTPMethod()) {
            req = new ODataEntityUpdateRequestImpl<E>(this.client, HttpMethod.POST, targetURI, changes);
            req.setXHTTPMethod(type.getMethod().name());
        } else {
            req = new ODataEntityUpdateRequestImpl<E>(this.client, type.getMethod(), targetURI, changes);
        }
        return req;
    }

    @Override
    public <E extends ClientEntity> ODataEntityUpdateRequest<E> getEntityUpdateRequest(UpdateType type, E entity) {
        ODataEntityUpdateRequestImpl<E> req;
        if (entity.getEditLink() == null) {
            throw new IllegalArgumentException("No edit link found");
        }
        if (this.client.getConfiguration().isUseXHTTPMethod()) {
            req = new ODataEntityUpdateRequestImpl<E>(this.client, HttpMethod.POST, entity.getEditLink(), entity);
            req.setXHTTPMethod(type.getMethod().name());
        } else {
            req = new ODataEntityUpdateRequestImpl<E>(this.client, type.getMethod(), entity.getEditLink(), entity);
        }
        return req;
    }

    @Override
    public ODataValueUpdateRequest getValueUpdateRequest(URI targetURI, UpdateType type, ClientPrimitiveValue value) {
        ODataValueUpdateRequestImpl req;
        if (this.client.getConfiguration().isUseXHTTPMethod()) {
            req = new ODataValueUpdateRequestImpl(this.client, HttpMethod.POST, URIUtils.addValueSegment(targetURI), value);
            req.setXHTTPMethod(type.getMethod().name());
        } else {
            req = new ODataValueUpdateRequestImpl(this.client, type.getMethod(), URIUtils.addValueSegment(targetURI), value);
        }
        return req;
    }

    @Override
    public ODataPropertyUpdateRequest getPropertyPrimitiveValueUpdateRequest(URI targetURI, ClientProperty property) {
        ODataPropertyUpdateRequestImpl req;
        if (!property.hasPrimitiveValue()) {
            throw new IllegalArgumentException("A primitive value is required");
        }
        if (this.client.getConfiguration().isUseXHTTPMethod()) {
            req = new ODataPropertyUpdateRequestImpl(this.client, HttpMethod.POST, targetURI, property);
            req.setXHTTPMethod(HttpMethod.PUT.name());
        } else {
            req = new ODataPropertyUpdateRequestImpl(this.client, HttpMethod.PUT, targetURI, property);
        }
        return req;
    }

    @Override
    public ODataPropertyUpdateRequest getPropertyComplexValueUpdateRequest(URI targetURI, UpdateType type, ClientProperty property) {
        ODataPropertyUpdateRequestImpl req;
        if (!property.hasComplexValue()) {
            throw new IllegalArgumentException("A complex value is required");
        }
        if (this.client.getConfiguration().isUseXHTTPMethod()) {
            req = new ODataPropertyUpdateRequestImpl(this.client, HttpMethod.POST, targetURI, property);
            req.setXHTTPMethod(type.getMethod().name());
        } else {
            req = new ODataPropertyUpdateRequestImpl(this.client, type.getMethod(), targetURI, property);
        }
        return req;
    }

    @Override
    public ODataPropertyUpdateRequest getPropertyCollectionValueUpdateRequest(URI targetURI, ClientProperty property) {
        ODataPropertyUpdateRequestImpl req;
        if (!property.hasCollectionValue()) {
            throw new IllegalArgumentException("A collection value is required");
        }
        if (this.client.getConfiguration().isUseXHTTPMethod()) {
            req = new ODataPropertyUpdateRequestImpl(this.client, HttpMethod.POST, targetURI, property);
            req.setXHTTPMethod(HttpMethod.PUT.name());
        } else {
            req = new ODataPropertyUpdateRequestImpl(this.client, HttpMethod.PUT, targetURI, property);
        }
        return req;
    }

    @Override
    public ODataDeleteRequest getDeleteRequest(URI targetURI) {
        ODataDeleteRequestImpl req;
        if (this.client.getConfiguration().isUseXHTTPMethod()) {
            req = new ODataDeleteRequestImpl(this.client, HttpMethod.POST, targetURI);
            req.setXHTTPMethod(HttpMethod.DELETE.name());
        } else {
            req = new ODataDeleteRequestImpl(this.client, HttpMethod.DELETE, targetURI);
        }
        return req;
    }

    @Override
    public <E extends ClientEntity> ODataMediaEntityCreateRequest<E> getMediaEntityCreateRequest(URI targetURI, InputStream media) {
        return new ODataMediaEntityCreateRequestImpl(this.client, targetURI, media);
    }

    @Override
    public ODataStreamUpdateRequest getStreamUpdateRequest(URI targetURI, InputStream stream) {
        ODataStreamUpdateRequestImpl req;
        if (this.client.getConfiguration().isUseXHTTPMethod()) {
            req = new ODataStreamUpdateRequestImpl(this.client, HttpMethod.POST, targetURI, stream);
            req.setXHTTPMethod(HttpMethod.PUT.name());
        } else {
            req = new ODataStreamUpdateRequestImpl(this.client, HttpMethod.PUT, targetURI, stream);
        }
        return req;
    }

    @Override
    public <E extends ClientEntity> ODataMediaEntityUpdateRequest<E> getMediaEntityUpdateRequest(URI editURI, InputStream media) {
        ODataMediaEntityUpdateRequestImpl req;
        if (this.client.getConfiguration().isUseXHTTPMethod()) {
            req = new ODataMediaEntityUpdateRequestImpl(this.client, HttpMethod.POST, URIUtils.addValueSegment(editURI), media);
            req.setXHTTPMethod(HttpMethod.PUT.name());
        } else {
            req = new ODataMediaEntityUpdateRequestImpl(this.client, HttpMethod.PUT, URIUtils.addValueSegment(editURI), media);
        }
        return req;
    }

    @Override
    public ODataEntityUpdateRequest<ClientSingleton> getSingletonUpdateRequest(UpdateType type, ClientSingleton entity) {
        return this.getEntityUpdateRequest(type, entity);
    }

    @Override
    public ODataEntityUpdateRequest<ClientSingleton> getSingletonUpdateRequest(URI targetURI, UpdateType type, ClientSingleton changes) {
        return this.getEntityUpdateRequest(targetURI, type, changes);
    }

    @Override
    public ODataReferenceAddingRequest getReferenceAddingRequest(URI serviceRoot, URI targetURI, URI reference) {
        URI contextURI = this.client.newURIBuilder(serviceRoot.toASCIIString()).appendMetadataSegment().appendRefSegment().build();
        ResWrap<URI> wrappedPayload = new ResWrap<URI>(contextURI, null, reference);
        return new ODataReferenceAddingRequestImpl(this.client, HttpMethod.POST, targetURI, wrappedPayload);
    }

    @Override
    public ODataReferenceAddingRequest getReferenceSingleChangeRequest(URI serviceRoot, URI targetURI, URI reference) {
        URI contextURI = this.client.newURIBuilder(serviceRoot.toASCIIString()).appendMetadataSegment().build();
        ResWrap<URI> wrappedPayload = new ResWrap<URI>(contextURI, null, reference);
        return new ODataReferenceAddingRequestImpl(this.client, HttpMethod.PUT, targetURI, wrappedPayload);
    }
}

