/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.batchhandler;

import java.util.List;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.batch.BatchFacade;
import org.apache.olingo.server.api.deserializer.batch.BatchDeserializerException;
import org.apache.olingo.server.api.processor.BatchProcessor;
import org.apache.olingo.server.core.ODataHandlerException;
import org.apache.olingo.server.core.ODataHandlerImpl;
import org.apache.olingo.server.core.batchhandler.BatchFacadeImpl;
import org.apache.olingo.server.core.deserializer.batch.BatchParserCommon;

public class BatchHandler {
    private final BatchProcessor batchProcessor;
    private final ODataHandlerImpl oDataHandler;
    private static final String RETURN_MINIMAL = "return=minimal";
    private static final String RETURN_REPRESENTATION = "return=representation";

    public BatchHandler(ODataHandlerImpl oDataHandler, BatchProcessor batchProcessor) {
        this.batchProcessor = batchProcessor;
        this.oDataHandler = oDataHandler;
    }

    public void process(ODataRequest request, ODataResponse response, boolean isStrict) throws ODataApplicationException, ODataLibraryException {
        this.validateRequest(request);
        this.validatePreferHeader(request);
        BatchFacadeImpl operation = new BatchFacadeImpl(this.oDataHandler, this.batchProcessor, isStrict);
        this.batchProcessor.processBatch((BatchFacade)operation, request, response);
    }

    private void validatePreferHeader(ODataRequest request) throws ODataHandlerException {
        List returnPreference = request.getHeaders("Prefer");
        if (null != returnPreference) {
            for (String preference : returnPreference) {
                if (!preference.equals(RETURN_MINIMAL) && !preference.equals(RETURN_REPRESENTATION)) continue;
                throw new ODataHandlerException("Prefer Header not supported: " + preference, ODataHandlerException.MessageKeys.INVALID_PREFER_HEADER, preference);
            }
        }
    }

    private void validateRequest(ODataRequest request) throws BatchDeserializerException {
        this.validateHttpMethod(request);
        this.validateContentType(request);
    }

    private void validateContentType(ODataRequest request) throws BatchDeserializerException {
        BatchParserCommon.parseContentType(request.getHeader("Content-Type"), ContentType.MULTIPART_MIXED, 0);
    }

    private void validateHttpMethod(ODataRequest request) throws BatchDeserializerException {
        if (request.getMethod() != HttpMethod.POST) {
            throw new BatchDeserializerException("Invalid HTTP method", (ODataLibraryException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_METHOD, new String[]{"0"});
        }
    }
}

