/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc;

import io.grpc.Attributes;
import io.grpc.netty.shaded.io.grpc.netty.GrpcHttp2ConnectionHandler;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiationEvent;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiators;
import io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiationEvent;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.ProtocolDetectionResult;
import io.grpc.netty.shaded.io.netty.handler.codec.ProtocolDetectionState;
import io.grpc.netty.shaded.io.netty.handler.codec.haproxy.HAProxyMessage;
import io.grpc.netty.shaded.io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.haproxy.HAProxyTLV;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandler;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.utils.BinaryUtil;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.grpc.constant.AttributeKeys;
import org.apache.rocketmq.remoting.common.TlsMode;
import org.apache.rocketmq.remoting.netty.TlsSystemConfig;

public class ProxyAndTlsProtocolNegotiator
implements InternalProtocolNegotiator.ProtocolNegotiator {
    protected static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    private static final String HA_PROXY_DECODER = "HAProxyDecoder";
    private static final String HA_PROXY_HANDLER = "HAProxyHandler";
    private static final String TLS_MODE_HANDLER = "TlsModeHandler";
    private static final int SSL_RECORD_HEADER_LENGTH = 5;
    private static SslContext sslContext;

    public ProxyAndTlsProtocolNegotiator() {
        sslContext = ProxyAndTlsProtocolNegotiator.loadSslContext();
    }

    public AsciiString scheme() {
        return AsciiString.of((CharSequence)"https");
    }

    public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
        return new ProxyAndTlsProtocolHandler(grpcHandler);
    }

    public void close() {
    }

    /*
     * Exception decompiling
     */
    private static SslContext loadSslContext() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void handleHAProxyTLV(HAProxyTLV tlv, Attributes.Builder builder) {
        byte[] valueBytes = ByteBufUtil.getBytes((ByteBuf)tlv.content());
        if (!BinaryUtil.isAscii((byte[])valueBytes)) {
            return;
        }
        Attributes.Key<String> key = AttributeKeys.valueOf("proxy_protocol_tlv_0x" + String.format("%02x", tlv.typeByteValue()));
        builder.set(key, (Object)new String(valueBytes, CharsetUtil.UTF_8));
    }

    private class TlsModeHandler
    extends ByteToMessageDecoder {
        private ProtocolNegotiationEvent pne = InternalProtocolNegotiationEvent.getDefault();
        private final ChannelHandler ssl;
        private final ChannelHandler plaintext;

        public TlsModeHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            this.ssl = InternalProtocolNegotiators.serverTls((SslContext)sslContext).newHandler(grpcHandler);
            this.plaintext = InternalProtocolNegotiators.serverPlaintext().newHandler(grpcHandler);
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
            try {
                TlsMode tlsMode = TlsSystemConfig.tlsMode;
                if (TlsMode.ENFORCING.equals((Object)tlsMode)) {
                    ctx.pipeline().addAfter(ctx.name(), null, this.ssl);
                } else if (TlsMode.DISABLED.equals((Object)tlsMode)) {
                    ctx.pipeline().addAfter(ctx.name(), null, this.plaintext);
                } else {
                    if (in.readableBytes() < 5) {
                        return;
                    }
                    if (SslHandler.isEncrypted((ByteBuf)in)) {
                        ctx.pipeline().addAfter(ctx.name(), null, this.ssl);
                    } else {
                        ctx.pipeline().addAfter(ctx.name(), null, this.plaintext);
                    }
                }
                ctx.fireUserEventTriggered((Object)this.pne);
                ctx.pipeline().remove((ChannelHandler)this);
            }
            catch (Exception e) {
                log.error("process ssl protocol negotiator failed.", (Throwable)e);
                throw e;
            }
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ProtocolNegotiationEvent) {
                this.pne = (ProtocolNegotiationEvent)evt;
            } else {
                super.userEventTriggered(ctx, evt);
            }
        }
    }

    private class HAProxyMessageHandler
    extends ChannelInboundHandlerAdapter {
        private ProtocolNegotiationEvent pne = InternalProtocolNegotiationEvent.getDefault();

        private HAProxyMessageHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof HAProxyMessage) {
                this.handleWithMessage((HAProxyMessage)msg);
                ctx.fireUserEventTriggered((Object)this.pne);
            } else {
                super.channelRead(ctx, msg);
            }
            ctx.pipeline().remove((ChannelHandler)this);
        }

        private void handleWithMessage(HAProxyMessage msg) {
            try {
                Attributes.Builder builder = InternalProtocolNegotiationEvent.getAttributes((ProtocolNegotiationEvent)this.pne).toBuilder();
                if (StringUtils.isNotBlank((CharSequence)msg.sourceAddress())) {
                    builder.set(AttributeKeys.PROXY_PROTOCOL_ADDR, (Object)msg.sourceAddress());
                }
                if (msg.sourcePort() > 0) {
                    builder.set(AttributeKeys.PROXY_PROTOCOL_PORT, (Object)String.valueOf(msg.sourcePort()));
                }
                if (StringUtils.isNotBlank((CharSequence)msg.destinationAddress())) {
                    builder.set(AttributeKeys.PROXY_PROTOCOL_SERVER_ADDR, (Object)msg.destinationAddress());
                }
                if (msg.destinationPort() > 0) {
                    builder.set(AttributeKeys.PROXY_PROTOCOL_SERVER_PORT, (Object)String.valueOf(msg.destinationPort()));
                }
                if (CollectionUtils.isNotEmpty((Collection)msg.tlvs())) {
                    msg.tlvs().forEach(tlv -> ProxyAndTlsProtocolNegotiator.this.handleHAProxyTLV((HAProxyTLV)tlv, builder));
                }
                this.pne = InternalProtocolNegotiationEvent.withAttributes((ProtocolNegotiationEvent)InternalProtocolNegotiationEvent.getDefault(), (Attributes)builder.build());
            }
            finally {
                msg.release();
            }
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ProtocolNegotiationEvent) {
                this.pne = (ProtocolNegotiationEvent)evt;
            } else {
                super.userEventTriggered(ctx, evt);
            }
        }
    }

    private class ProxyAndTlsProtocolHandler
    extends ByteToMessageDecoder {
        private final GrpcHttp2ConnectionHandler grpcHandler;
        private ProtocolNegotiationEvent pne = InternalProtocolNegotiationEvent.getDefault();

        public ProxyAndTlsProtocolHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            this.grpcHandler = grpcHandler;
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
            try {
                ProtocolDetectionResult ha = HAProxyMessageDecoder.detectProtocol((ByteBuf)in);
                if (ha.state() == ProtocolDetectionState.NEEDS_MORE_DATA) {
                    return;
                }
                if (ha.state() == ProtocolDetectionState.DETECTED) {
                    ctx.pipeline().addAfter(ctx.name(), ProxyAndTlsProtocolNegotiator.HA_PROXY_DECODER, (ChannelHandler)new HAProxyMessageDecoder()).addAfter(ProxyAndTlsProtocolNegotiator.HA_PROXY_DECODER, ProxyAndTlsProtocolNegotiator.HA_PROXY_HANDLER, (ChannelHandler)new HAProxyMessageHandler()).addAfter(ProxyAndTlsProtocolNegotiator.HA_PROXY_HANDLER, ProxyAndTlsProtocolNegotiator.TLS_MODE_HANDLER, (ChannelHandler)new TlsModeHandler(this.grpcHandler));
                } else {
                    ctx.pipeline().addAfter(ctx.name(), ProxyAndTlsProtocolNegotiator.TLS_MODE_HANDLER, (ChannelHandler)new TlsModeHandler(this.grpcHandler));
                }
                Attributes.Builder builder = InternalProtocolNegotiationEvent.getAttributes((ProtocolNegotiationEvent)this.pne).toBuilder();
                builder.set(AttributeKeys.CHANNEL_ID, (Object)ctx.channel().id().asLongText());
                ctx.fireUserEventTriggered((Object)InternalProtocolNegotiationEvent.withAttributes((ProtocolNegotiationEvent)this.pne, (Attributes)builder.build()));
                ctx.pipeline().remove((ChannelHandler)this);
            }
            catch (Exception e) {
                log.error("process proxy protocol negotiator failed.", (Throwable)e);
                throw e;
            }
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ProtocolNegotiationEvent) {
                this.pne = (ProtocolNegotiationEvent)evt;
            } else {
                super.userEventTriggered(ctx, evt);
            }
        }
    }
}

