/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.pop;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.rocketmq.broker.pop.PopConsumerKVStore;
import org.apache.rocketmq.broker.pop.PopConsumerRecord;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.config.AbstractRocksDBStorage;
import org.apache.rocketmq.store.rocksdb.RocksDBOptionsFactory;
import org.rocksdb.AbstractSlice;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactRangeOptions;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopConsumerRocksdbStore
extends AbstractRocksDBStorage
implements PopConsumerKVStore {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqPop");
    private static final byte[] COLUMN_FAMILY_NAME = "popState".getBytes(StandardCharsets.UTF_8);
    private WriteOptions writeOptions;
    private WriteOptions deleteOptions;
    protected ColumnFamilyHandle columnFamilyHandle;

    public PopConsumerRocksdbStore(String filePath) {
        super(filePath);
    }

    protected void initOptions() {
        this.options = RocksDBOptionsFactory.createDBOptions();
        this.writeOptions = new WriteOptions();
        this.writeOptions.setSync(true);
        this.writeOptions.setDisableWAL(false);
        this.writeOptions.setNoSlowdown(false);
        this.deleteOptions = new WriteOptions();
        this.deleteOptions.setSync(true);
        this.deleteOptions.setDisableWAL(false);
        this.deleteOptions.setNoSlowdown(false);
        this.compactRangeOptions = new CompactRangeOptions();
        this.compactRangeOptions.setBottommostLevelCompaction(CompactRangeOptions.BottommostLevelCompaction.kForce);
        this.compactRangeOptions.setAllowWriteStall(true);
        this.compactRangeOptions.setExclusiveManualCompaction(false);
        this.compactRangeOptions.setChangeLevel(true);
        this.compactRangeOptions.setTargetLevel(-1);
        this.compactRangeOptions.setMaxSubcompactions(4);
    }

    protected boolean postLoad() {
        try {
            UtilAll.ensureDirOK((String)this.dbPath);
            this.initOptions();
            ColumnFamilyOptions defaultOptions = RocksDBOptionsFactory.createPopCFOptions();
            ColumnFamilyOptions popStateOptions = RocksDBOptionsFactory.createPopCFOptions();
            this.cfOptions.add(defaultOptions);
            this.cfOptions.add(popStateOptions);
            ArrayList<ColumnFamilyDescriptor> cfDescriptors = new ArrayList<ColumnFamilyDescriptor>();
            cfDescriptors.add(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, defaultOptions));
            cfDescriptors.add(new ColumnFamilyDescriptor(COLUMN_FAMILY_NAME, popStateOptions));
            this.open(cfDescriptors);
            this.defaultCFHandle = (ColumnFamilyHandle)this.cfHandles.get(0);
            this.columnFamilyHandle = (ColumnFamilyHandle)this.cfHandles.get(1);
            log.debug("PopConsumerRocksdbStore init, filePath={}", (Object)this.dbPath);
        }
        catch (Exception e) {
            log.error("PopConsumerRocksdbStore init error, filePath={}", (Object)this.dbPath, (Object)e);
            return false;
        }
        return true;
    }

    @Override
    public String getFilePath() {
        return this.dbPath;
    }

    @Override
    public void writeRecords(List<PopConsumerRecord> consumerRecordList) {
        if (!consumerRecordList.isEmpty()) {
            try (WriteBatch writeBatch = new WriteBatch();){
                for (PopConsumerRecord record : consumerRecordList) {
                    writeBatch.put(this.columnFamilyHandle, record.getKeyBytes(), record.getValueBytes());
                }
                this.db.write(this.writeOptions, writeBatch);
            }
            catch (RocksDBException e) {
                throw new RuntimeException("Write record error", e);
            }
        }
    }

    @Override
    public void deleteRecords(List<PopConsumerRecord> consumerRecordList) {
        if (!consumerRecordList.isEmpty()) {
            try (WriteBatch writeBatch = new WriteBatch();){
                for (PopConsumerRecord record : consumerRecordList) {
                    writeBatch.delete(this.columnFamilyHandle, record.getKeyBytes());
                }
                this.db.write(this.deleteOptions, writeBatch);
            }
            catch (RocksDBException e) {
                throw new RuntimeException("Delete record error", e);
            }
        }
    }

    @Override
    public List<PopConsumerRecord> scanExpiredRecords(long lower, long upper, int maxCount) {
        ArrayList<PopConsumerRecord> consumerRecordList = new ArrayList<PopConsumerRecord>();
        try (ReadOptions scanOptions = new ReadOptions().setIterateLowerBound((AbstractSlice)new Slice(ByteBuffer.allocate(8).putLong(lower).array())).setIterateUpperBound((AbstractSlice)new Slice(ByteBuffer.allocate(8).putLong(upper).array()));
             RocksIterator iterator = this.db.newIterator(this.columnFamilyHandle, scanOptions);){
            iterator.seek(ByteBuffer.allocate(8).putLong(lower).array());
            while (iterator.isValid() && consumerRecordList.size() < maxCount) {
                consumerRecordList.add(PopConsumerRecord.decode(iterator.value()));
                iterator.next();
            }
        }
        return consumerRecordList;
    }

    protected void preShutdown() {
        if (this.writeOptions != null) {
            this.writeOptions.close();
        }
        if (this.deleteOptions != null) {
            this.deleteOptions.close();
        }
        if (this.defaultCFHandle != null) {
            this.defaultCFHandle.close();
        }
    }
}

