/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging.event;

import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.ext.logging.event.EventType;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.ext.logging.event.LogEventMapper;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.ContextUtils;

public class DefaultLogEventMapper
implements LogEventMapper {
    private static final Set<String> BINARY_CONTENT_MEDIA_TYPES = new HashSet<String>();
    private static final String MULTIPART_CONTENT_MEDIA_TYPE = "multipart";

    @Override
    public LogEvent map(Message message) {
        Integer responseCode;
        LogEvent event = new LogEvent();
        event.setMessageId(this.getMessageId(message));
        event.setExchangeId((String)message.getExchange().get((Object)"exchangeId"));
        event.setType(this.getEventType(message));
        if (!Boolean.TRUE.equals(message.get((Object)"decoupled.channel.message")) && (responseCode = (Integer)message.get((Object)Message.RESPONSE_CODE)) != null) {
            event.setResponseCode(responseCode.toString());
        }
        event.setEncoding(DefaultLogEventMapper.safeGet(message, Message.ENCODING));
        event.setHttpMethod(DefaultLogEventMapper.safeGet(message, "org.apache.cxf.request.method"));
        event.setContentType(DefaultLogEventMapper.safeGet(message, "Content-Type"));
        Map<String, String> headerMap = this.getHeaders(message);
        event.setHeaders(headerMap);
        String uri = this.getUri(message);
        if (uri != null) {
            event.setAddress(uri);
        }
        event.setPrincipal(this.getPrincipal(message));
        event.setBinaryContent(this.isBinaryContent(message));
        event.setMultipartContent(this.isMultipartContent(message));
        this.setEpInfo(message, event);
        return event;
    }

    private String getPrincipal(Message message) {
        String principal = this.getJAASPrincipal();
        if (principal != null) {
            return principal;
        }
        SecurityContext sc = (SecurityContext)message.get(SecurityContext.class);
        if (sc != null && sc.getUserPrincipal() != null) {
            return sc.getUserPrincipal().getName();
        }
        AuthorizationPolicy authPolicy = (AuthorizationPolicy)message.get(AuthorizationPolicy.class);
        if (authPolicy != null) {
            return authPolicy.getUserName();
        }
        return null;
    }

    private String getJAASPrincipal() {
        StringBuilder principals = new StringBuilder();
        Iterator<? extends Object> principalIt = this.getJAASPrincipals();
        while (principalIt.hasNext()) {
            principals.append(principalIt.next());
            if (!principalIt.hasNext()) continue;
            principals.append(",");
        }
        if (principals.length() == 0) {
            return null;
        }
        return principals.toString();
    }

    private Iterator<? extends Object> getJAASPrincipals() {
        Subject subject = Subject.getSubject(AccessController.getContext());
        return subject != null && subject.getPrincipals() != null ? subject.getPrincipals().iterator() : Collections.emptyIterator();
    }

    private Map<String, String> getHeaders(Message message) {
        Map headers = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        HashMap<String, String> result = new HashMap<String, String>();
        if (headers == null) {
            return result;
        }
        for (Map.Entry entry : headers.entrySet()) {
            if (((List)entry.getValue()).size() == 1) {
                result.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
                continue;
            }
            String[] valueAr = ((List)entry.getValue()).toArray(new String[0]);
            result.put((String)entry.getKey(), valueAr.toString());
        }
        return result;
    }

    private String getUri(Message message) {
        String query;
        String uri = DefaultLogEventMapper.safeGet(message, "org.apache.cxf.request.url");
        if (uri == null) {
            String address = DefaultLogEventMapper.safeGet(message, Message.ENDPOINT_ADDRESS);
            uri = DefaultLogEventMapper.safeGet(message, "org.apache.cxf.request.uri");
            if (uri != null && uri.startsWith("/")) {
                if (address != null && !address.startsWith(uri)) {
                    if (address.endsWith("/") && address.length() > 1) {
                        address = address.substring(0, address.length());
                    }
                    uri = address + uri;
                }
            } else {
                uri = address;
            }
        }
        if ((query = DefaultLogEventMapper.safeGet(message, Message.QUERY_STRING)) != null) {
            return uri + "?" + query;
        }
        return uri;
    }

    private boolean isBinaryContent(Message message) {
        String contentType = DefaultLogEventMapper.safeGet(message, "Content-Type");
        return contentType != null && BINARY_CONTENT_MEDIA_TYPES.contains(contentType);
    }

    private boolean isMultipartContent(Message message) {
        String contentType = DefaultLogEventMapper.safeGet(message, "Content-Type");
        return contentType != null && contentType.startsWith(MULTIPART_CONTENT_MEDIA_TYPE);
    }

    private boolean isSOAPMessage(Message message) {
        Binding binding = message.getExchange().getBinding();
        return binding != null && binding.getClass().getSimpleName().equals("SoapBinding");
    }

    private String getMessageId(Message message) {
        AddressingProperties addrProp = ContextUtils.retrieveMAPs((Message)message, (boolean)false, (boolean)MessageUtils.isOutbound((Message)message), (boolean)false);
        return addrProp != null && addrProp.getMessageID() != null ? addrProp.getMessageID().getValue() : UUID.randomUUID().toString();
    }

    private String getOperationName(Message message) {
        Message reqMsg;
        Message inMsg;
        String operationName = null;
        BindingOperationInfo boi = null;
        boi = message.getExchange().getBindingOperationInfo();
        if (null == boi) {
            boi = this.getOperationFromContent(message);
        }
        if (null == boi && null != (inMsg = message.getExchange().getInMessage()) && null != (reqMsg = inMsg.getExchange().getInMessage())) {
            boi = this.getOperationFromContent(reqMsg);
        }
        if (null != boi) {
            operationName = boi.getName().toString();
        }
        return operationName;
    }

    private BindingOperationInfo getOperationFromContent(Message message) {
        XMLStreamReader xmlReader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
        if (xmlReader != null) {
            return ServiceModelUtil.getOperation((Exchange)message.getExchange(), (QName)xmlReader.getName());
        }
        return null;
    }

    private Message getEffectiveMessage(Message message) {
        boolean isRequestor = MessageUtils.isRequestor((Message)message);
        boolean isOutbound = MessageUtils.isOutbound((Message)message);
        if (isRequestor) {
            return isOutbound ? message : message.getExchange().getOutMessage();
        }
        return isOutbound ? message.getExchange().getInMessage() : message;
    }

    private String getRestOperationName(Message curMessage) {
        String basePath;
        int baseUriLength;
        Message message = this.getEffectiveMessage(curMessage);
        String httpMethod = DefaultLogEventMapper.safeGet(message, "org.apache.cxf.request.method");
        if (httpMethod == null) {
            return "";
        }
        String path = "";
        String requestUri = DefaultLogEventMapper.safeGet(message, "org.apache.cxf.request.uri");
        if (requestUri != null && (path = requestUri.substring(baseUriLength = (basePath = DefaultLogEventMapper.safeGet(message, Message.BASE_PATH)) != null ? basePath.length() : 0)).isEmpty()) {
            path = "/";
        }
        return new StringBuffer().append(httpMethod).append('[').append(path).append(']').toString();
    }

    private static String safeGet(Message message, String key) {
        if (!message.containsKey((Object)key)) {
            return null;
        }
        Object value = message.get((Object)key);
        return value instanceof String ? value.toString() : null;
    }

    private EventType getEventType(Message message) {
        boolean isOutbound;
        boolean isRequestor = MessageUtils.isRequestor((Message)message);
        boolean isFault = MessageUtils.isFault((Message)message);
        if (!isFault) {
            boolean bl = isFault = !this.isSOAPMessage(message) && this.isRESTFault(message);
        }
        if (isOutbound = MessageUtils.isOutbound((Message)message)) {
            if (isFault) {
                return EventType.FAULT_OUT;
            }
            return isRequestor ? EventType.REQ_OUT : EventType.RESP_OUT;
        }
        if (isFault) {
            return EventType.FAULT_IN;
        }
        return isRequestor ? EventType.RESP_IN : EventType.REQ_IN;
    }

    private boolean isRESTFault(Message message) {
        Object opName = message.getExchange().get((Object)"org.apache.cxf.resource.operation.name");
        if (opName == null) {
            return true;
        }
        Integer responseCode = (Integer)message.get((Object)Message.RESPONSE_CODE);
        return responseCode != null && responseCode >= 400;
    }

    private void setEpInfo(Message message, LogEvent event) {
        EndpointInfo endpoint = this.getEPInfo(message);
        event.setPortName(endpoint.getName());
        event.setPortTypeName(endpoint.getName());
        String opName = this.isSOAPMessage(message) ? this.getOperationName(message) : this.getRestOperationName(message);
        event.setOperationName(opName);
        if (endpoint.getService() != null) {
            this.setServiceInfo(endpoint.getService(), event);
        }
    }

    private void setServiceInfo(ServiceInfo service, LogEvent event) {
        event.setServiceName(service.getName());
        InterfaceInfo iface = service.getInterface();
        event.setPortTypeName(iface.getName());
    }

    private EndpointInfo getEPInfo(Message message) {
        Endpoint ep = message.getExchange().getEndpoint();
        return ep == null ? new EndpointInfo() : ep.getEndpointInfo();
    }

    static {
        BINARY_CONTENT_MEDIA_TYPES.add("application/octet-stream");
        BINARY_CONTENT_MEDIA_TYPES.add("image/png");
        BINARY_CONTENT_MEDIA_TYPES.add("image/jpeg");
        BINARY_CONTENT_MEDIA_TYPES.add("image/gif");
    }
}

