/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.amqp.Decimal64;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.impl.AtomicElement;
import org.apache.qpid.proton.codec.impl.Element;

class Decimal64Element
extends AtomicElement<Decimal64> {
    private final Decimal64 _value;

    Decimal64Element(Element parent, Element prev, Decimal64 d) {
        super(parent, prev);
        this._value = d;
    }

    @Override
    public int size() {
        return this.isElementOfArray() ? 8 : 9;
    }

    @Override
    public Decimal64 getValue() {
        return this._value;
    }

    @Override
    public Data.DataType getDataType() {
        return Data.DataType.DECIMAL64;
    }

    @Override
    public int encode(ByteBuffer b) {
        int size2 = this.size();
        if (b.remaining() >= size2) {
            if (size2 == 9) {
                b.put((byte)-124);
            }
            b.putLong(this._value.getBits());
            return size2;
        }
        return 0;
    }
}

